local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local announceTriggered = false
function OnScriptLoaded(level)
  SoundInit()
end
function OnFirstStart(level)
  SetAmbience()
end
function OnStart(level)
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = SetAmbience,
    fn = SetAmbience
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = SetAmbience,
    fn = SetAmbience
  })
end
function xpl930_Landing_Lvl01_Hide()
  GameObjects.xpl930_Landing_Lvl01:Hide()
end
function AnimatePlatform()
  GameObjects.MovingPlat:PlayAnimToEnd()
end
function AreaAnnounce()
  print("Old Announce Logic")
end
function AreaAnnounceNEW()
  if announceTriggered == false and game.IsPaused() == false then
    local uiCalls = require("ui.uicalls")
    uiCalls.UI_Event_DiscoverLocation("BeachRuins")
    LD.CallFunctionAfterDelay(TrophyCheck, 1)
    announceTriggered = true
    timer.StartLevelTimer(3, function()
      game.World.StoreCheckpoint()
    end)
  end
end
function GolemCheck()
  local Xpl930_Golem = GameObjects.Cbt_Xpl930_Script.LuaObjectScript.GetGolem()
  if Xpl930_Golem then
    GameObjects.CA_Golem_OnAlert.LuaObjectScript.Enable()
    GameObjects.CA_Golem_OnAlert2.LuaObjectScript.Enable()
    GameObjects.LTW_AvoidGolem.LuaObjectScript.Enable()
  else
    GameObjects.CA_Golem_OnAlert.LuaObjectScript.Disable()
    GameObjects.CA_Golem_OnAlert2.LuaObjectScript.Enable()
    GameObjects.LTW_AvoidGolem.LuaObjectScript.Disable()
  end
end
function TrophyCheck()
  local regionTable = {
    "IslandArch",
    "IslandShipwreck",
    "IslandClimb",
    "BeachRuins",
    "BeachCave",
    "BeachMaze",
    "BeachShipwreck",
    "BeachTower",
    "BeachWaterfall"
  }
  local trueCheck = true
  local regionInfo, regionState
  for _, regions in pairs(regionTable) do
    regionInfo = game.Map.GetRegionInfo(regions)
    regionState = regionInfo.State
    if regionState ~= tweaks.eTokenState.kDiscovered then
      trueCheck = false
    end
  end
  if trueCheck == true then
    game.UnlockTrophy(12)
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
local waterLevel = {}
waterLevel.Bottom = 2
waterLevel.Medium = 1
waterLevel.Top = 0
local bottomWaterAmbience, mediumWaterAmbience, topWaterAmbience
function SoundInit()
  bottomWaterAmbience = GameObjects.BottomWaterAmbience
  mediumWaterAmbience = GameObjects.MediumWaterAmbience
  topWaterAmbience = GameObjects.TopWaterAmbience
end
function SetAmbience()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel == waterLevel.Bottom then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Show()
  elseif newWaterLevel == waterLevel.Medium then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Show()
    bottomWaterAmbience:Hide()
  elseif newWaterLevel == waterLevel.Top then
    topWaterAmbience:Show()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Hide()
  end
end
function HideAllAmbience()
  topWaterAmbience:Hide()
  mediumWaterAmbience:Hide()
  bottomWaterAmbience:Hide()
end
