local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local thisLevel, Area_0_Encounter_1, Area_0_Encounter_2, Area_0_Encounter_3, Area_1_Encounter_1, Area_1_Encounter_2, Area_2_Encounter_1, Area_3_Encounter_1, Area_4_Encounter_1, A1_ZM_0, A2_ZM_1
function OnScriptLoaded(level, obj)
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") <= 339 then
    Area_0_QuestFight_1()
    Area_0_Fight_1()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_0_QuestFight_2()
    Area_1_Fight_1()
    Area_1_Fight_Repop()
    Area_2_Fight_1()
  end
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  GameObjects.EntZn_Arena_RestartFight940:HideEntityVolume()
end
function BeachCaveQuestEncounter()
  if LD.GetCurrentWaterLevel() == 1 then
    Area_0_Encounter_1:Start()
    GameObjects.EntZn_Arena_RestartFight940:ShowEntityVolume()
  end
  if LD.GetCurrentWaterLevel() == 2 then
    Area_0_Encounter_2:Start()
    GameObjects.EntZn_Arena_RestartFight940:ShowEntityVolume()
  end
end
function EnableQuestGiverBeachCave()
  local QuestGiver = thisLevel:GetGameObject("LakeOfNine_QuestGiver")
  QuestGiver.LuaObjectScript.EnableLakeOfNine()
  GameObjects.EntZn_Arena_RestartFight940:HideEntityVolume()
end
function TurnOnWulverFight()
  local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Objective_01_SpotD")
  if questState == "Complete" and LD.GetCurrentWaterLevel() == 2 then
    Area_2_Encounter_1:Start()
  end
end
function Area_0_QuestFight_1()
  Area_0_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 0]EC:1 WL1 Lake of Nine Quest Helwalkers Awake XPL940", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl940_AI_01",
    LeashZone = "LeashZoneXpl940",
    LoadCheck = true,
    StartMusic = "SND_MX_XPL940_brazier_fight_in",
    StopMusic = "SND_MX_XPL940_brazier_fight_out"
  })
  Area_0_Encounter_1:AddWave({
    {
      spawners = "Bandit_DEAD01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_DEAD02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Bandit_DEAD03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_0_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Bandit_ICE_DEAD01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_ICE_DEAD02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_0_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_RestartFight940)
  Area_0_Encounter_1:OnEnemyDeath(function()
    Area_0_Encounter_1:StartWave(2)
  end, {count = 2})
  Area_0_Encounter_1:OnComplete(EnableQuestGiverBeachCave)
end
function Area_0_QuestFight_2()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  Area_0_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 0]EC:2 WL2 Lake of Nine Quest Helwalkers Awake XPL940", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl940_AI_03",
    LeashZone = "LeashZoneXpl941",
    LoadCheck = true,
    StartMusic = "SND_MX_XPL940_brazier_fight_in",
    StopMusic = "SND_MX_XPL940_brazier_fight_out"
  })
  Area_0_Encounter_2:AddWave({
    {
      spawners = "Bandit_DEAD01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "Bandit_DEAD02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = powerLevel01
    },
    {
      spawners = "Bandit_DEAD03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2,
      powerLevel = powerLevel02
    }
  })
  Area_0_Encounter_2:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Bandit_ICE_DEAD01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel02
    },
    {
      spawners = "Bandit_ICE_DEAD02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1,
      powerLevel = powerLevel02
    }
  })
  Area_0_Encounter_2:SetStartZone(GameObjects.EntZn_Arena_RestartFight940)
  Area_0_Encounter_2:OnComplete(EnableQuestGiverBeachCave)
  Area_0_Encounter_2:OnEnemyDeath(function()
    Area_0_Encounter_2:StartWave(2)
  end, {count = 2})
end
function Area_0_Fight_1()
  Area_0_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 0]EC: XPL940 Water Level 1 Patrolling Draugr", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl940_AI_01",
    LeashZone = "LeashZoneXpl940",
    LoadCheck = false
  })
  Area_0_Encounter_3:AddWave({
    {
      spawners = "H_Draugr_2_Patrol_1",
      spawnLocators = "A0_O_Loc_05",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "DW_Draugr_1_Patrol_1",
      spawnLocators = "A0_O_Loc_06",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.25
    }
  })
  Area_0_Encounter_3:SetStartZone(GameObjects.EntZn_Arena_Spawn_0)
  Area_0_Encounter_3:SetAlertZone(GameObjects.EntZn_Arena_Attack_0)
  Area_0_Encounter_3:OnComplete(Enable_CAforLakeofNine_Banter)
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC: Water lvl 2 Wolf Spawns XPL940", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl940_AI_02",
    LeashZone = "LeashZoneWolves",
    LoadCheck = false
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Wolf_L2_EATING",
      spawnLocators = "A1_U_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 1.4
    },
    {
      spawners = "Wolf_L2_EATING",
      spawnLocators = "A1_U_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_L3_LAYING",
      spawnLocators = "A1_U_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_1)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wolf_Feral")
  end)
end
function Area_1_Fight_Repop()
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC: Water lvl 2 Repopulation Wolves XPL940", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl940_AI_02",
    LeashZone = "LeashZoneWolves",
    LoadCheck = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 1]EC: Water lvl 2 Wolf Spawns XPL940",
      "[Area 2]EC: Water lvl 2 Wulver spawns XPL940",
      "[Area 0]EC:2 WL2 Lake of Nine Quest Helwalkers Awake XPL940"
    }
  })
  Area_4_Encounter_1:AddWave({
    {
      spawners = "Wolf_L6_CAUTIOUS",
      spawnLocators = "A1_U_Loc_08",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_L8_LAYING",
      spawnLocators = "A1_U_Loc_07",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 2
    }
  })
  Area_4_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_4)
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC: Water lvl 2 Wulver spawns XPL940", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl940_AI_03",
    LeashZone = "LeashZoneXpl941",
    LoadCheck = false,
    StartMusic = "SND_MX_XPL940_bandits_fight_in",
    StopMusic = "SND_MX_XPL940_bandits_fight_out"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Wulver_4_Ambush",
      spawnLocators = "A2_O_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wulver_5_JumpDown",
      spawnLocators = "A2_O_Loc_04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_1:OnComplete(Enable_CAforLakeofNine_Banter)
  Area_2_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Power")
  end)
end
function Enable_CAforLakeofNine_Banter()
end
