local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local BeaconLit = false
local RunicChestUnlocked = false
local announceTriggered = false
function OnScriptLoaded(level)
  SoundInit()
end
function OnFirstStart(level)
  SetAmbience()
  GameObjects.SpecialPickups_DragonEnd_001:Hide()
  GameObjects.Dragon_CoL:Hide()
  GameObjects.misc_common_tier6_xpl940_1.LuaObjectScript.Disable()
  game.Compass.SetGatewayMarkerIsOpen("BC_940_Helper4", false)
end
function OnStart(level)
  local Zipline_TopPOS = GameObjects.Zipline_Top
  local Zipline_BottomPOS = GameObjects.Zipline_Bottom
  local Zipline_fromShipVis = GameObjects.zipline_XPL940.Child
  Zipline_fromShipVis:SetZiplineStartAndEnd(Zipline_TopPOS:GetWorldPosition(), Zipline_BottomPOS:GetWorldPosition())
  LD.RegisterForCineUpdate(level, {
    {
      at = 500,
      immediateFn = function()
        GameObjects.SpecialPickups_DragonEnd_001:Show()
        GameObjects.Dragon_CoL:Show()
        GameObjects.misc_common_tier6_xpl940_1.LuaObjectScript.Enable()
      end,
      fn = function()
        GameObjects.SpecialPickups_DragonEnd_001:Show()
        GameObjects.Dragon_CoL:Show()
        GameObjects.misc_common_tier6_xpl940_1.LuaObjectScript.Enable()
      end
    }
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = function()
      LowerWater_Level01()
      SetAmbience()
    end,
    fn = function()
      LowerWater_Level01()
      SetAmbience()
    end
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = function()
      LowerWater_Level02()
      SetAmbience()
    end,
    fn = function()
      LowerWater_Level02()
      SetAmbience()
    end
  })
end
function LowerWater_Level01()
  GameObjects.xpl940_Blockingrocks_Lvl01:Show()
  GameObjects.xpl940_Blockingrocks_Lvl02:Hide()
end
function LowerWater_Level02()
  GameObjects.xpl940_Blockingrocks_Lvl01:Hide()
  GameObjects.Beach_10_Straight.Child:HideCollision()
  GameObjects.xpl940_Blockingrocks_Lvl02:Show()
end
function AreaAnnounce_BeachCave()
  print("no")
end
function AreaAnnounce_BeachCaveNEW()
  if announceTriggered == false and game.IsPaused() == false then
    local uiCalls = require("ui.uicalls")
    uiCalls.UI_Event_DiscoverLocation("BeachCave")
    LD.CallFunctionAfterDelay(TrophyCheck, 1)
    announceTriggered = true
  end
end
function TrophyCheck()
  local regionTable = {
    "IslandArch",
    "IslandShipwreck",
    "IslandClimb",
    "BeachRuins",
    "BeachCave",
    "BeachMaze",
    "BeachShipwreck",
    "BeachTower",
    "BeachWaterfall"
  }
  local trueCheck = true
  local regionInfo, regionState
  for _, regions in pairs(regionTable) do
    regionInfo = game.Map.GetRegionInfo(regions)
    regionState = regionInfo.State
    if regionState ~= tweaks.eTokenState.kDiscovered then
      trueCheck = false
    end
  end
  if trueCheck == true then
    game.UnlockTrophy(12)
  end
end
function Disable_CAforLakeofNine_Banter()
  BeaconLit = true
  GameObjects.LakeOfNineBanterCheckCave:HideEntityVolume()
  GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Disable()
end
function QuestLakeOfNineBanter_Enter()
  if BeaconLit == false then
    local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
    local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent")
    local lo9Banter00Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed00")
    local lo9Banter01Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed01")
    local lo9Banter02Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed02")
    local lo9Banter03Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed03")
    if questState == "Active" then
      if progress == 1 and lo9Banter01Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      elseif progress == 2 and lo9Banter02Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      elseif progress == 3 and lo9Banter03Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      end
    elseif questState == "Inactive" and lo9Banter00Played == false then
      GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
    end
  end
end
function QuestLakeOfNineBanter_Exit()
  GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Disable()
end
function QuestLakeOfNineBanter()
  if BeaconLit == false then
    local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
    local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent")
    local lo9Banter00Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed00")
    local lo9Banter01Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed01")
    local lo9Banter02Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed02")
    local lo9Banter03Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed03")
    if questState == "Active" then
      if progress == 1 and lo9Banter01Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier2")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed01", true)
      elseif progress == 2 and lo9Banter02Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier3")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed02", true)
      elseif progress == 3 and lo9Banter03Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier4")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed03", true)
      end
    elseif questState == "Inactive" and lo9Banter00Played == false then
      game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier1")
      LD.SetEntityVariable("QST_UB_Lo9_BanterPlayed00", true)
    end
  end
end
function UnlockRunicChest()
  RunicChestUnlocked = true
  GameObjects.CA_Runic_Puzzled.LuaObjectScript.Disable()
end
function EnablePuzzledCA()
  if RunicChestUnlocked == false then
    GameObjects.CA_Runic_Puzzled.LuaObjectScript.Enable()
  end
end
function ZiplinePath()
  game.Compass.SetGatewayMarkerIsOpen("BC_940_Helper4", true)
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    BeaconLit = BeaconLit
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  BeaconLit = savedInfo.BeaconLit
end
function StoreCheckpoint()
  game.World.StoreCheckpoint()
end
local waterLevel = {}
waterLevel.Bottom = 2
waterLevel.Medium = 1
waterLevel.Top = 0
local bottomWaterAmbience, mediumWaterAmbience, topWaterAmbience
function SoundInit()
  bottomWaterAmbience = GameObjects.BottomWaterAmbience
  mediumWaterAmbience = GameObjects.MediumWaterAmbience
  topWaterAmbience = GameObjects.TopWaterAmbience
end
function SetAmbience()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel == waterLevel.Bottom then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Show()
  elseif newWaterLevel == waterLevel.Medium then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Show()
    bottomWaterAmbience:Hide()
  elseif newWaterLevel == waterLevel.Top then
    topWaterAmbience:Show()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Hide()
  end
end
function HideAllAmbience()
  topWaterAmbience:Hide()
  mediumWaterAmbience:Hide()
  bottomWaterAmbience:Hide()
end
