local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, player, Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_3, Area_2_Encounter_1, Area_3_Encounter_1, Area_3_Encounter_2, Area_3_Encounter_4, Area_3_Encounter_5, Area_3_Encounter_6, BeachMazeSleep01ZoneMonitor, BeachMazeSleep02ZoneMonitor, ZM_A2_E1_Attack
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  if game.Level.GetVariable("CompletedCineNumber") <= 339 then
    Area_1_QuestFight_1()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_1_QuestFight_2()
    Area_3_Fight_4()
    Area_3_Fight_6()
    Area_1_Fight_1_Repop()
  end
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  GameObjects.EntZn_Arena_RestartFight950_1:HideEntityVolume()
end
function BeachMazeQuestEncounter()
  if LD.GetCurrentWaterLevel() == 1 then
    Area_1_Encounter_2:Start()
    GameObjects.EntZn_Arena_RestartFight950_1:ShowEntityVolume()
  end
  if LD.GetCurrentWaterLevel() == 2 then
    Area_1_Encounter_3:Start()
    GameObjects.EntZn_Arena_RestartFight950_1:ShowEntityVolume()
  end
end
function EnableQuestGiverMaze()
  local QuestGiver = thisLevel:GetGameObject("LakeOfNine_QuestGiver")
  QuestGiver.LuaObjectScript.EnableLakeOfNine()
  GameObjects.EntZn_Arena_RestartFight950_1:HideEntityVolume()
end
function Area_1_Fight_1_Repop()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL2 Crawler XPL950 Repop", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl950_AI_02",
    LeashZone = "LeashZone950_3",
    LoadCheck = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 2]EC:1 Beach Maze Crawler Spawn XPL950",
      "[Area 2]EC:1 Beach Maze Dark Ones & Elite XPL950"
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Darkone_H6_E_SFA",
      spawnLocators = "A1_Loc_O_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Crawler_N8_SFG",
      spawnLocators = "A1_Loc_O_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5.2
    },
    {
      spawners = "Darkone_H7_SFA",
      spawnLocators = "A1_Loc_O_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.2
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Spawn)
end
function Area_1_QuestFight_1()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL1 Nine Lakes Quest Encounter XPL950", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl950_AI_01",
    LeashZone = "LeashZone950_2",
    LoadCheck = true,
    StartMusic = "SND_MX_XPL950_brazier_fight_in",
    StopMusic = "SND_MX_XPL950_brazier_fight_out"
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Brawler_JumpDown",
      spawnLocators = "A2_Loc_O_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Crawler_N_SFG",
      spawnLocators = "A1_Loc_O_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Crawler_1_SFG",
      spawnLocators = "A1_Loc_O_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8.8
    }
  })
  Area_1_Encounter_2:SetStartZone(GameObjects.EntZn_Arena_RestartFight950_1)
  Area_1_Encounter_2:OnComplete(EnableQuestGiverMaze)
  Area_1_Encounter_2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Brawler")
  end)
  Area_1_Encounter_2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Tatzelwurm_Stinger")
  end)
end
function Area_1_QuestFight_2()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 340 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 3
    powerLevel02 = 4
  elseif 600 <= cineNumber then
    powerLevel01 = 4
    powerLevel02 = 5
  end
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL2 Nine Lakes Quest Encounter XPL950", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl950_AI_02",
    LeashZone = "LeashZone950_3",
    LoadCheck = true,
    StartMusic = "SND_MX_XPL950_brazier_fight_in",
    StopMusic = "SND_MX_XPL950_brazier_fight_out"
  })
  Area_1_Encounter_3:AddWave({
    {
      spawners = "Brawler_JumpDown",
      spawnLocators = "A2_Loc_O_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = powerLevel02
    },
    {
      spawners = "Crawler_N_SFG",
      spawnLocators = "A5_Loc_L_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    },
    {
      spawners = "Crawler_N_SFG",
      spawnLocators = "A1_Loc_O_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8,
      powerLevel = powerLevel01
    },
    {
      spawners = "Crawler_N_SFG",
      spawnLocators = "A1_Loc_O_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8.8,
      powerLevel = powerLevel01
    }
  })
  Area_1_Encounter_3:SetStartZone(GameObjects.EntZn_Arena_RestartFight950_1)
  Area_1_Encounter_3:OnComplete(EnableQuestGiverMaze)
  Area_1_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Brawler")
  end)
  Area_1_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Tatzelwurm_Stinger")
  end)
end
function Area_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Beach Maze Heavy Draugr after 1st climb up XPL950", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone950_3",
    LoadCheck = true
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Draugr_H2_2H_SFG",
      spawnLocators = "A3_Loc_L_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl950_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_3_Encounter_1:SetStartZone(GameObjects.EntZn_Area_3_Spawn_1)
end
function Area_3_Fight_4()
  Area_3_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Beach Maze Dark Ones & Elite XPL950", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZone950_3",
    LoadCheck = false
  })
  Area_3_Encounter_4:AddWave({
    {
      spawners = "Darkone_H_S3_SFL8",
      spawnWad = "Xpl950_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Darkone_H_S4_SFR8",
      spawnWad = "Xpl950_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Darkone_L4_Elite",
      spawnWad = "Xpl950_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_3_Encounter_4:SetStartZone(GameObjects.EntZn_Area_3_Spawn_4)
  BeachMazeSleep02ZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Area_3_Alert_2"))
  BeachMazeSleep02ZoneMonitor:OnEnter(function()
    Area_3_Encounter_4:AlertEnemies()
  end)
  Area_3_Encounter_4:OnComplete(Enable_CAforLakeofNine_Banter)
  BeachMazeSleep02ZoneMonitor:SetTriggerCountLimit(1)
  Area_3_Encounter_4:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Elite")
  end)
end
function Area_3_Fight_6()
  Area_3_Encounter_6 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Beach Maze Crawler Spawn XPL950", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZone950_3",
    LoadCheck = false
  })
  Area_3_Encounter_6:AddWave({
    {
      spawners = "Crawler_N_SFG",
      spawnLocators = "A8_Loc_L_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl950_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Crawler_N_SFG",
      spawnLocators = "A8_Loc_L_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl950_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_3_Encounter_6:SetStartZone(GameObjects.EntZn_Area_3_Spawn_6)
end
function Enable_CAforLakeofNine_Banter()
end
