local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local thisLevel, Hive_01b, Hive_01c, Hive_01d, Hive_01g, TraversePath_Jump_xx_01, Slider_Wall_01, Slider_Wall_04
local banterBrotherFoundComplete = false
local BeaconLit = false
local TendrilTunnelCleared = false
local TrollKicked = false
local cameraChainRecenter = {
  TimeStart = 0,
  TimeDuration = 1.3,
  LockRecenter = 0.46,
  RotationSpace = 1,
  YawRange = -1,
  TriggerLeft = 165,
  ReturnLeft = 160,
  ReturnRight = 160,
  TriggerRight = 155,
  PitchRange = -1,
  TriggerUp = 14,
  ReturnUp = 9,
  ReturnDown = 8,
  TriggerDown = 5
}
function OnScriptLoaded(level)
  thisLevel = level
  Hive_01b = GameObjects.Hive_01b
  Hive_01c = GameObjects.Hive_01c
  Hive_01d = GameObjects.Hive_01d
  Slider_Wall_01 = GameObjects.Slider_Wall_01
  Slider_Wall_04 = GameObjects.Slider_Wall_04
  TraversePath_Jump_xx_01 = GameObjects.TraversePath_Jump_xx_01
  Hive_01g = GameObjects.Hive_01g
  SoundInit()
  local goChainPull = level:FindGameObject("ChainPullOfficial_xx01")
  if goChainPull ~= nil and goChainPull.LuaObjectScript ~= nil then
    goChainPull.LuaObjectScript.OverrideDefaultCameraRecenter(true, cameraChainRecenter)
    goChainPull.LuaObjectScript.OverrideDefaultCameraPitch(true, 8)
    goChainPull.LuaObjectScript.OverrideDefaultCameraYaw(true, 160)
  end
end
function OnFirstStart(level)
  SetAmbience()
  TraversePath_Jump_xx_01:HideTraversePath()
  Hive_01b:JumpAnimToFrame(0)
  Hive_01b:PauseAnim()
  Slider_Wall_01:JumpAnimToFrame(0)
  Slider_Wall_01:PauseAnim()
  Slider_Wall_04:JumpAnimToFrame(0)
  Slider_Wall_04:PauseAnim()
  TraversePath_Jump_xx_01:HideTraversePath()
  Hive_01g:Show()
end
function OnStart(level)
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = function()
      LowerWater_Level01()
      SetAmbience()
    end,
    fn = function()
      LowerWater_Level01()
      SetAmbience()
    end
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = function()
      LowerWater_Level02()
      SetAmbience()
    end,
    fn = function()
      LowerWater_Level02()
      SetAmbience()
    end
  })
  GameObjects.LiftDoor_Gate_StaysOpen1.LuaObjectScript.ExcludeSon()
  GameObjects.LiftDoor_Gate_StaysOpen2_xx.LuaObjectScript.ExcludeSon()
end
function LowerWater_Level01()
  GameObjects.xpl950_Blockingrocks_Lvl01:Show()
  GameObjects.Beach_10_Concave_No_Boat_waterLevel1.Child:ShowCollision()
  GameObjects.LootLockedChest_SpinType_xx01.Child.Child.LuaObjectScript.HideChest()
  local interact = GameObjects.LootLockedChest_SpinType_xx01.Child.Child.LuaObjectScript.GetFakeInteractZone()
  interact:SetHintYRange(0)
  interact:SetHintAngle(0)
  interact = GameObjects.LootLockedChest_SpinType_xx01.Child.Child.LuaObjectScript.GetInteractZone()
  interact:SetHintYRange(0)
  interact:SetHintAngle(0)
end
function LowerWater_Level02()
  GameObjects.xpl950_Blockingrocks_Lvl01:Hide()
  GameObjects.Beach_10_Concave_No_Boat_waterLevel1.Child:HideCollision()
  GameObjects.LootLockedChest_SpinType_xx01.Child.Child.LuaObjectScript.ShowChest()
  local interact = GameObjects.LootLockedChest_SpinType_xx01.Child.Child.LuaObjectScript.GetFakeInteractZone()
  interact:SetHintYRange(2)
  interact:SetHintAngle(360)
  interact = GameObjects.LootLockedChest_SpinType_xx01.Child.Child.LuaObjectScript.GetInteractZone()
  interact:SetHintYRange(2)
  interact:SetHintAngle(360)
end
function SetMazeSolved()
  GameObjects.DrainContextZone.LuaObjectScript.Disable()
end
function Hive_01b_Open()
  Hive_01b:PlayAnimToEnd()
  Hive_01b:OnAnimationDone(thisLevel, "StoreCheckpoint", {Force = true})
end
function TendrilTunnelClear()
  if TendrilTunnelCleared == false then
    GameObjects.Roots_Ground_8m15_decay1.LuaObjectScript.StartDecay()
    GameObjects.Roots_Ground_8m15_decay.LuaObjectScript.StartDecay()
    GameObjects.Roots_Ground_8m15_decay2.LuaObjectScript.StartDecay()
    Hive_01g_Hide()
    GameObjects.Tendril_Celebrate.LuaObjectScript.Trigger()
    GameObjects.CA_TendrilGate_Observe.LuaObjectScript.Disable()
    TendrilTunnelCleared = true
  end
end
function BeachTendrilClear()
  GameObjects.Roots_Ground_8m15_decay6.LuaObjectScript.StartDecay()
  GameObjects.Roots_Ground_8m15_decay9.LuaObjectScript.StartDecay()
  GameObjects.RopeDrop_xx01xx_02.LuaObjectScript.EnableTraversePath()
  tendrilCutMusic()
  BeachHiveBlocker_Hide()
end
function TendrilGateClear()
  Hive_01c_Hide()
  GameObjects.Roots_Ground_8m15_decay7.LuaObjectScript.StartDecay()
  GameObjects.Roots_Ground_8m15_decay10.LuaObjectScript.StartDecay()
end
function TendrilGate02Clear()
  Hive_01d_Open()
  GameObjects.Roots_Ground_8m15_decay4.LuaObjectScript.StartDecay()
  GameObjects.Roots_Ground_8m15_decay3.LuaObjectScript.StartDecay()
  GameObjects.Roots_Ground_8m15_decay5.LuaObjectScript.StartDecay()
  GameObjects.Roots_Ground_8m15_decay8.LuaObjectScript.StartDecay()
end
function EnableTendrilObserve()
  if TendrilTunnelCleared == false then
    GameObjects.CA_TendrilGate_Observe.LuaObjectScript.Enable()
  end
end
function EnableTrollKick()
  if TrollKicked == false then
    GameObjects.CA_KickTroll.LuaObjectScript.Enable()
  end
end
function SetTrollKicked()
  if TrollKicked == false then
    TrollKicked = true
  end
end
function Hive_01c_Hide()
  LD.CallFunctionAfterDelay(function()
    Hive_01c:Hide()
    game.World.StoreCheckpoint()
  end, 2)
end
function Hive_01d_Open()
  LD.CallFunctionAfterDelay(function()
    Hive_01d:Hide()
    game.World.StoreCheckpoint()
  end, 2)
  GameObjects.TraversePath_Jump_xx_01:ShowTraversePath()
end
function AreaAnnounce_BeachMaze()
  local uiCalls = require("ui.uicalls")
  uiCalls.UI_Event_DiscoverLocation("BeachMaze")
  LD.CallFunctionAfterDelay(TrophyCheck, 1)
end
function TrophyCheck()
  local regionTable = {
    "IslandArch",
    "IslandShipwreck",
    "IslandClimb",
    "BeachRuins",
    "BeachCave",
    "BeachMaze",
    "BeachShipwreck",
    "BeachTower",
    "BeachWaterfall"
  }
  local trueCheck = true
  local regionInfo, regionState
  for _, regions in pairs(regionTable) do
    regionInfo = game.Map.GetRegionInfo(regions)
    regionState = regionInfo.State
    if regionState ~= tweaks.eTokenState.kDiscovered then
      trueCheck = false
    end
  end
  if trueCheck == true then
    game.UnlockTrophy(12)
  end
end
function Hive_01g_Show()
  Hive_01g:Show()
  Hive_01g:OnAnimationDone(thisLevel, "StoreCheckpoint", {Force = true})
end
function Hive_01g_Hide()
  LD.CallFunctionAfterDelay(function()
    Hive_01g:Hide()
    game.World.StoreCheckpoint()
  end, 2)
end
function Slider_Wall_01_Open()
  GameObjects.Slider_Wall_01:PlayAnimToEnd()
  GameObjects.Slider_Wall_01:OnAnimationDone(thisLevel, "StoreCheckpoint", {Force = true})
end
function Slider_Wall_01_Close()
  GameObjects.Slider_Wall_01:PlayAnimToEnd(-1)
  GameObjects.Slider_Wall_01:OnAnimationDone(thisLevel, "StoreCheckpoint", {Force = true})
end
function Slider_Wall_04_Open()
  GameObjects.Slider_Wall_04:PlayAnimToEnd()
  GameObjects.Slider_Wall_04:OnAnimationDone(thisLevel, "StoreCheckpoint", {Force = true})
end
function Slider_Wall_04_Close()
  GameObjects.Slider_Wall_04:PlayAnimToEnd(-1)
  GameObjects.Slider_Wall_04:OnAnimationDone(thisLevel, "StoreCheckpoint", {Force = true})
end
function BeachHiveBlocker_Hide()
  GameObjects.BeachHiveBlocker:Hide()
end
function StoreCheckpoint()
  game.World.StoreCheckpoint()
end
function PlayBanterBrotherFound01(level)
  local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness01_Objective_01")
  if questState == "Active" and banterBrotherFoundComplete == false then
    game.Audio.PlayBanter("UB1_EnteringLevel")
    banterBrotherFoundComplete = true
  end
end
function Enable_CAforLakeofNine_Banter()
  GameObjects.LakeOfNineBanterCheckCave:ShowEntityVolume()
end
function Disable_CAforLakeofNine_Banter()
  BeaconLit = true
  GameObjects.LakeOfNineBanterCheckCave:HideEntityVolume()
end
function QuestLakeOfNineBanter_Enter()
  if BeaconLit == false then
    local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
    local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent")
    local lo9Banter00Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed00")
    local lo9Banter01Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed01")
    local lo9Banter02Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed02")
    local lo9Banter03Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed03")
    if questState == "Active" then
      if progress == 1 and lo9Banter01Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      elseif progress == 2 and lo9Banter02Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      elseif progress == 3 and lo9Banter03Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      end
    elseif questState == "Inactive" and lo9Banter00Played == false then
      GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
    end
  end
end
function QuestLakeOfNineBanter_Exit()
  GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Disable()
end
function QuestLakeOfNineBanter()
  if BeaconLit == false then
    local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
    local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent")
    local lo9Banter00Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed00")
    local lo9Banter01Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed01")
    local lo9Banter02Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed02")
    local lo9Banter03Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed03")
    if questState == "Active" then
      if progress == 1 and lo9Banter01Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier2")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed01", true)
      elseif progress == 2 and lo9Banter02Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier3")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed02", true)
      elseif progress == 3 and lo9Banter03Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier4")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed03", true)
      end
    elseif questState == "Inactive" and lo9Banter00Played == false then
      game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier1")
      LD.SetEntityVariable("QST_UB_Lo9_BanterPlayed00", true)
    end
  end
end
local waterLevel = {}
waterLevel.Bottom = 2
waterLevel.Medium = 1
waterLevel.Top = 0
local bottomWaterAmbience, mediumWaterAmbience, topWaterAmbience
local musicXpl950 = false
function SoundInit()
  bottomWaterAmbience = GameObjects.BottomWaterAmbience_Xpl950
  mediumWaterAmbience = GameObjects.MediumWaterAmbience_Xpl950
  topWaterAmbience = GameObjects.TopWaterAmbience_Xpl950
end
function SetAmbience()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel == waterLevel.Bottom then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Show()
  elseif newWaterLevel == waterLevel.Medium then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Show()
    bottomWaterAmbience:Hide()
  elseif newWaterLevel == waterLevel.Top then
    topWaterAmbience:Show()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Hide()
  end
end
function HideAllAmbience()
  topWaterAmbience:Hide()
  mediumWaterAmbience:Hide()
  bottomWaterAmbience:Hide()
end
function tendrilCutMusic()
  game.Audio.StartMusic("SND_MX_XPL950_cliffs_intro")
end
function xpl950ClimbMusic()
  if musicXpl950 == false then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL950_explore1_in")
    musicXpl950 = true
  end
end
function leavingXpl950Music()
  if musicXpl950 == true then
    game.Audio.StartMusic("SND_MX_XPL950_idle")
    musicXpl950 = false
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    banterBrotherFoundComplete = banterBrotherFoundComplete,
    BeaconLit = BeaconLit,
    TendrilTunnelCleared = TendrilTunnelCleared,
    TrollKicked = TrollKicked
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  banterBrotherFoundComplete = savedInfo.banterBrotherFoundComplete
  BeaconLit = savedInfo.BeaconLit
  TendrilTunnelCleared = savedInfo.TendrilTunnelCleared
  TrollKicked = savedInfo.TrollKicked
end
function StoreCheckpoint()
  game.World.StoreCheckpoint()
end
