local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local timers = require("level.timer")
local thisLevel, player, Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_3, Area_2_Encounter_1, Area_2_Encounter_2, Area_3_Encounter_1, Area_4_Encounter_1, Area_5_Encounter_1, Area_6_Encounter_1, GolemAlertZoneMonitor, DeadFreightBeachShipZoneMonitor
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  if game.Level.GetVariable("CompletedCineNumber") <= 339 then
    Area_1_QuestFight_1()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_1_QuestFight_2()
    Area_1_Fight_1()
    Area_2_Fight_1()
    Area_3_Fight_1()
    Area_4_Fight_1()
    Area_5_Fight_1()
    Area_3_Fight_Repop()
  end
  game.QuestManager.RegisterListener(obj, "Quest_UnfinishedBusiness04_Objective_01")
end
function OnFirstStart(level, obj)
  GameObjects.EntZn_Arena_RestartFight960:HideEntityVolume()
  GameObjects.EntZn_Arena_DFZone:HideEntityVolume()
  GameObjects.EntZn_Arena_DFZone_Alert:HideEntityVolume()
end
function SpawnWulverUpper()
end
function SpawnWolvesUpper()
end
function BeachShipQuestEncounter()
  if LD.GetCurrentWaterLevel() == 1 then
    Area_1_Encounter_2:Start()
    GameObjects.EntZn_Arena_RestartFight960:ShowEntityVolume()
  end
  if LD.GetCurrentWaterLevel() == 2 then
    Area_1_Encounter_3:Start()
    GameObjects.EntZn_Arena_RestartFight960:ShowEntityVolume()
  end
end
function EnableQuestGiverBeachShip()
  local QuestGiver = thisLevel:GetGameObject("LakeOfNine_QuestGiver")
  QuestGiver.LuaObjectScript.EnableLakeOfNine()
  GameObjects.EntZn_Arena_RestartFight960:HideEntityVolume()
end
function BeachShip_DF_Complete()
  game.QuestManager.IncrementQuestProgress("Quest_UnfinishedBusiness04_Objective_01", 1)
  LD.CompleteQuest("Quest_UnfinishedBusiness04_Objective_01_SpotB")
  _G.StartLevelTimer(2, QuestBanter)
end
function QuestBanter()
  local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness04_Objective_01")
  if progress == 1 then
    game.Audio.PlayBanter("UB4_DF_FirstBeach")
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Objective_01")
  elseif progress == 2 then
    game.Audio.PlayBanter("UB4_DF_SecondBeach")
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Objective_01")
  elseif progress == 3 then
    game.Audio.PlayBanter("UB4_DF_ThirdBeach")
    LD.SetRecentlyActivatedQuest("Quest_UnfinishedBusiness04_Return")
  end
end
function Area_1_QuestFight_1()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL1 Lake of Nine Seidr Ambush XPL960", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl960_1",
    LoadCheck = true,
    StartMusic = "SND_MX_XPL960_brazier_fight_in",
    StopMusic = "SND_MX_XPL960_brazier_fight_out"
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Bandit_SEI_SPAWN01",
      spawnLocators = "A0_LN_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Bandit_SEI_SPAWN02",
      spawnLocators = "A0_LN_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    },
    {
      spawners = "Bandit_SEI_SPAWN01",
      spawnLocators = "A0_LN_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8
    },
    {
      spawners = "Flyer_SEID_SPAWN",
      spawnLocators = "A0_LN_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    },
    {
      spawners = "Flyer_SEID_SPAWN",
      spawnLocators = "A0_LN_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8
    }
  })
  Area_1_Encounter_2:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Bandit_SEI_SH_SPAWN01",
      spawnLocators = "A0_LN_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Bandit_SEI_SH_SPAWN01",
      spawnLocators = "A0_LN_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    }
  })
  Area_1_Encounter_2:SetStartZone(GameObjects.EntZn_Arena_RestartFight960)
  Area_1_Encounter_2:OnEnemyDeath(function()
    Area_1_Encounter_2:StartWave(2)
  end, {count = 3})
  Area_1_Encounter_2:OnComplete(EnableQuestGiverBeachShip)
  Area_1_Encounter_2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Base")
  end)
end
function Area_1_QuestFight_2()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 WL2 Lake of Nine Seidr Ambush XPL960", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl960_1",
    LoadCheck = true,
    StartMusic = "SND_MX_XPL960_brazier_fight_in",
    StopMusic = "SND_MX_XPL960_brazier_fight_out"
  })
  Area_1_Encounter_3:AddWave({
    {
      spawners = "Bandit_3_SEI_SPAWN01",
      spawnLocators = "A0_LN_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = powerLevel02
    },
    {
      spawners = "Bandit_4_SEI_SPAWN02",
      spawnLocators = "A0_LN_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8,
      powerLevel = powerLevel01
    },
    {
      spawners = "Bandit_4_SEI_SPAWN02",
      spawnLocators = "A0_LN_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8,
      powerLevel = powerLevel01
    },
    {
      spawners = "Flyer_SEID_SPAWN",
      spawnLocators = "A0_LN_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8,
      powerLevel = powerLevel02
    },
    {
      spawners = "Flyer_4_SEID_SPAWN",
      spawnLocators = "A0_LN_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8,
      powerLevel = powerLevel02
    }
  })
  Area_1_Encounter_3:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Bandit_SEI_SH_SPAWN02",
      spawnLocators = "A0_LN_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = powerLevel01
    },
    {
      spawners = "Bandit_SEI_SH_SPAWN02",
      spawnLocators = "A0_LN_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8,
      powerLevel = powerLevel02
    }
  })
  Area_1_Encounter_3:SetStartZone(GameObjects.EntZn_Arena_RestartFight960)
  Area_1_Encounter_3:OnComplete(EnableQuestGiverBeachShip)
  Area_1_Encounter_3:OnEnemyDeath(function()
    Area_1_Encounter_3:StartWave(2)
  end, {count = 3})
  Area_1_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Base")
  end)
end
function Area_2_Fight_1()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Dead Freight Helwalker Ambush XPL960", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl960_2",
    LoadCheck = false
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Bandit_DEAD02",
      spawnLocators = "A0_DF_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      markerID = "FreightRise1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = powerLevel02
    },
    {
      spawners = "Bandit_SH_DEAD01",
      spawnLocators = "A0_DF_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      markerID = "FreightRise2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8,
      powerLevel = powerLevel02
    },
    {
      spawners = "Bandit_SH_DEAD02",
      spawnLocators = "A0_DF_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8,
      powerLevel = powerLevel01
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_DFZone)
  Area_2_Encounter_1:OnComplete(BeachShip_DF_Complete)
  DeadFreightBeachShipZoneMonitor = monitors.CreateEntityZoneMonitor(player, thisLevel:GetGameObject("EntZn_Arena_DFZone_Alert"))
  DeadFreightBeachShipZoneMonitor:OnEnter(function()
    Area_2_Encounter_1:AlertEnemies()
  end)
  DeadFreightBeachShipZoneMonitor:SetTriggerCountLimit()
end
function Area_1_Fight_1()
  local powerLevel01
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 600 <= cineNumber then
    powerLevel01 = 5
  end
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC: Golem Fight XPL960", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl960_4",
    LoadCheck = false,
    StartMusic = "SND_MX_XPL960_golem_fight_in",
    StopMusic = "SND_MX_XPL960_golem_fight_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Golem_SLEEP",
      spawnLocators = "A0_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0,
      powerLevel = powerLevel01
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_1)
  Area_1_Encounter_1:OnStart(function()
    LD.SetMarkerState("CAL_100_BeachShipFight", 1)
  end)
  Area_1_Encounter_1:OnComplete(function()
    LD.SetMarkerState("CAL_100_BeachShipFight", 0)
  end)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ancient_Fire")
  end)
end
function WakeUpGolem()
  if Area_1_Encounter_1 ~= nil then
    Area_1_Encounter_1:AlertEnemies()
  end
end
function Area_3_Fight_1()
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC: Wulver Fight XPL960", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl960_2"
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Wulver00_AMBUSH",
      spawnLocators = "A0_U_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_3_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_2_1)
  Area_3_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Speed")
  end)
end
function Area_3_Fight_Repop()
  Area_6_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC: Wulver Fight Repopulation XPL960", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl960_2",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 2]EC: Wulver Fight XPL960",
      "[Area 1]EC: Golem Fight XPL960"
    }
  })
  Area_6_Encounter_1:AddWave({
    {
      spawners = "Wulver00_L6_IDLE",
      spawnLocators = "A0_U_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wulver00_L7_IDLE",
      spawnLocators = "A0_U_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_6_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_5)
end
function Area_4_Fight_1()
  Area_4_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC: Wolf Fight Upper Curse Area XPL960", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl960_1"
  })
  Area_4_Encounter_1:AddWave({
    {
      spawners = "Wolf_Pois_CAUTIOUS",
      spawnLocators = "A0_U2_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_Pois_CAUTIOUS",
      spawnLocators = "A0_U2_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.2
    }
  })
  Area_4_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_2_2)
  Area_4_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wolf_Rabid")
  end)
end
function Area_5_Fight_1()
  Area_5_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 3]EC: Wolf Fight XPL960", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl960_3",
    LoadCheck = false
  })
  Area_5_Encounter_1:AddWave({
    {
      spawners = "Wolf_Pois_EATING",
      spawnLocators = "A0_L_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_Pois_LAYING",
      spawnLocators = "A0_L_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl960_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  Area_5_Encounter_1:SetStartZone(GameObjects.EntZn_Arena_Spawn_3)
end
