local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local Hive_01A1, Hive_01B1, Hive_01C1
local announceTriggered = false
local Spin_01, Spin_01_Flipper
local dfQuest960 = false
local BeaconLit = false
function OnScriptLoaded(level)
  Spin_01 = GameObjects.Spin_01_Spinner
  Spin_01_Flipper = Spin_01:FindSingleGOByName("FlipperModule")
  SoundInit()
end
function OnFirstStart(level)
  SetAmbience()
  Hide_WL2_Bombs()
  GameObjects.CA_RunicDoor_StayOut_Zone:HideEntityVolume()
  GameObjects.Climb_FromZip:HideTraversePath()
  GameObjects.Boost2_fromLowerBeach:HideTraverseLink()
  GameObjects.coffin_tier3_xpl960_2.LuaObjectScript.Disable()
  GameObjects.coffin_tier3_xpl960_3.LuaObjectScript.Disable()
  GameObjects.LootDirtPatch_04.LuaObjectScript.Disable()
  GameObjects.DeadBody_Cubby_01.LuaObjectScript.Disable()
  GameObjects.DeadBody_Cubby_02.LuaObjectScript.Disable()
  GameObjects.corpse_common_tier3_xpl960_2.LuaObjectScript.Disable()
  GameObjects.corpse_common_tier3_xpl960_3.LuaObjectScript.Disable()
  GameObjects.corpse_common_tier3_xpl960_4.LuaObjectScript.Disable()
  game.Compass.SetGatewayMarkerIsOpen("BSW_960_Helper5", false)
  game.Compass.SetGatewayMarkerIsOpen("BSW_960_Helper4", false)
  GameObjects.____BlockingRocks_toLevel2:Show()
  GameObjects.____VisLanguage_atLevel2:Hide()
  GameObjects.Zipline_fromShipwreck:HideTraverseLink()
  GameObjects.Climb_ToRunicDoor:HideTraversePath()
  GameObjects.Climb_ToDock:HideTraversePath()
  GameObjects.LowerBeach_02_Bomb:Hide()
  Spin_01_Flipper.LuaObjectScript.DisableRotation()
end
function OnStart(level)
  local Zipline_TopPOS = GameObjects.Zipline_Top
  local Zipline_BottomPOS = GameObjects.Zipline_Bottom
  local Zipline_fromShipVis = GameObjects.zipline_Xpl960.Child
  Zipline_fromShipVis:SetZiplineStartAndEnd(Zipline_TopPOS:GetWorldPosition(), Zipline_BottomPOS:GetWorldPosition())
  local FlipBlocker_Col = GameObjects.SpinBlocked_Col
  FlipBlocker_Col.LuaObjectScript.RegisterOnWeaponEmbed(FlipperBlocked)
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = function()
      LowerWater_Level01()
      SetAmbience()
    end,
    fn = function()
      LowerWater_Level01()
      SetAmbience()
    end
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = function()
      LowerWater_Level02()
      SetAmbience()
    end,
    fn = function()
      LowerWater_Level02()
      SetAmbience()
    end
  })
  GameObjects.spreadDoor.LuaObjectScript.SetAllowSyncWithSonNotAvailable(true)
  SoundOnStart()
end
function LowerWater_Level01()
  Hide_WL2_Bombs()
  GameObjects.coffin_tier3_xpl960_1.LuaObjectScript.Disable()
  GameObjects.____BlockingRocks_toLevel2:Show()
  GameObjects.____VisLanguage_atLevel2:Hide()
  GameObjects.Zipline_fromShipwreck:HideTraverseLink()
  GameObjects.Climb_ToRunicDoor:HideTraversePath()
  GameObjects.Climb_ToDock:HideTraversePath()
  game.Compass.SetGatewayMarkerIsOpen("BSW_960_Helper", true)
  game.Compass.SetGatewayMarkerIsOpen("BSW_960_Helper4", true)
end
function LowerWater_Level02()
  Show_WL2_Bombs()
  GameObjects.coffin_tier3_xpl960_1.LuaObjectScript.Enable()
  GameObjects.____BlockingRocks_toLevel2:Hide()
  GameObjects.____VisLanguage_atLevel2:Show()
  GameObjects.Zipline_fromShipwreck:ShowTraverseLink()
  GameObjects.Climb_ToRunicDoor:ShowTraversePath()
  GameObjects.Climb_ToDock:ShowTraversePath()
  game.Compass.SetGatewayMarkerIsOpen("BSW_960_Helper", false)
end
function Enable_CAforLakeofNine_Banter()
  GameObjects.LakeOfNineBanterCheckCave:ShowEntityVolume()
end
function Disable_CAforLakeofNine_Banter()
  BeaconLit = true
  GameObjects.LakeOfNineBanterCheckCave:HideEntityVolume()
  GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Disable()
end
function QuestLakeOfNineBanter_Enter()
  if BeaconLit == false then
    local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
    local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent")
    local lo9Banter00Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed00")
    local lo9Banter01Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed01")
    local lo9Banter02Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed02")
    local lo9Banter03Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed03")
    if questState == "Active" then
      if progress == 1 and lo9Banter01Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      elseif progress == 2 and lo9Banter02Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      elseif progress == 3 and lo9Banter03Played == false then
        GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
      end
    elseif questState == "Inactive" and lo9Banter00Played == false then
      GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Enable()
    end
  end
end
function QuestLakeOfNineBanter_Exit()
  GameObjects.CA_LakeofNine_Banter_01.LuaObjectScript.Disable()
end
function QuestLakeOfNineBanter()
  if BeaconLit == false then
    local _, progress = game.QuestManager.GetQuestProgressAndGoal("Quest_UnfinishedBusiness05_Objective_01")
    local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness05_Parent")
    local lo9Banter00Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed00")
    local lo9Banter01Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed01")
    local lo9Banter02Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed02")
    local lo9Banter03Played = game.Level.GetVariable("QST_UB_Lo9_BanterPlayed03")
    if questState == "Active" then
      if progress == 1 and lo9Banter01Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier2")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed01", true)
      elseif progress == 2 and lo9Banter02Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier3")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed02", true)
      elseif progress == 3 and lo9Banter03Played == false then
        game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier4")
        game.Level.SetVariable("QST_UB_Lo9_BanterPlayed03", true)
      end
    elseif questState == "Inactive" and lo9Banter00Played == false then
      game.Audio.PlayBanterNonCritical("XPL0_SeeBrazier1")
      LD.SetEntityVariable("QST_UB_Lo9_BanterPlayed00", true)
    end
  end
end
function AreaAnnounce()
  print("no")
end
function AreaAnnounceNEW()
  if announceTriggered == false and game.IsPaused() == false then
    uiCalls.UI_Event_DiscoverLocation("BeachShipwreck")
    LD.CallFunctionAfterDelay(TrophyCheck, 1)
    announceTriggered = true
    game.World.StoreCheckpoint()
  end
end
function Hide_WL2_Bombs()
  GameObjects.Spin_01_Bomb_01:Hide()
  GameObjects.Spin_01_Bomb_02:Hide()
  GameObjects.BombField_Bomb_Hanging1:Hide()
  GameObjects.BombField_Bomb_Hanging1_Rope:Hide()
  GameObjects.DoorBlocker_Bomb_Hanging:Hide()
  GameObjects.DoorBlocker_Bomb_Support:Hide()
  GameObjects.KillingFloor_Bomb_01:Hide()
  GameObjects.BeachBlocker_Bomb1:Hide()
  GameObjects.BeachBlocker_Bomb2:Hide()
  GameObjects.BeachBlocker_Bomb3:Hide()
end
function Show_WL2_Bombs()
  GameObjects.Spin_01_Bomb_01:Show()
  GameObjects.Spin_01_Bomb_02:Show()
  GameObjects.BombField_Bomb_Hanging1:Show()
  GameObjects.BombField_Bomb_Hanging1_Rope:Show()
  GameObjects.DoorBlocker_Bomb_Hanging:Show()
  GameObjects.DoorBlocker_Bomb_Support:Show()
  GameObjects.KillingFloor_Bomb_01:Show()
  GameObjects.BeachBlocker_Bomb1:Show()
  GameObjects.BeachBlocker_Bomb2:Show()
  GameObjects.BeachBlocker_Bomb3:Show()
end
function TrophyCheck()
  local regionTable = {
    "IslandArch",
    "IslandShipwreck",
    "IslandClimb",
    "BeachRuins",
    "BeachCave",
    "BeachMaze",
    "BeachShipwreck",
    "BeachTower",
    "BeachWaterfall"
  }
  local trueCheck = true
  local regionInfo, regionState
  for _, regions in pairs(regionTable) do
    regionInfo = game.Map.GetRegionInfo(regions)
    regionState = regionInfo.State
    if regionState ~= tweaks.eTokenState.kDiscovered then
      trueCheck = false
    end
  end
  if trueCheck == true then
    game.UnlockTrophy(12)
  end
end
function SaveCheckpoint()
  game.World.StoreCheckpoint()
end
function BeachShip_DF_TurnOnZones()
  if game.Level.GetVariable("CAL_DeadFreightEncounters") == true and dfQuest960 == false then
    dfQuest960 = true
    GameObjects.EntZn_Arena_DFZone:ShowEntityVolume()
    GameObjects.EntZn_Arena_DFZone_Alert:ShowEntityVolume()
  end
end
function Trigger_BombField()
  timer.StartLevelTimer(1.7, Destroy_BombField_2)
end
function Destroy_BombField()
  local BombScratch = GameObjects.BombField_Bomb_Support
  local Bomb = BombScratch:FindSingleGOByName("bombBag")
  if Bomb.Broken == false then
    Bomb:Break()
  end
  LD.BreakObject(GameObjects.BombField_Blocker_01)
  LD.BreakObject(GameObjects.BombField_Blocker_02)
  LD.BreakObject(GameObjects.BombField_Blocker_03)
  LD.BreakObject(GameObjects.BombField_Blocker_04)
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.BombField_Blocker_05)
    LD.BreakObject(GameObjects.BombField_Blocker_06)
    LD.BreakObject(GameObjects.BombField_Blocker_07)
    LD.BreakObject(GameObjects.BombField_Blocker_08)
  end, 0.1)
  GameObjects.BombField_Blocker_Col:Hide()
end
function Destroy_BombField_2()
  local BombScratch = GameObjects.BombField_Bomb_Hanging1
  local Bomb = BombScratch:FindSingleGOByName("bombBag")
  if Bomb.Broken == false then
    Bomb:Break()
  end
  Destroy_BombField()
end
function Trigger_DoorBlocker()
  timer.StartLevelTimer(1.4, Destroy_DoorBlocker)
end
function Destroy_DoorBlocker()
  local BombScratch = GameObjects.DoorBlocker_Bomb_Hanging
  local Bomb = BombScratch:FindSingleGOByName("bombBag")
  if Bomb.Broken == false then
    Bomb:Break()
  end
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.DoorBlocker_Bomb_Support)
    LD.BreakObject(GameObjects.DoorBlocker_ScornStone)
    LD.BreakObject(GameObjects.DoorBlocker_Blocker_01)
    LD.BreakObject(GameObjects.DoorBlocker_Blocker_02)
  end, 0.1)
end
function Destroy_DoorBlocker_2()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.KillingFloor_ScornStone2)
    LD.BreakObject(GameObjects.KillingFloor_02_Blocker_01)
    LD.BreakObject(GameObjects.KillingFloor_02_Blocker_02)
    LD.BreakObject(GameObjects.KillingFloor_02_Blocker_03)
  end, 0.1)
end
function Destroy_InitialBlocker()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.InitialBlocker_Blocker_01)
    LD.BreakObject(GameObjects.InitialBlocker_Blocker_02)
    LD.BreakObject(GameObjects.InitialBlocker_Blocker_03)
    LD.BreakObject(GameObjects.InitialBlocker_ScornStone)
    GameObjects.Climb_FromZip:ShowTraversePath()
  end, 0.1)
end
function Trigger_ClimbToUpperBlocker()
  timer.StartLevelTimer(0.5, Destroy_ClimbToUpperBlocker)
end
function Destroy_ClimbToUpperBlocker()
  GameObjects.ClimbToUpper_ExtRocks:Hide()
end
function Trigger_SpinnerBlocker()
  timer.StartLevelTimer(0.5, Destroy_SpinnerBlocker)
  BreakSpinFlipper()
end
function Destroy_SpinnerBlocker()
  GameObjects.BlockedSpinner_ExtRocks:Hide()
end
function Trigger_LowerBeachBlocker_01()
  timer.StartLevelTimer(0.2, Destroy_LowerBeachBlocker_01)
end
function Destroy_LowerBeachBlocker_01()
  GameObjects.LowerBeach_01_ExtRocks:Hide()
end
function Trigger_LowerBeachBlocker_02()
  timer.StartLevelTimer(0.2, Destroy_LowerBeachBlocker_02)
  game.Compass.SetGatewayMarkerIsOpen("BSW_960_Helper5", true)
end
function Destroy_LowerBeachBlocker_02()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.LowerBeach_02_Blocker_01)
    LD.BreakObject(GameObjects.LowerBeach_02_Blocker_02)
    LD.BreakObject(GameObjects.LowerBeach_02_Blocker_03)
    LD.BreakObject(GameObjects.LowerBeach_02_Blocker_04)
    LD.BreakObject(GameObjects.LowerBeach_02_Blocker_05)
    LD.BreakObject(GameObjects.LowerBeach_02_Blocker_06)
    LD.BreakObject(GameObjects.LowerBeach_02_Blocker_07)
    LD.BreakObject(GameObjects.LowerBeach_02_Blocker_08)
  end, 0.1)
  GameObjects.Boost2_fromLowerBeach:ShowTraverseLink()
end
function Enable_LowerBeachBlocker_02_Bomb()
  GameObjects.LowerBeach_02_Bomb:Show()
end
function Destroy_RunicCubby()
  LD.CallFunctionAfterDelay(function()
    GameObjects.CubbyCollision:HideCollision()
    LD.BreakObject(GameObjects.Cubby_Blocker_01)
    LD.BreakObject(GameObjects.Cubby_Blocker_02)
    LD.BreakObject(GameObjects.Cubby_Blocker_03)
    LD.BreakObject(GameObjects.Cubby_Blocker_04)
    LD.BreakObject(GameObjects.Cubby_Blocker_05)
    LD.BreakObject(GameObjects.Cubby_Blocker_06)
    LD.BreakObject(GameObjects.Cubby_Blocker_07)
    LD.BreakObject(GameObjects.Cubby_Blocker_08)
    LD.BreakObject(GameObjects.Cubby_Blocker_09)
  end, 0.1)
  GameObjects.DeadBody_Cubby_01.LuaObjectScript.Enable()
  GameObjects.DeadBody_Cubby_02.LuaObjectScript.Enable()
  GameObjects.corpse_common_tier3_xpl960_2.LuaObjectScript.Enable()
  GameObjects.corpse_common_tier3_xpl960_3.LuaObjectScript.Enable()
  GameObjects.corpse_common_tier3_xpl960_4.LuaObjectScript.Enable()
end
function Destroy_RockStack_01()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.RockStack_01_Blocker_01)
    LD.BreakObject(GameObjects.RockStack_01_Blocker_02)
    LD.BreakObject(GameObjects.RockStack_01_Blocker_03)
    LD.BreakObject(GameObjects.RockStack_01_Blocker_04)
    LD.BreakObject(GameObjects.RockStack_01_Blocker_05)
    LD.BreakObject(GameObjects.RockStack_01_Blocker_06)
    LD.BreakObject(GameObjects.RockStack_01_Blocker_07)
  end, 0.1)
  GameObjects.coffin_tier3_xpl960_3.LuaObjectScript.Enable()
end
function Destroy_RockStack_02()
  LD.CallFunctionAfterDelay(function()
    GameObjects.RockStack_02_NavBlocker:Hide()
    LD.BreakObject(GameObjects.RockStack_02_Blocker_01)
    LD.BreakObject(GameObjects.RockStack_02_Blocker_02)
    LD.BreakObject(GameObjects.RockStack_02_Blocker_03)
  end, 0.1)
end
function Destroy_RockStack_03()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.RockStack_03_Blocker_01)
    LD.BreakObject(GameObjects.RockStack_03_Blocker_02)
    GameObjects.LootDirtPatch_04.LuaObjectScript.Enable()
  end, 0.1)
end
function Trigger_ScoreStone_Setup_02_A()
  timer.StartLevelTimer(0.2, Destroy_ScoreStone_Setup_02_A)
end
function Destroy_ScoreStone_Setup_02_A()
  GameObjects.ScoreStone_Setup_02_ExtRocks_A:Hide()
end
function Enable_ClimbToShip()
  LD.BreakObject(GameObjects.Ship_B_Blocker_Close_01)
  LD.BreakObject(GameObjects.Ship_B_Blocker_Close_02)
  LD.BreakObject(GameObjects.Ship_B_Blocker_Close_03)
  LD.BreakObject(GameObjects.Ship_B_Blocker_Close_04)
  LD.BreakObject(GameObjects.Ship_B_Blocker_Close_05)
  LD.BreakObject(GameObjects.Ship_B_Blocker_Close_06)
  LD.BreakObject(GameObjects.Ship_B_Blocker_Close_07)
  LD.BreakObject(GameObjects.Ship_ScornStone)
  GameObjects.Ship_B_CollisionBlocker:Hide()
end
function Enable_RockBlockedChest()
  LD.BreakObject(GameObjects.Ship_A_Bomb_01)
  LD.BreakObject(GameObjects.Ship_A_Bomb_02)
  LD.BreakObject(GameObjects.Ship_A_Bomb_03)
  LD.BreakObject(GameObjects.Ship_A_Blocker_Close_01)
  LD.BreakObject(GameObjects.Ship_A_Blocker_Close_02)
  LD.BreakObject(GameObjects.Ship_A_Blocker_Close_03)
  LD.BreakObject(GameObjects.Ship_A_Blocker_Close_04)
  LD.BreakObject(GameObjects.Ship_A_Blocker_Close_05)
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.Ship_A_Blocker_Far_01)
    LD.BreakObject(GameObjects.Ship_A_Blocker_Far_02)
    LD.BreakObject(GameObjects.Ship_A_Blocker_Far_03)
    LD.BreakObject(GameObjects.Ship_A_Blocker_Far_04)
    LD.BreakObject(GameObjects.Ship_A_Blocker_Far_05)
    LD.BreakObject(GameObjects.Ship_A_Blocker_Far_06)
    LD.BreakObject(GameObjects.Ship_A_Blocker_Far_07)
    GameObjects.coffin_tier3_xpl960_2.LuaObjectScript.Enable()
  end, 0.1)
end
function Destroy_UpperBlockerSetup_01()
  LD.BreakObject(GameObjects.BeachBlocker_Bomb1)
  LD.BreakObject(GameObjects.BeachBlocker_Bomb2)
  LD.BreakObject(GameObjects.BeachBlocker_Bomb3)
  LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Close_001)
  LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Close_002)
  LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Close_003)
  LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Close_004)
  LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Close_005)
  LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Close_006)
  LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Close_007)
  LD.BreakObject(GameObjects.BeachBlocker_ScornStone)
  GameObjects.BeachBlocker_Collision:HideCollision()
  LD.CallFunctionAfterDelay(function()
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_001)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_002)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_003)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_004)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_005)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_006)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_007)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_008)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_009)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_010)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_011)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_012)
    LD.BreakObject(GameObjects.BeachBlocker_BlockerStone_Far_013)
  end, 0.1)
end
function DF_960_BreakableStack_01()
  LD.BreakObject(GameObjects.DF_960_Stack1_02)
  LD.BreakObject(GameObjects.DF_960_Stack1_03)
end
function DF_960_BreakableStack_02()
  LD.BreakObject(GameObjects.DF_960_Stack2_02)
  LD.BreakObject(GameObjects.DF_960_Stack2_03)
end
function DF_Nif_BreakableStack_01()
  LD.BreakObject(GameObjects.DF_Nif_Stack1_02)
end
function DF_Nif_BreakableStack_02()
  LD.BreakObject(GameObjects.DF_Nif_Stack2_02)
end
function DF_Nif_BreakableStack_03()
  LD.BreakObject(GameObjects.DF_Nif_Stack3_02)
end
function DF_Nif_BreakableStack_04()
  LD.BreakObject(GameObjects.DF_Nif_Stack4_02)
end
function FlipperBlocked()
  local FlipBlocker_Anim = GameObjects.SpinBlocked_Anim
  FlipBlocker_Anim:JumpAnimToFrame(0)
  FlipBlocker_Anim:PlayAnimToEnd(0.5)
end
function BreakSpinner()
  timer.StartLevelTimer(0.2, BreakSpinFlipper)
end
function BreakSpinFlipper()
  LD.BreakObject(GameObjects.Spin_01_Bomb_01)
  LD.BreakObject(GameObjects.Spin_01_Bomb_02)
  LD.BreakObject(GameObjects.Spin_01_Blocker_01)
  LD.BreakObject(GameObjects.Spin_01_Blocker_02)
  LD.BreakObject(GameObjects.Spin_01_Blocker_03)
  LD.BreakObject(GameObjects.Spin_01_Blocker_04)
  LD.BreakObject(GameObjects.Spin_01_Blocker_05)
  LD.BreakObject(GameObjects.Spin_01_Blocker_06)
  LD.BreakObject(GameObjects.Spin_01_Blocker_07)
  LD.BreakObject(GameObjects.Spin_01_Blocker_08)
  LD.BreakObject(GameObjects.Spin_01_Blocker_09)
  local FlipBlocker_Anim = GameObjects.SpinBlocked_Anim
  FlipBlocker_Anim:JumpAnimToFrame(0)
  FlipBlocker_Anim:PlayAnimToEnd(2)
  local FlipBlocker_Col = GameObjects.SpinBlocked_Col
  FlipBlocker_Col:Hide()
  local cwCollision_obj = Spin_01:FindSingleGOByName("cwObject_Collision")
  local ccwCollision_obj = Spin_01:FindSingleGOByName("ccwObject_Collision")
  local BlockingCollision_obj = Spin_01:FindSingleGOByName("Blocking_Collision")
  Spin_01_Flipper.LuaObjectScript.EnableRotation()
  local Paddle = cwCollision_obj:GetJointIndex("Paddle_01_Hit_CW")
  cwCollision_obj:HideJoint(Paddle)
  Paddle = ccwCollision_obj:GetJointIndex("Paddle_01_Hit_CCW")
  ccwCollision_obj:HideJoint(Paddle)
  Paddle = cwCollision_obj:GetJointIndex("Paddle_03_Hit_CW")
  cwCollision_obj:HideJoint(Paddle)
  Paddle = ccwCollision_obj:GetJointIndex("Paddle_03_Hit_CCW")
  ccwCollision_obj:HideJoint(Paddle)
  Paddle = BlockingCollision_obj:GetJointIndex("DeflectNoTargetCol_Paddle_01")
  BlockingCollision_obj:HideJoint(Paddle)
  Paddle = BlockingCollision_obj:GetJointIndex("DeflectNoTargetCol_Paddle_03")
  BlockingCollision_obj:HideJoint(Paddle)
  Spin_01:FindSingleGOByName("DiskA"):Hide()
  Spin_01:FindSingleGOByName("DiskC"):Hide()
end
function CA_AtDoor_EnableZone()
  GameObjects.CA_RunicDoor_StayOut_Zone:ShowEntityVolume()
end
function CA_AtDoor_DisableZone()
  GameObjects.CA_RunicDoor_StayOut_Zone:HideEntityVolume()
  GameObjects.CA_RunicDoor_StayOut.LuaObjectScript.Disable()
end
local waterLevel = {}
waterLevel.Bottom = 2
waterLevel.Medium = 1
waterLevel.Top = 0
local bottomWaterAmbience, mediumWaterAmbience, topWaterAmbience
local xpl960MusicOn = false
local runicDoorSoundOverride = {OnInteractClose_Left = "", OnInteractClose_Right = ""}
function SoundInit()
  bottomWaterAmbience = GameObjects.BottomWaterAmbience
  mediumWaterAmbience = GameObjects.MediumWaterAmbience
  topWaterAmbience = GameObjects.TopWaterAmbience
end
function SoundOnStart()
  GameObjects.RunicDoor:FindSingleGOByName("spreadDoor").Child.LuaObjectScript.SoundSetup(runicDoorSoundOverride)
end
function SetAmbience()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel == waterLevel.Bottom then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Show()
  elseif newWaterLevel == waterLevel.Medium then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Show()
    bottomWaterAmbience:Hide()
  elseif newWaterLevel == waterLevel.Top then
    topWaterAmbience:Show()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Hide()
  end
end
function HideAllAmbience()
  topWaterAmbience:Hide()
  mediumWaterAmbience:Hide()
  bottomWaterAmbience:Hide()
end
function Xpl960MusicEnter()
  if xpl960MusicOn == false then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL960_explore2_in")
    xpl960MusicOn = true
  end
end
function Xpl960MusicExit()
  if xpl960MusicOn == true then
    game.Audio.StartMusic("SND_MX_XPL960_idle")
    xpl960MusicOn = false
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    dfQuest960 = dfQuest960,
    BeaconLit = BeaconLit,
    xpl960MusicOn = xpl960MusicOn
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  dfQuest960 = savedInfo.dfQuest960
  BeaconLit = savedInfo.BeaconLit
  xpl960MusicOn = savedInfo.xpl960MusicOn
  if xpl960MusicOn == true then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL960_explore2_in")
  end
end
