local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, Area_1_Encounter_1, Area_2_Encounter_1, Area_2_Encounter_2, Area_2_Encounter_3, Area_2_Encounter_4
function OnScriptLoaded(level, obj)
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") <= 339 then
    Area_1_Fight_1()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_2_Fight_1()
    Area_2_Fight_2()
    Area_2_Fight_3()
    Area_2_Fight_Repop()
  end
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL1 Flyers XPL970 ", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl970_1",
    LoadCheck = false
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Flyers_2_SFG",
      spawnLocators = "A1_Loc_O_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Flyers_2_SFG",
      spawnLocators = "A1_Loc_O_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8
    },
    {
      spawners = "Flyers_2_SFG",
      spawnLocators = "A1_Loc_O_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.8
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Spawn)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Base")
  end)
end
function Xpl300_GateOpen()
  GameObjects.xpl300_gateBreak01.Child:GetBreakable():Break()
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL2 Flyers XPL970", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneXpl970_2",
    LoadCheck = false
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Flyers_4_SFG",
      spawnLocators = "A2_Loc_O_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Flyers_4_SFG",
      spawnLocators = "A2_Loc_O_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.1
    },
    {
      spawners = "Flyers_4_SFG",
      spawnLocators = "A2_Loc_O_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.1
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_Area_2_Spawn_1)
  Area_2_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Base")
  end)
end
function Area_2_Fight_Repop()
  Area_2_Encounter_4 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL2 Flyers Repopulation XPL970", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneXpl970_2",
    LoadCheck = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 1]EC:1 WL2 Flyers XPL970"
    }
  })
  Area_2_Encounter_4:AddWave({
    {
      spawners = "Flyers_7_SFG",
      spawnLocators = "A2_Loc_O_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Flyers_7_SFG",
      spawnLocators = "A2_Loc_O_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.1
    },
    {
      spawners = "Flyers_8_SFG",
      spawnLocators = "A2_Loc_O_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.1
    }
  })
  Area_2_Encounter_4:SetStartZone(GameObjects.EntZn_Area_2_Spawn_4)
end
function Area_2_Fight_2()
  Area_2_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL2 Flyers upper area XPL970", {CheckpointOnComplete = true, LoadCheck = false})
  Area_2_Encounter_2:AddWave({
    {
      spawners = "Flyers_4_SFG",
      spawnLocators = "A1_Loc_B_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Flyers_4_SFG",
      spawnLocators = "A1_Loc_B_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.1
    },
    {
      spawners = "Flyers_2_SFG",
      spawnLocators = "A1_Loc_B_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.1
    }
  })
  Area_2_Encounter_2:SetStartZone(GameObjects.EntZn_Area_2_Spawn_2)
  Area_2_Encounter_2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Base")
  end)
end
function Area_2_Fight_3()
  Area_2_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL2 Witch + Flyers Final Area XPL970", {
    CheckpointOnComplete = true,
    LoadCheck = false,
    StartMusic = "SND_MX_XPL970_witch_fight_in",
    StopMusic = "SND_MX_XPL970_witch_fight_out"
  })
  Area_2_Encounter_3:AddWave({
    {
      spawners = "Flyers_4_SFG",
      spawnLocators = "A1_Loc_W_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.1
    },
    {
      spawners = "Witch_P_SFG",
      spawnLocators = "A1_Loc_W_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl970_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_2_Encounter_3:SetStartZone(GameObjects.EntZn_Area_2_Spawn_3)
  Area_2_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Revenant_Spawner")
  end)
end
