local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local SpikeTrap_01, SpikeTrap_02, SpikeTrap_03, SpikeTrap_05, SpikeTrap_022
local WaterLvL_02_TraverseLinks = 1
local WaterLvL_02_TraverseLinks_Mantle_01 = 1
local WaterLvL_02_TraverseLinks_GapJump_01 = 1
local WaterLvL_02_TraverseLinks_Dummy = 1
local SpikeBell_Movers_01 = 1
local TowerSide_PathLink = 1
local Zipline_TopPOS, Zipline_BottomPOS, Zipline_fromShipVis
local bombShown = false
local announceTriggered = false
local BombCheckPoint_01 = 1
local BombRocks_Blockers = 1
local Hazard_ExplodingPot_001 = 1
function OnScriptLoaded(level)
  local monitors = require("level.MonitorLibrary")
  local SpikeBell_Movers_01_Monitor = monitors.CreateAnimFrameMonitor(GameObjects.SpikeBell_Movers_01)
  SpikeBell_Movers_01_Monitor:OnFrameForward(70, EnableBells)
  SpikeBell_Movers_01_Monitor:OnFrameBackward(70, DisableBells)
  SpikeBell_Movers_01_Monitor:SetPrintsEnabled(false)
  WaterLvL_02_TraverseLinks = GameObjects.WaterLvL_02_TraverseLinks
  WaterLvL_02_TraverseLinks_GapJump_01 = GameObjects.WaterLvL_02_TraverseLinks_GapJump_01
  WaterLvL_02_TraverseLinks_Dummy = GameObjects.WaterLvL_02_TraverseLinks_Dummy
  WaterLvL_02_TraverseLinks_Mantle_01 = GameObjects.WaterLvL_02_TraverseLinks_Mantle_01
  SpikeTrap_02 = GameObjects.SpikeTrap_02
  SpikeTrap_03 = GameObjects.SpikeTrap_03
  SpikeTrap_05 = GameObjects.SpikeTrap_05
  SpikeTrap_022 = GameObjects.SpikeTrap_022
  SpikeBell_Movers_01 = GameObjects.SpikeBell_Movers_01
  TowerSide_PathLink = GameObjects.TowerSide_PathLink
  BombCheckPoint_01 = GameObjects.BombCheckPoint_01
  BombRocks_Blockers = GameObjects.BombRocks_Blockers
  Hazard_ExplodingPot_001 = GameObjects.Hazard_ExplodingPot_001
  SpikeBell_Movers_01:JumpAnimToFrame(0)
  SpikeBell_Movers_01:PauseAnim()
  game.Compass.SetGatewayMarkerIsOpen("BT_970_Helper", true)
  game.Compass.SetGatewayMarkerIsOpen("BT_970_Helper6", false)
  SoundInit()
end
function OnStart(level)
  Zipline_TopPOS = GameObjects.Zipline_Top1
  Zipline_BottomPOS = GameObjects.Zipline_Bottom1
  Zipline_fromShipVis = GameObjects.zipline_Xpl960.Child
  Zipline_fromShipVis:SetZiplineStartAndEnd(Zipline_TopPOS:GetWorldPosition(), Zipline_BottomPOS:GetWorldPosition())
  GameObjects.SpinnableSystem_001.LuaObjectScript.RiverPassOverride(3.5, 4.2, 6)
end
function OpenRopeDrop()
  game.Compass.SetGatewayMarkerIsOpen("BT_970_Helper6", true)
end
function OnFirstStart(level)
  WaterLvL_02_TraverseLinks_Mantle_01:Hide()
  WaterLvL_02_TraverseLinks:Hide()
  WaterLvL_02_TraverseLinks_GapJump_01:Hide()
  TowerSide_PathLink:Hide()
  BombCheckPoint_01:Hide()
  Hazard_ExplodingPot_001:FindSingleGOByName("bombBag"):HideBreakable()
end
function EnableBells()
  GameObjects.BellTarget_Small_02.LuaObjectScript.EnableTargeting()
  GameObjects.BellTarget_Small_03.LuaObjectScript.EnableTargeting()
  GameObjects.BellTarget_Small_01.LuaObjectScript.EnableTargeting()
end
function DisableBells()
  GameObjects.BellTarget_Small_02.LuaObjectScript.DisableTargeting()
  GameObjects.BellTarget_Small_03.LuaObjectScript.DisableTargeting()
  GameObjects.BellTarget_Small_01.LuaObjectScript.DisableTargeting()
end
function OnUpdate(level)
  Zipline_fromShipVis:SetZiplineStartAndEnd(Zipline_TopPOS:GetWorldPosition(), Zipline_BottomPOS:GetWorldPosition())
end
function Waterfall_BombBlocker_Show()
  GameObjects.Waterfall_BombBlocker:Show()
end
function Waterfall_BombBlocker_Hide()
  GameObjects.Waterfall_BombBlocker:Hide()
end
function TowerSide_PathLink_Show()
  TowerSide_PathLink:Show()
end
function WaterLvL_02_TraverseLinks_Hide()
  WaterLvL_02_TraverseLinks:Hide()
end
function WaterLvL_02_TraverseLinks_Show()
  WaterLvL_02_TraverseLinks:Show()
end
function WaterLvL_02_TraverseLinks_Dummy_Hide()
  WaterLvL_02_TraverseLinks_Dummy:Hide()
end
function WaterLvL_02_TraverseLinks_Dummy_Show()
  WaterLvL_02_TraverseLinks_Dummy:Show()
end
function WaterLvL_02_TraverseLinks_Mantle_01_Hide()
  WaterLvL_02_TraverseLinks_Mantle_01:Hide()
end
function WaterLvL_02_TraverseLinks_Mantle_01_Show()
  WaterLvL_02_TraverseLinks_Mantle_01:Show()
end
function Hazard_ExplodingPot_001_Show()
  if bombShown == false then
    Hazard_ExplodingPot_001:FindSingleGOByName("bombBag"):ShowBreakable()
    bombShown = true
  end
end
function WaterLvL_02_TraverseLinks_GapJump_01_Hide()
  WaterLvL_02_TraverseLinks_GapJump_01:Hide()
  SpikeTrap_03.Child:ShowNavObstacle()
  SpikeTrap_05.Child:HideNavObstacle()
  SpikeTrap_022.Child:HideNavObstacle()
end
function WaterLvL_02_TraverseLinks_GapJump_01_Show()
  WaterLvL_02_TraverseLinks_GapJump_01:Show()
  SpikeTrap_03.Child:HideNavObstacle()
  SpikeTrap_05.Child:ShowNavObstacle()
  SpikeTrap_022.Child:ShowNavObstacle()
end
function ExitLowerXpl970Climb()
  if SpikeTrap_03.LuaObjectScript.IsEnabled() == false then
    WaterLvL_02_TraverseLinks_GapJump_01:Show()
  end
end
function LockSpinnable()
  GameObjects.SpinnableSystem.LuaObjectScript.Lock()
end
function TriggerTrap_01()
  SpikeTrap_01.LuaObjectScript.TriggerTrap()
end
function TriggerTrap_02()
  SpikeTrap_02.LuaObjectScript.TriggerTrap()
end
function SpikeBell_Movers_01_Down()
  GameObjects.SpikeBell_Movers_01:PlayAnimToEnd(-1)
end
function SpikeBell_Movers_01_Up()
  GameObjects.SpikeBell_Movers_01:PlayAnimToEnd()
end
function ResetTrap_SpikeTrap_02()
  SpikeTrap_02.LuaObjectScript.ResetTrap()
end
function TriggerTrap_03()
  SpikeTrap_03.LuaObjectScript.TriggerTrap()
end
function ResetTrap_SpikeTrap_03()
  SpikeTrap_03.LuaObjectScript.ResetTrap()
end
function AreaAnnounce_BeachTower()
  print("NO")
end
function AreaAnnounce_BeachTowerNEW()
  if announceTriggered == false and game.IsPaused() == false then
    local uiCalls = require("ui.uicalls")
    uiCalls.UI_Event_DiscoverLocation("BeachTower")
    LD.CallFunctionAfterDelay(TrophyCheck, 1)
    announceTriggered = true
  end
end
function StoreCheckpoint()
  game.World.StoreCheckpoint()
end
function BombCheckPoint_01_Show()
  BombCheckPoint_01:Show()
end
function BombRocks_Blockers_Hide()
  BombRocks_Blockers:Hide()
end
function StoreRockCheckpoint()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.CheckpointOverride_BlowRocks.Child
  })
end
function TrophyCheck()
  local regionTable = {
    "IslandArch",
    "IslandShipwreck",
    "IslandClimb",
    "BeachRuins",
    "BeachCave",
    "BeachMaze",
    "BeachShipwreck",
    "BeachTower",
    "BeachWaterfall"
  }
  local trueCheck = true
  local regionInfo, regionState
  for _, regions in pairs(regionTable) do
    regionInfo = game.Map.GetRegionInfo(regions)
    regionState = regionInfo.State
    if regionState ~= tweaks.eTokenState.kDiscovered then
      trueCheck = false
    end
  end
  if trueCheck == true then
    game.UnlockTrophy(12)
  end
end
function TriggerSpikeTrapGroup()
  GameObjects.SpikeTrap_015.LuaObjectScript.TriggerTrap()
  GameObjects.SpikeTrap_016.LuaObjectScript.TriggerTrap()
  GameObjects.SpikeTrap_017.LuaObjectScript.TriggerTrap()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    bombShown = bombShown
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  bombShown = savedInfo.bombShown
end
local spikeTrapEmitters
local xpl950Music = false
function SoundInit()
  spikeTrapEmitters = GameObjects.SpikeBell_Movers_01.SoundEmitters
end
function PlaySoundOnAddImpulse()
  if GameObjects.SpikeBell_Movers_01.AnimFrame < GameObjects.SpikeBell_Movers_01.AnimLengthFrames then
    PlaySoundSpikeBellDown()
  end
end
function PlaySoundOnRewindStart()
  PlaySoundSpikeBellSwitchDirections()
  PlaySoundSpikeBellDown()
end
function PlaySoundOnReachStart()
  PlaySoundSpikeBellEnd()
  StopSoundSpikeBell()
end
function PlaySoundOnReachEnd()
  PlaySoundSpikeBellEnd()
  StopSoundSpikeBell()
end
function PlaySoundSpikeBellSwitchDirections()
  for i = 1, #spikeTrapEmitters do
    LD.PlaySound(spikeTrapEmitters[i], "SND_TRAP_Metal_Spikes_Change_Direction")
  end
end
function PlaySoundSpikeBellEnd()
  for i = 1, #spikeTrapEmitters do
    LD.PlaySound(spikeTrapEmitters[i], "SND_TRAP_Metal_Spikes_Retract")
  end
end
function PlaySoundSpikeBellDown()
  for i = 1, #spikeTrapEmitters do
    LD.PlaySound(spikeTrapEmitters[i], "SND_TRAP_Metal_Spikes_Movement_LP")
  end
end
function PlaySoundSpikeBellUp()
  for i = 1, #spikeTrapEmitters do
    LD.PlaySound(spikeTrapEmitters[i], "SND_TRAP_Metal_Spikes_Movement_LP")
  end
end
function StopSoundSpikeBell()
  for i = 1, #spikeTrapEmitters do
    LD.StopSound(spikeTrapEmitters[i], "SND_TRAP_Metal_Spikes_Movement_LP")
  end
end
function musicXpl950Enter()
  if xpl950Music == false then
    game.Audio.StartCheckpointedMusic("SND_MX_XPL970_explore1_in")
    xpl950Music = true
  end
end
function musicXpl950FastTravel()
  game.Audio.StartCheckpointedMusic("SND_MX_XPL970_explore1_in")
  xpl950Music = true
end
function musicXpl950Exit()
  if xpl950Music == true then
    game.Audio.StartMusic("SND_MX_XPL970_idle")
    xpl950Music = false
  end
end
