local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, player, Area_1_Encounter_1, Area_2_Encounter_1, Area_3_Encounter_1, Area_3_Encounter_2, Witch_HealthMonitor_1, Witch_HealthMonitor_2, ZM_A1_E1_Attack, ZM_A2_E1_Attack, ZM_A3_E1_Attack
function OnScriptLoaded(level, obj)
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") <= 339 then
    Area_2_Fight_1()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 340 then
    Area_1_Fight_1()
    Area_3_Fight_1()
    Area_3_Fight_2_Repop()
  end
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function TriggerDraugrSurprise()
  if Area_1_Encounter_1 ~= nil then
    Area_1_Encounter_1:Start()
  end
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 WL2 lower level draugr fight  XPL980", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl900_AI_02",
    LeashZone = "LeashZoneXpl980_2",
    LoadCheck = false
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "DW_Draugr_N_SSA",
      spawnLocators = "A1_H_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_3_Attack)
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2][WL1]EC:1 Xpl980 Witch + Crawlers Water Level 1", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl980_AI_01",
    LeashZone = "LeashZoneXpl980_1",
    LoadCheck = false,
    StartMusic = "SND_MX_XPL980_fight1_in",
    StopMusic = "SND_MX_XPL980_fight1_out"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Witch_L2_Stealth",
      spawnLocators = "A2_O_Loc_01",
      markerID = "Witch_Waterfall_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Crawler_T_SFG",
      spawnLocators = "A2_O_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Spawn)
  Area_2_Encounter_1:OnEnemySpawn(Witch_Health_Monitor_1, {
    markerID = "Witch_Waterfall_1"
  })
  Area_2_Encounter_1:OnComplete(function()
    GameObjects.EntZn_Area_2_Attack_1:ShowEntityVolume()
  end)
  Area_2_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Tatzelwurm_Spitter")
  end)
end
function Witch_Health_Monitor_1(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Witch_HealthMonitor_1 = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.5
    Witch_HealthMonitor_1:OnHealthLessThan(Health_Phase_1, function()
      Area_2_Encounter_1:StartWave(2)
    end)
  end
end
function Area_3_Fight_1()
  local powerLevel01, powerLevel02
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNumber and cineNumber <= 599 then
    powerLevel01 = 4
    powerLevel02 = 5
  elseif 600 <= cineNumber then
    powerLevel01 = 5
    powerLevel02 = 6
  end
  Area_3_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2][WL1]EC:1 Xpl980 Witch + Crawlers Water Level 2", {
    CheckpointOnComplete = true,
    spawnWad = "Xpl980_AI_02",
    LeashZone = "LeashZoneXpl980_1",
    LoadCheck = false,
    StartMusic = "SND_MX_XPL980_fight1_in",
    StopMusic = "SND_MX_XPL980_fight1_out"
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Witch_L4_Stealth",
      spawnLocators = "A2_O_Loc_01",
      markerID = "Witch_Waterfall_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1,
      powerLevel = powerLevel02
    }
  })
  Area_3_Encounter_1:AddWave({
    {
      spawners = "Crawler_T_SFG",
      spawnLocators = "A2_O_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3,
      powerLevel = powerLevel01
    },
    {
      spawners = "Crawler_T_SFG",
      spawnLocators = "A2_O_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7,
      powerLevel = powerLevel01
    }
  })
  Area_3_Encounter_1:SetStartZone(GameObjects.EntZn_Area_2_Attack)
  Area_3_Encounter_1:OnEnemySpawn(Witch_Health_Monitor_2, {
    markerID = "Witch_Waterfall_2"
  })
  Area_3_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Tatzelwurm_Spitter")
  end)
end
function Witch_Health_Monitor_2(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Witch_HealthMonitor_2 = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_2 = EnemyHealth * 0.5
    Witch_HealthMonitor_2:OnHealthLessThan(Health_Phase_2, function()
      Area_3_Encounter_1:StartWave(2)
    end)
  end
end
function Area_3_Fight_2_Repop()
  Area_3_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2][WL2]EC:1 Xpl980 Crawlers Water Level 2 Repopulation", {
    CheckpointOnComplete = false,
    spawnWad = "Xpl980_AI_02",
    LeashZone = "LeashZoneXpl980_1",
    LoadCheck = false,
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "[Area 2][WL1]EC:1 Xpl980 Witch + Crawlers Water Level 2"
    }
  })
  Area_3_Encounter_2:AddWave({
    {
      spawners = "Crawler_5_SFG",
      spawnLocators = "A2_O_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Crawler_5_SFG",
      spawnLocators = "A2_O_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Crawler_7_SFG",
      spawnLocators = "A2_O_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    }
  })
  Area_3_Encounter_2:SetStartZone(GameObjects.EntZn_Area_2_Attack_1)
end
