local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local thisLevel
local ForceFeedbackRumble = {EffectName = "FFB_MEDIUM", Duration = 1}
local CA_HoleLookDown = 0
local CA_HoleLookDown_Locked = false
local announceTriggered = false
local cameraChainRecenter = {
  TimeStart = 0,
  TimeDuration = 1.3,
  LockRecenter = 0.46,
  RotationSpace = 1,
  YawRange = -1,
  TriggerLeft = -123,
  ReturnLeft = -133,
  ReturnRight = -133,
  TriggerRight = -143,
  PitchRange = -1,
  TriggerUp = 5,
  ReturnUp = 3,
  ReturnDown = 2,
  TriggerDown = 0
}
local crankRecenter = {
  TimeStart = 0,
  TimeDuration = 2.4,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = 69,
  ReturnLeft = 23,
  ReturnRight = 19,
  TriggerRight = 4.2,
  PitchRange = -1,
  TriggerUp = 8,
  ReturnUp = -5.5,
  ReturnDown = -6.5,
  TriggerDown = -14
}
function OnScriptLoaded(level)
  thisLevel = level
  SoundInit()
  local rightsidedcrank = level:FindGameObject("Lift_WheelCrank")
  if rightsidedcrank ~= nil and rightsidedcrank.LuaObjectScript ~= nil then
    rightsidedcrank.LuaObjectScript.OverrideCameraInteractApproach("ENV_Crank_Approach_RightJustified")
    rightsidedcrank.LuaObjectScript.OverrideDefaultCameraRecenter(true, crankRecenter)
    rightsidedcrank.LuaObjectScript.OverrideDefaultCameraYaw(true, -154)
  end
  local goChainPull = level:FindGameObject("ConnectedGates_ChainPull")
  if goChainPull ~= nil and goChainPull.LuaObjectScript ~= nil then
    goChainPull.LuaObjectScript.OverrideDefaultCameraRecenter(true, cameraChainRecenter)
    goChainPull.LuaObjectScript.OverrideDefaultCameraPitch(true, -3)
    goChainPull.LuaObjectScript.OverrideDefaultCameraYaw(true, -133)
  end
end
function OnFirstStart(level)
  SetAmbience()
  GameObjects.GapJump_DropBridge:HideTraverseLink()
  GameObjects.Lift_WheelCrank.LuaObjectScript.Disable()
  GameObjects.Gate_01:JumpAnimationToFrame(0)
  GameObjects.Gate_01:PauseAnimation()
  GameObjects.Gate_02:JumpAnimationToFrame(0)
  GameObjects.Gate_02:PauseAnimation()
  UpdateWaterLevel()
end
function OnStart(level)
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = function()
      LowerWater_Level01()
      SetAmbience()
      UpdateWaterLevel()
    end,
    fn = function()
      LowerWater_Level01()
      SetAmbience()
      UpdateWaterLevel()
    end
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = function()
      LowerWater_Level02()
      SetAmbience()
      UpdateWaterLevel()
    end,
    fn = function()
      LowerWater_Level02()
      SetAmbience()
      UpdateWaterLevel()
    end
  })
  SoundOnStart()
end
function LowerWater_Level01()
  GameObjects.CrackClimb_toUpperBeach:HideTraversePath()
  GameObjects.RopeDrop_toWheel2.LuaObjectScript.Disable()
  GameObjects.____BlockingRocks_toLevel2:Show()
  GameObjects.RopeDrop_toLowerBeach.LuaObjectScript.DisablePlayerInteract()
end
function LowerWater_Level02()
  GameObjects.CrackClimb_toUpperBeach:ShowTraversePath()
  GameObjects.RopeDrop_toWheel2.LuaObjectScript.Enable()
  GameObjects.____BlockingRocks_toLevel2:Hide()
  GameObjects.RopeDrop_toLowerBeach.LuaObjectScript.EnablePlayerInteract()
end
function SaveCheckpoint()
  game.World.StoreCheckpoint()
end
function OnSaveCheckpoint(level)
  return {
    levelState = checkpoint.Save(),
    CA_HoleLookDown = CA_HoleLookDown,
    CA_HoleLookDown_Locked = CA_HoleLookDown_Locked
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelState)
  CA_HoleLookDown = savedInfo.CA_HoleLookDown
  CA_HoleLookDown_Locked = savedInfo.CA_HoleLookDown_Locked
end
function Enable_CAs_BackClimbArea()
  Disable_CAs_LookDownHole()
end
function Disable_CAs_DoorLookAt()
  GameObjects.DoorLookAt_Zone:HideEntityVolume()
end
function Enable_CAs_LookDownHole()
  if CA_HoleLookDown_Locked == false then
    GameObjects.ContextAction_LookDownHole_atCrank.LuaObjectScript.Enable()
  end
end
function Disable_CAs_LookDownHole()
  GameObjects.ContextAction_LookDownHole_atCrank.LuaObjectScript.Disable()
end
function CAs_LookDownHole_IntCount()
  if CA_HoleLookDown_Locked == false then
    CA_HoleLookDown = CA_HoleLookDown + 1
    if 2 < CA_HoleLookDown then
      GameObjects.ContextAction_LookDownHole_atCrank.LuaObjectScript.Disable()
      CA_HoleLookDown_Locked = true
    end
  end
end
function CAs_LookDownHole_DecCount()
  if CA_HoleLookDown_Locked == false then
    CA_HoleLookDown = CA_HoleLookDown - 1
  end
end
function Enable_CAs_LookDownHole_fromClimb()
  GameObjects.CA_Climb_03_Exit.LuaObjectScript.Enable()
end
function DropBridge()
  GameObjects.Temp_AxeBridge01.LuaObjectScript.BrokenClasp()
  GameObjects.GapJump_DropBridge:ShowTraverseLink()
end
function EnableLiftCrank()
  GameObjects.Lift_WheelCrank.LuaObjectScript.Enable()
end
function AreaAnnounce()
  print("no")
end
function AreaAnnounceNEW()
  if announceTriggered == false and game.IsPaused() == false then
    uiCalls.UI_Event_DiscoverLocation("BeachWaterfall")
    LD.CallFunctionAfterDelay(TrophyCheck, 1)
    announceTriggered = true
  end
end
function TrophyCheck()
  local regionTable = {
    "IslandArch",
    "IslandShipwreck",
    "IslandClimb",
    "BeachRuins",
    "BeachCave",
    "BeachMaze",
    "BeachShipwreck",
    "BeachTower",
    "BeachWaterfall"
  }
  local trueCheck = true
  local regionInfo, regionState
  for _, regions in pairs(regionTable) do
    regionInfo = game.Map.GetRegionInfo(regions)
    regionState = regionInfo.State
    if regionState ~= tweaks.eTokenState.kDiscovered then
      trueCheck = false
    end
  end
  if trueCheck == true then
    game.UnlockTrophy(12)
  end
end
function ChainPull_OpenDoor()
  GameObjects.Gate_01:PlayAnimationToEnd({Rate = 2})
  GameObjects.Gate_02:PlayAnimationToEnd({Rate = 2})
  PlaySoundChainPull_OpenDoor()
  GameObjects.EntryZone_002:ShowEntityVolume()
end
function ChainPull_CloseDoor()
  GameObjects.Gate_01:PlayAnimationToEnd({Rate = -2})
  GameObjects.Gate_02:PlayAnimationToEnd({Rate = -2})
  PlaySoundChainPull_CloseDoor()
  GameObjects.EntryZone_002:HideEntityVolume()
end
function ShakeRumble()
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_SMALL",
    Duration = 0.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.2}
  })
  game.FX.SubmitEffect(ForceFeedbackRumble)
end
function UpdateWaterLevel()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel < 2 then
    GameObjects.CrackClimb_toUpperBeach:HideTraversePath()
    GameObjects.RopeDrop_toWheel2.LuaObjectScript.Disable()
    GameObjects.____BlockingRocks_toLevel2:Show()
    GameObjects.ContextAction_LookDownHole_L1.LuaObjectScript.Enable()
  elseif newWaterLevel == 2 then
    GameObjects.CrackClimb_toUpperBeach:ShowTraversePath()
    GameObjects.RopeDrop_toWheel2.LuaObjectScript.Enable()
    GameObjects.____BlockingRocks_toLevel2:Hide()
    GameObjects.ContextAction_LookDownHole_L1.LuaObjectScript.Disable()
  end
end
local waterLevel = {}
waterLevel.Bottom = 2
waterLevel.Medium = 1
waterLevel.Top = 0
local bottomWaterAmbience, mediumWaterAmbience, topWaterAmbience
local xpl980Music = false
local bridgeSoundEvents = {
  isLooping = true,
  OnDrawBridgeFall = "SND_MECH_Wood_Bridge_Lower_LP_Xpl980",
  OnDrawBridgeFallFrame = -1,
  OnDrawBridgeEnd = "",
  OnDrawBridgeEndFrame = 19,
  HookSounds = {
    OnBreak = "SND_MECH_Wood_Bridge_S_Hook_Break_Xpl980"
  }
}
local gateSoundEvents = {
  StartUp = "SND_DOOR_Metal_Lift_Gate_Forest_Start_Up",
  StartDown = "SND_DOOR_Metal_Lift_Gate_Forest_Start_Down",
  HitCeiling = "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ceiling",
  HitGround = "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ground",
  Loop = "SND_DOOR_Metal_Lift_Gate_Forest_LP"
}
local treasureElevatorSoundOverride = {
  SoundEmitter = nil,
  OnForward = "SND_MECH_Crank_Stone_Platform_Xpl980_LP",
  OnBackward = "SND_MECH_Crank_Stone_Platform_Xpl980_LP"
}
local soundEmitter_Gate_01, soundEmitter_Gate_02, soundMonitor_Gate_01_Up, soundMonitor_Gate_02_Up
function SoundInit()
  bottomWaterAmbience = thisLevel:FindSingleGameObject("BottomWaterAmbience")
  mediumWaterAmbience = thisLevel:FindSingleGameObject("MediumWaterAmbience")
  topWaterAmbience = thisLevel:FindSingleGameObject("TopWaterAmbience")
  SetAmbience()
  soundEmitter_Gate_01 = GameObjects.Gate_01.SoundEmitters[1]
  soundEmitter_Gate_02 = GameObjects.Gate_02.SoundEmitters[1]
  SetupBridgeSounds()
  treasureElevatorSoundOverride.SoundEmitter = GameObjects.elevator_pathBlocker:FindSingleSoundEmitterByName("SNDTreasureElevator")
end
function SoundOnStart()
  GameObjects.Lift_WheelCrank.LuaObjectScript.DrivenObjectSoundSetup(treasureElevatorSoundOverride)
end
function SetupBridgeSounds()
  GameObjects.Temp_AxeBridge01.LuaObjectScript.SoundSetup(bridgeSoundEvents)
end
function PlaySoundChainPull_OpenDoor()
  LD.PlaySound(soundEmitter_Gate_01, gateSoundEvents.StartDown, true)
  LD.PlaySound(soundEmitter_Gate_01, gateSoundEvents.Loop, true)
  GameObjects.Gate_01:OnAnimationDone(thisLevel, "PlaySoundGate01_HitGround")
  LD.PlaySound(soundEmitter_Gate_02, gateSoundEvents.StartUp, true)
  LD.PlaySound(soundEmitter_Gate_02, gateSoundEvents.Loop, true)
  PlaySoundGate02_HitCeiling(30)
end
function PlaySoundChainPull_CloseDoor()
  LD.PlaySound(soundEmitter_Gate_01, gateSoundEvents.StartUp, true)
  LD.PlaySound(soundEmitter_Gate_01, gateSoundEvents.Loop, true)
  PlaySoundGate01_HitCeiling(25)
  LD.PlaySound(soundEmitter_Gate_02, gateSoundEvents.StartDown, true)
  LD.PlaySound(soundEmitter_Gate_02, gateSoundEvents.Loop, true)
  GameObjects.Gate_02:OnAnimationDone(thisLevel, "PlaySoundGate02_HitGround")
end
function PlaySoundGate01_HitGround()
  LD.StopSound(soundEmitter_Gate_01, gateSoundEvents.Loop)
  LD.PlaySound(soundEmitter_Gate_01, gateSoundEvents.HitGround, true)
  ShakeRumble()
end
function PlaySoundGate01_HitCeiling(targetFrame)
  LD.StopSoundOnFrame(soundEmitter_Gate_01, GameObjects.Gate_01, gateSoundEvents.Loop, targetFrame, "backward")
  LD.PlaySoundOnFrame(soundEmitter_Gate_01, GameObjects.Gate_01, gateSoundEvents.HitCeiling, targetFrame, "backward", true)
  ShakeRumble()
end
function PlaySoundGate02_HitGround()
  LD.StopSound(soundEmitter_Gate_02, gateSoundEvents.Loop)
  LD.PlaySound(soundEmitter_Gate_02, gateSoundEvents.HitGround, true)
end
function PlaySoundGate02_HitCeiling(targetFrame)
  LD.StopSoundOnFrame(soundEmitter_Gate_02, GameObjects.Gate_02, gateSoundEvents.Loop, targetFrame, "forward")
  LD.PlaySoundOnFrame(soundEmitter_Gate_02, GameObjects.Gate_02, gateSoundEvents.HitCeiling, targetFrame, "forward", true)
end
function musicXpl980Enter()
  if xpl980Music == false then
    game.Audio.StartMusic("SND_MX_XPL980_explore1_in")
    xpl980Music = true
  end
end
function musicXpl980FastTravel()
  game.Audio.StartMusic("SND_MX_XPL980_explore1_in")
  xpl980Music = true
end
function musicXpl980Exit()
  if xpl980Music == true then
    game.Audio.StartMusic("SND_MX_XPL980_idle")
    xpl980Music = false
  end
end
function SetAmbience()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel == waterLevel.Bottom then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Show()
  elseif newWaterLevel == waterLevel.Medium then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Show()
    bottomWaterAmbience:Hide()
  elseif newWaterLevel == waterLevel.Top then
    topWaterAmbience:Show()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Hide()
  end
end
function HideAllAmbience()
  topWaterAmbience:Hide()
  mediumWaterAmbience:Hide()
  bottomWaterAmbience:Hide()
end
