local LD = require("design.LevelDesignLibrary")
local cineNum = game.Level.GetVariable("CompletedCineNumber")
local foot4Climb = false
local foot4Stairs = false
local foot4Climb2Peaks = false
local kratosEmitter
local lightningSFXEvent = "SND_AMB_EMIT_Lightning_Close_Foot000"
function OnScriptLoaded(level)
  game.Audio.StartMusicMaster("SND_MX_FOOT_start_master")
  kratosEmitter = game.Player.FindPlayer():FindSingleSoundEmitterByName("SNDKratos")
end
function OnStart(level)
  if 450 <= cineNum and cineNum < 470 then
    SetFoothillsStormSoundState(nil, true)
  else
    SetFoothillsStormSoundState(nil, false)
  end
  game.Audio.StopAmbiences()
end
function approachpoisonMusic()
  if 185 <= cineNum and cineNum < 187 then
    game.Audio.StartCheckpointedMusic("SND_MX_FOOT_approach_poison_1")
  end
end
function foot4ClimbMusic()
  if 450 <= cineNum and cineNum < 460 and foot4Climb == false then
    game.Audio.StartMusic("SND_MX_FOOT4_explore1_out")
    foot4Climb = true
  end
end
function foot4StairsMusic()
  if 450 <= cineNum and cineNum < 460 and foot4Stairs == false then
    game.Audio.StartMusic("SND_MX_FOOT4_explore2_in")
    foot4Stairs = true
  end
end
function foot4Climb2PeaksMusic()
  if 450 <= cineNum and cineNum < 460 and foot4Climb2Peaks == false then
    game.Audio.StartMusic("SND_MX_FOOT4_explore2_out")
    foot4Climb2Peaks = true
  end
end
function PlaySoundLightningStrike(level)
  LD.PlaySound(kratosEmitter, lightningSFXEvent)
end
function SetFoothillsStormSoundState(level, turnOn)
  if turnOn then
    game.Audio.SetWwiseState("LVL_Foothills_Storm", "On")
    game.Audio.StopAmbiences()
  else
    game.Audio.SetWwiseState("LVL_Foothills_Storm", "Off")
    game.Audio.StopAmbiences()
  end
end
function Foot1ExploreMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_FOOT_explore2_in")
end
