local LD = require("design.LevelDesignLibrary")
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") < 190 or game.Level.GetVariable("CompletedCineNumber") > 470 then
    GameObjects.Door_FromCal.LuaObjectScript.Unlock()
  end
end
function LockDoor(level)
  GameObjects.Door_FromCal.LuaObjectScript.Lock()
end
function UnlockDoor(level)
  GameObjects.Door_FromCal.LuaObjectScript.Unlock()
end
function StartLTW(level)
  if game.Level.GetVariable("CompletedCineNumber") < 210 and game.Level.GetVariable("CompletedCineNumber") >= 190 then
    local freLTWWad = game.FindLevel("FreyaLTW")
    if freLTWWad ~= nil then
      LockDoor()
      freLTWWad:CallScript("LTW_ToLightbridge_Start")
      local Foot100_Level = game.FindLevel("Foot100_Base")
      if Foot100_Level ~= nil then
        Foot100_Level:CallScript("UnlockCrackClimb")
      end
      local cal250_Level = game.FindLevel("Cal250_FootHillsLH")
      if cal250_Level ~= nil then
        cal250_Level:CallScript("DisableCrackClimbSyncExitCA")
      end
    end
  end
end
local doorSound = {
  OnInteractForward_Center = "SND_DOOR_Foot100_Stone_Wind_OPEN",
  OnInteractBackward_Center = "SND_DOOR_Foot100_Stone_Wind_OPEN"
}
function OnScriptLoaded(level, obj)
  SoundInit()
end
function SoundInit()
  GameObjects.Door_FromCal.LuaObjectScript.SoundSetup(doorSound)
end
