local LD = require("design.LevelDesignLibrary")
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function CineDoorInteraction()
  local cineLevel
  local doorObj = GameObjects.Door_FromCal.Child
  if game.Level.GetVariable("CompletedCineNumber") < 185 then
    cineLevel = game.FindLevel("Foot110_CS185")
    if cineLevel ~= nil then
      doorObj.LuaObjectScript.EnableCinematicTrigger()
      GameObjects.Cine_SindriIntro.LuaObjectScript.SetupCineSequence()
    end
  elseif game.Level.GetVariable("CompletedCineNumber") < 450 and game.Level.GetVariable("CompletedCineNumber") >= 440 then
    doorObj.LuaObjectScript.EnableCinematicTrigger()
    GameObjects.Cine_SindriGetsServed.LuaObjectScript.SetupCineSequence()
  end
end
function UseDoorB()
  if game.Level.GetVariable("CompletedCineNumber") < 210 and game.Level.GetVariable("CompletedCineNumber") >= 190 then
    local doorObj = GameObjects.Door_FromCal.Child
    local player = game.Player.FindPlayer()
    doorObj.LuaObjectScript.EnableCinematicTrigger(true)
    player:RequestInteract(doorObj)
    LD.PlayApproach_GroupSync(doorObj, {
      {
        player,
        "BRA_DoorSpreadFreyaOpen"
      },
      {
        game.AI.FindSon(),
        "BRA_DoorSpreadFreyaOpen"
      },
      {
        LD:FindFreya(),
        "BRA_DoorSpreadFreyaOpen",
        {keepEvaluatingPath = true}
      }
    }, "DoorSpreadFreyaOpenReverse", true, "synchJointBack", {completion_percentage = 0.7})
    local freyaChar = LD.FindFreya()
    if freyaChar ~= nil then
      freyaChar:CallScript("ForceForwardSplineNavState")
    end
  end
end
