local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local CCOS = require("camera.camera_oneshot")
local checkpoint = require("level.checkpoint")
local thisLevel, player, son, goSpecialIntroWulver, bDoWulverCheck, oneShotCam, SpinChest_UndimTimer
local vibrateRockBroken = 0
local StatuesBroken = true
local CA_CenterArea_State = 0
local CA_PoisonSecret_State = 0
local CA_UpperRightArea_State = 0
local LoadZones_CS185, LoadZones_CS190, LoadZones_CS250, LoadZones_CS450
Enemy_HealthMonitor = nil
local A1_ZM_1, A1_ZM_2, Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_3, A2_ZM_1, A2_ZM_2, Area_2_Encounter_1, A3_ZM_1, Area_3_Encounter_1, Area_3_Encounter_2, A4_ZM_1, Area_4_Encounter_1
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  LoadZones_CS185 = GameObjects.______Load_CS185
  LoadZones_CS190 = GameObjects.______Load_CS190
  LoadZones_CS250 = GameObjects.______Load_CS250
  LoadZones_CS450 = GameObjects.______Load_CS450
  Area_1_Fight_1()
  Area_1_Fight_2()
  Area_1_Fight_3()
  Area_3_Fight_2()
  CompassGatewayToggle()
end
function OnFirstStart(level)
  initialSetup()
end
function OnPreStart(level)
  GameObjects.coffin_tier1_foot100_1.LuaObjectScript.DisableCheckpointRequirement()
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") < 185 then
    initialSetup()
  end
  if game.Level.GetVariable("CompletedCineNumber") > 184 and game.Level.GetVariable("CompletedCineNumber") < 190 then
    EnableShop()
  elseif game.Level.GetVariable("CompletedCineNumber") > 249 and game.Level.GetVariable("CompletedCineNumber") < 440 then
    EnableShop()
  elseif game.Level.GetVariable("CompletedCineNumber") > 449 then
    EnableShop()
  end
  GameObjects.Shop.LuaObjectScript.DisableShopContextAction()
  LD.RegisterForCineUpdate(level, {
    {
      at = 185,
      immediateFn = PostSindriCS
    },
    {
      at = 190,
      immediateFn = PostFreyaLeadWaySetup,
      fn = PostFreyaLeadWaySetup
    },
    {
      at = 250,
      immediateFn = SecondArrivalSetup,
      fn = SecondArrivalSetup
    },
    {
      at = 440,
      immediateFn = StormArrivalSetup,
      fn = StormArrivalSetup
    },
    {
      at = 450,
      immediateFn = PostSindriCS
    },
    {
      at = 470,
      immediateFn = PostStormSetup
    }
  })
end
function EnableCheckpointZone()
  GameObjects.Checkpoints_atCal250Door:Show()
end
function initialSetup()
  GameObjects.Checkpoints_atCal250Door:Hide()
  LoadZones_CS190:HideEntityVolume()
  LoadZones_CS250:HideEntityVolume()
  LoadZones_CS450:HideEntityVolume()
  SpinChest_UndimTimer = SpinChest_UndimTimer
  DimChestRunes()
  GameObjects.StoneTroll_Statues_Broken:Hide()
  GameObjects.Broken_GondolaParts:Hide()
  FLW_Enable_ContextActions()
  Disable_GondolaNoGo()
end
function PostSindriCS()
end
function PostFreyaLeadWaySetup()
  LoadZones_CS185:HideEntityVolume()
  LoadZones_CS190:ShowEntityVolume()
  FLW_Disable_ContextActions()
  local objArray = game.World.FindGameObjectsByMarker("Sindri00")
  for _, obj in ipairs(objArray) do
    if obj:GetCreature() ~= nil then
      obj:Destroy()
    end
  end
  DisableShop()
end
function SecondArrivalSetup()
  LoadZones_CS190:HideEntityVolume()
  LoadZones_CS250:ShowEntityVolume()
  UnlockCrackClimb()
  FLW_Enable_ContextActions()
  GameObjects.CA_LowerLeft_GondolaLookUp.LuaObjectScript.Disable()
  GameObjects.LTW_Base_A.LuaObjectScript.Disable()
  Enable_GondolaNoGo()
end
function StormArrivalSetup()
  LoadZones_CS250:HideEntityVolume()
  LoadZones_CS450:ShowEntityVolume()
  GameObjects.StoneTroll_Statues_Broken:Show()
  GameObjects.Broken_GondolaParts:Show()
  GameObjects.StoneTroll_Statues:Hide()
  GameObjects.LTW_Base_A.LuaObjectScript.Enable()
  GameObjects.CA_LowerLeft_GondolaLookUp.LuaObjectScript.Enable()
  GameObjects.CA_CenterZone:HideEntityVolume()
  GameObjects.CA_CenterZone_atShop_Zone:HideEntityVolume()
  GameObjects.IdleContext_setZone_to200:HideEntityVolume()
  GameObjects.EntryZone_DiscoverSecret_PoisonTotem:HideEntityVolume()
  Disable_GondolaNoGo()
end
function PostStormSetup()
  GameObjects.Broken_GondolaParts:Hide()
  GameObjects.CA_CenterZone:ShowEntityVolume()
  GameObjects.CA_CenterZone_atShop_Zone:ShowEntityVolume()
  GameObjects.IdleContext_setZone_to200:ShowEntityVolume()
  GameObjects.EntryZone_DiscoverSecret_PoisonTotem:ShowEntityVolume()
end
function DiscoverFoothills()
  uiCalls.UI_Event_DiscoverLocation("Foothills")
end
function Foot200_LoadCheck()
  game.UI.LoadCheck("Foot200_Mid", "Foot500_Top")
end
function Cal250_LoadCheck()
  game.UI.LoadCheck("Foot200_Mid", "Cal250_FootHillsLH")
end
function OnWadLoaded(level, newLevel)
end
function OnUpdate(level)
  if bDoWulverCheck == true then
    CheckForSpecialWulver()
  end
  if oneShotCam ~= nil then
    oneShotCam:Update()
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    StatuesBroken = StatuesBroken,
    CA_PoisonSecret_State = CA_PoisonSecret_State,
    CA_CenterArea_State = CA_CenterArea_State
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  StatuesBroken = savedInfo.StatuesBroken
  CA_PoisonSecret_State = savedInfo.CA_PoisonSecret_State
  CA_CenterArea_State = savedInfo.CA_CenterArea_State
  local appVersion, masterVersion = level:GetAppMasterVersion()
  if appVersion == 256 then
    local savedAvailState = son:GetAvailabilityStateRequestByName("LevelDesignScript")
    if savedAvailState ~= nil and savedAvailState.Unoccupied == false then
      local vendorCheckpointPos = engine.Vector.New(-290.562, 8.144, 299.535)
      if player:GetWorldPosition():Distance(vendorCheckpointPos) < 2 then
        son:RemoveAvailabilityRequest("LevelDesignScript")
        if savedAvailState.AvailableForSync == false or savedAvailState.AvailableForBanter == false or savedAvailState.AvailableInLevel == false or savedAvailState.AvailableForCombat == false then
          savedAvailState.Unoccupied = true
          son:SetNewAvailabilityRequest("LevelDesignScript", savedAvailState)
        end
      end
    end
  end
end
function EnterBehaviorContext_WAIT_AND_EXPLORE()
  if game.Level.GetVariable("CompletedCineNumber") < 440 or game.Level.GetVariable("CompletedCineNumber") > 470 then
    son:CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
  else
    son:CallScript("EnterBehaviorContext", "FRUSTRATED_BEHAVIOR_CONTEXT_CONFIG")
  end
end
function EnterBehaviorContext_NEARPOISON()
  if game.Level.GetVariable("CompletedCineNumber") < 440 or game.Level.GetVariable("CompletedCineNumber") > 470 then
    son:CallScript("EnterBehaviorContext", "SICK_BEHAVIOR_CONTEXT_CONFIG")
  else
    son:CallScript("EnterBehaviorContext", "FRUSTRATED_BEHAVIOR_CONTEXT_CONFIG")
  end
end
function EnterBehaviorContext_BORED()
  son:CallScript("EnterBehaviorContext", "BORED_BEHAVIOR_CONTEXT_CONFIG")
end
function ClearBehaviorContext()
  son:CallScript("ClearBehaviorContext")
end
function PoisonTotem_05_Embed()
  GameObjects.CA_TotemSaveSpot_01_A.LuaObjectScript.Disable()
  GameObjects.CA_TotemSaveSpot_01_B.LuaObjectScript.Disable()
end
function PoisonTotem_05_Unembed()
  GameObjects.CA_TotemSaveSpot_01_A.LuaObjectScript.Enable()
  GameObjects.CA_TotemSaveSpot_01_B.LuaObjectScript.Enable()
end
function VibrateWall_Break()
  GameObjects.CA_VibrateWall.LuaObjectScript.Disable()
end
function FLW_Disable_ContextActions()
  GameObjects.CA_LowerLeft_GondolaLookUp.LuaObjectScript.Disable()
  GameObjects.CA_CenterZone:HideEntityVolume()
  GameObjects.CA_CenterZone_atShop_Zone:HideEntityVolume()
  GameObjects.EntryZone_003:HideEntityVolume()
  GameObjects.LTW_Base_D.LuaObjectScript.Disable()
end
function FLW_Enable_ContextActions()
  GameObjects.CA_LowerLeft_GondolaLookUp.LuaObjectScript.Enable()
  GameObjects.CA_CenterZone:ShowEntityVolume()
  GameObjects.CA_CenterZone_atShop_Zone:ShowEntityVolume()
  GameObjects.EntryZone_003:ShowEntityVolume()
  GameObjects.LTW_Base_D.LuaObjectScript.Enable()
end
function CentralArea_Disable_ContextActions()
  GameObjects.CA_CentralArea_atShop.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Statue01_LookUp.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Statue02_LookUp.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_StatueBroken_LookAt.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Shop_LookIn.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Shop_WarmHands.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Shop_LookUnderTable.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Table_LookUnder.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Table_LookAt.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Bored_01.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Bored_02.LuaObjectScript.Disable()
  GameObjects.CA_CentralArea_Secret_PosionTotem.LuaObjectScript.Disable()
end
function CentralArea_Enable_ContextActions()
  if CA_CenterArea_State == 0 then
    CA_CenterArea_State = math.random(1, 2)
  end
  if CA_CenterArea_State == 1 then
    CA_CenterArea_State = 2
    GameObjects.CA_CentralArea_Statue01_LookUp.LuaObjectScript.Enable()
    GameObjects.CA_CentralArea_Shop_LookUnderTable.LuaObjectScript.Enable()
    GameObjects.CA_CentralArea_Table_LookUnder.LuaObjectScript.Enable()
    if CA_PoisonSecret_State == 1 then
      GameObjects.CA_CentralArea_Secret_PosionTotem.LuaObjectScript.Enable()
    else
      GameObjects.CA_CentralArea_Shop_WarmHands.LuaObjectScript.Enable()
    end
  else
    CA_CenterArea_State = 1
    GameObjects.CA_CentralArea_Statue02_LookUp.LuaObjectScript.Enable()
    GameObjects.CA_CentralArea_Shop_LookIn.LuaObjectScript.Enable()
    GameObjects.CA_CentralArea_Table_LookAt.LuaObjectScript.Enable()
    if CA_PoisonSecret_State == 1 then
      GameObjects.CA_CentralArea_Secret_PosionTotem.LuaObjectScript.Enable()
    else
      GameObjects.CA_CentralArea_StatueBroken_LookAt.LuaObjectScript.Enable()
    end
  end
end
function CA_PoisonSecret_Discovered()
  if CA_PoisonSecret_State == 0 then
    CA_PoisonSecret_State = 1
  end
end
function CA_PoisonSecret_Solved()
  CA_PoisonSecret_State = 2
end
function CA_PoisonSecret_TotemPinned()
  if CA_PoisonSecret_State == 1 then
    GameObjects.EnvironmentEventEmitter.LuaObjectScript.Trigger()
    GameObjects.CA_CentralArea_Secret_PosionTotem.LuaObjectScript.Disable()
  end
end
function LowerRightArea_Disable_ContextActions()
  GameObjects.CA_LowerRight_Idle.LuaObjectScript.Disable()
  GameObjects.CA_LowerRight_LeanOnWall.LuaObjectScript.Disable()
end
function LowerRightArea_Enable_ContextActions()
  GameObjects.CA_LowerRight_Idle.LuaObjectScript.Enable()
  GameObjects.CA_LowerRight_LeanOnWall.LuaObjectScript.Enable()
end
function UpperRightArea_Disable_ContextActions()
  GameObjects.CA_UpperRight_WarmHands.LuaObjectScript.Disable()
  GameObjects.CA_UpperRight_LeanOnWall.LuaObjectScript.Disable()
  GameObjects.CA_UpperRight_SitOnGround.LuaObjectScript.Disable()
end
function UpperRightArea_Enable_ContextActions()
  if CA_UpperRightArea_State == 0 then
    CA_UpperRightArea_State = math.random(1, 2)
  end
  if CA_UpperRightArea_State == 1 then
    CA_UpperRightArea_State = 2
    GameObjects.CA_UpperRight_WarmHands.LuaObjectScript.Enable()
    GameObjects.CA_UpperRight_LeanOnWall.LuaObjectScript.Enable()
  else
    CA_UpperRightArea_State = 1
    GameObjects.CA_UpperRight_SitOnGround.LuaObjectScript.Enable()
  end
end
function Enable_GondolaNoGo()
  GameObjects.Gondola_NoGo:ShowNavObstacle()
end
function Disable_GondolaNoGo()
  GameObjects.Gondola_NoGo:HideNavObstacle()
end
function DisableShop()
  local SindriSpawnObject = thisLevel:GetGameObject("VendorSpawner")
  local SindriRef = SindriSpawnObject.LuaObjectScript.GetLastEnemy()
  if SindriRef ~= nil then
    print("Brok Ref is...", SindriRef)
    SindriRef:Destroy()
  end
  local Shop = thisLevel:GetGameObject("smallShopModule")
  Shop.LuaObjectScript.DespawnTriggered()
end
function EnableShop()
  local SindriSpawnObject = thisLevel:GetGameObject("VendorSpawner")
  SindriSpawnObject.LuaObjectScript.SpawnEnemy()
end
function DimChestRunes()
  GameObjects.MemoryChest_SpinBase1.LuaObjectScript.DimRunes()
  SpinChest_UndimTimer = timer.StartLevelTimer(3, function()
    GameObjects.MemoryChest_SpinBase1.LuaObjectScript.HideRunes()
  end)
end
function UndimChestRunes()
  if SpinChest_UndimTimer ~= nil then
    SpinChest_UndimTimer:Reset()
  end
  GameObjects.MemoryChest_SpinBase1.LuaObjectScript.ShowRunes()
  GameObjects.MemoryChest_SpinBase1.LuaObjectScript.UndimRunes()
end
function UnlockCrackClimb()
  GameObjects.CrackClimb_toFoot200:ShowTraversePath()
end
function LockCrackClimb()
  GameObjects.CrackClimb_toFoot200:HideTraversePath()
end
function Unlock_RidgeChest()
  GameObjects.coffin_tier1_foot100_1.LuaObjectScript.Enable()
  GameObjects.Behavior_NearPoison_01:HideEntityVolume()
end
function Lock_RidgeChest()
  GameObjects.coffin_tier1_foot100_1.LuaObjectScript.Disable()
  GameObjects.Behavior_NearPoison_01:ShowEntityVolume()
end
function Embed_VibratePath()
  GameObjects.Behavior_NearPoison_02:HideEntityVolume()
  GameObjects.CA_TotemSaveSpot_01_A.LuaObjectScript.Disable()
end
function Unembed_VibratePath()
  GameObjects.Behavior_NearPoison_02:ShowEntityVolume()
  GameObjects.CA_TotemSaveSpot_01_A.LuaObjectScript.Enable()
end
function Uncover_BrambleTotem()
  GameObjects.BrambleBlocker_Collision:HideCollision()
end
function Unlock_VibrateChest()
  GameObjects.coffin_tier3_foot100_2.LuaObjectScript.Enable()
  GameObjects.Behavior_NearPoison_03:HideEntityVolume()
end
function Lock_VibrateChest()
  GameObjects.coffin_tier3_foot100_2.LuaObjectScript.Disable()
  GameObjects.Behavior_NearPoison_03:ShowEntityVolume()
end
function Unlock_CubbyChest()
  GameObjects.coffin_tier1_foot100_2.LuaObjectScript.Enable()
  GameObjects.Behavior_NearPoison_04:HideEntityVolume()
end
function Lock_CubbyChest()
  GameObjects.coffin_tier1_foot100_2.LuaObjectScript.Disable()
  GameObjects.Behavior_NearPoison_04:ShowEntityVolume()
end
function CompassGatewayToggle()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cineNumber < 190 then
    game.Compass.SetGatewayMarkerIsOpen("FOOT_100_Helper3", false)
  end
end
function HideWulverIntroCameraVolume()
  GameObjects.CamZone_WulverIntro:HideCameraVolume()
end
function DoSpecialWulverSetup(gob)
  goSpecialIntroWulver = gob
  bDoWulverCheck = true
  GameObjects.CamZone_WulverIntro:ShowCameraVolume()
end
function DisableWulverIntro()
  game.UI.Idle(false)
  if oneShotCam ~= nil then
    oneShotCam = nil
  end
  GameObjects.CamZone_WulverIntro:HideCameraVolume()
end
function CheckForSpecialWulver()
  if goSpecialIntroWulver == nil then
    return
  end
  local bPlayingMove = goSpecialIntroWulver:IsPlayingMove("MOV_AmbushAboveAggro")
  if bPlayingMove == false then
    return
  end
  bDoWulverCheck = false
  oneShotCam = CCOS.OneShotCamera.New("PLYR_Foot100_WulverIntro", 4)
  game.UI.Idle(true)
  local recenterproperties = {
    TimeStart = 0,
    TimeDuration = 0.86,
    YawRange = 360,
    PitchRange = 0
  }
  game.Camera.Recenter(recenterproperties)
  oneShotCam:SetCallback(DisableWulverIntro)
  oneShotCam:Start()
end
function SpawnWulver()
  GameObjects.WulverIntro_Spawner.LuaObjectScript.SpawnEnemy()
  GameObjects.______WulverIntro:HideEntityVolume()
end
function FanaticFoot100Checkpoint()
  if Area_1_Encounter_1:IsComplete() and Area_1_Encounter_2:IsComplete() then
    game.World.StoreCheckpoint()
  end
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC: Fanatics + Crawlers FOOT 100", {
    CheckpointOnComplete = false,
    spawnWad = "Foot100_Base_AI_Visit01"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Fanatic_L1_Projectile",
      spawnLocators = "A1_O_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Fanatic_L1_Projectile",
      spawnLocators = "A1_O_Loc_06",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Fanatic_L1_Projectile",
      spawnLocators = "A1_O_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 14
    },
    {
      spawners = "Crawler_L1_S",
      spawnLocators = "A1_O_Loc_07",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15
    }
  })
  Area_1_Encounter_1:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Fanatic_L2_Projectile",
      spawnLocators = "A2_O_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Fanatic_L2_Projectile",
      spawnLocators = "A1_O_Loc_05",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    },
    {
      spawners = "Crawler_L1_S",
      spawnLocators = "A1_O_Loc_08",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    }
  })
  Area_1_Encounter_1:OnComplete(FanaticFoot100Checkpoint)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Fanatic")
  end)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Tatzelwurm_Stinger")
  end)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(2)
  end, {count = 3})
  Area_1_Encounter_1:OnEnemyDeath(function()
    GameObjects.Btr_Foot100.LuaObjectScript.JustCleanedThat_Banter()
  end, {count = 1})
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Spawn_1, {
    cineRequirement = {184, 186}
  })
  A1_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_1_Attack_1)
  A1_ZM_1:SetTriggerCountLimit(1)
  A1_ZM_1:OnEnter(function()
    Area_1_Encounter_1:AlertEnemies()
  end)
end
function Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC: Fanatics Turrets FOOT 100", {
    CheckpointOnComplete = false,
    spawnWad = "Foot100_Base_AI_Visit01",
    LeashZone = "Foot100LeashZone"
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Fanatic_L1_Turret",
      spawnLocators = "A1_O_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Fanatic_L1_Turret",
      spawnLocators = "A1_O_Loc_09",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_1_Encounter_2:SetStartZone(GameObjects.EntZn_Area_1_Spawn_1, {
    cineRequirement = {184, 186}
  })
  Area_1_Encounter_2:OnComplete(FanaticFoot100Checkpoint)
end
function Area_1_Fight_3()
  Area_1_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC: FOOT 2 Wolves Jump down fight", {
    CheckpointOnComplete = true,
    spawnWad = "Foot100_Base_AI_Visit02"
  })
  Area_1_Encounter_3:AddWave({
    {
      spawners = "Wolf_N_JUMP_1",
      markerID = "Intro_Wulver",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_N_JUMP_2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    },
    {
      spawners = "Wolf_N_SRFC",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_N_JUMP_3",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  Area_1_Encounter_3:SetStartZone(GameObjects.EntZn_Wulver_Path_Alert, {
    cineRequirement = {200, 330}
  })
  Area_1_Encounter_3:OnEnemySpawn(DoSpecialWulverSetup, {
    markerID = "Intro_Wulver"
  })
  Area_1_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wolf_Rabid")
  end)
end
function Health_Encounter(Enemy)
  if Enemy ~= nil then
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local EnemyHealth = Enemy:GetHitPoints() * 0.7
    Enemy_HealthMonitor:OnHealthLessThan(EnemyHealth, function()
      Area_1_Encounter_3:StartWave()
    end)
  end
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC: Wulver Foot100", {
    CheckpointOnComplete = true,
    spawnWad = "Foot100_Base_AI_Visit02"
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Wulver_N_SUI",
      markerID = "Chest_Wulver",
      spawnLocators = "A2_O_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  A2_ZM_2 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_2_DeSpawn)
  A2_ZM_2:Stop()
  A2_ZM_2:OnEnter(function()
    if Area_2_Encounter_1 ~= nil then
      local enemy = LD.FindSingleAIByMarker("Chest_Wulver")
      local inCombat = enemy.IsAggressive()
      if Area_2_Encounter_1:IsComplete() and not inCombat then
        A2_ZM_2:Stop()
      else
        Area_2_Encounter_1:DespawnEnemies()
        A2_ZM_1:Start()
        uiCalls.UI_Event_SendDesignerMessage("DespawnEnemies", 0)
      end
      A2_ZM_2:Stop()
    end
  end)
  A2_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_2_Spawn_1)
  A2_ZM_1:OnEnter(function()
    if Area_2_Encounter_1:IsComplete() and not Area_2_Encounter_1:isRunning() then
      A2_ZM_1:Stop()
    else
      Area_2_Encounter_1:Reset()
      Area_2_Encounter_1:Start()
      A2_ZM_1:Stop()
      A2_ZM_2:Start()
      uiCalls.UI_Event_SendDesignerMessage("Spawn", 0)
    end
  end)
end
function Area_3_Fight_2()
  Area_3_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 2]EC: Ice Wall Ambush Foot100", {
    CheckpointOnComplete = false,
    spawnWad = "Foot100_Base_AI_Visit02"
  })
  Area_3_Encounter_2:AddWave({
    {
      spawners = "Wolf_N_SRFC",
      spawnLocators = "A3_O_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_3_Encounter_2:AddWave({
    {
      spawners = "Wolf_N_SRFC",
      spawnLocators = "A3_O_Loc_04",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_3_Encounter_2:SetStartZone(GameObjects.EntZn_Area_3_Spawn_2, {
    cineRequirement = {200, 330}
  })
  Area_3_Encounter_2:OnEnemySpawn(function()
    A3_ZM_1:Start()
  end)
  A3_ZM_1 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_Area_3_Attack_1)
  A3_ZM_1:Stop()
  A3_ZM_1:OnEnter(function()
    if Area_3_Encounter_2 ~= nil then
      Area_3_Encounter_2:AlertEnemies()
      Area_3_Encounter_2:StartWave(2)
      A3_ZM_1:Stop()
    end
  end)
end
function LuaFunctionForwarding_StartCounterRequest(thisObj, npc)
  GameObjects.smallShopModule.LuaObjectScript.StartCounterRequest(npc)
end
function Hide_DoorCheckpoint()
  GameObjects.Checkpoints_atCal250Door:HideEntityVolume()
end
function Show_DoorCheckpoint()
  GameObjects.Checkpoints_atCal250Door:ShowEntityVolume()
end
function Trigger_Out_Of_Bounds()
  player:AddMarker("Out_Of_Bounds")
end
function Trigger_In_Bounds()
  player:RemoveMarker("Out_Of_Bounds")
end
