local timers = require("level.timer")
local player
local smokeCleared = false
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
  end
end
function SetSmokeCleared()
  smokeCleared = true
end
function SetSmokeNotCleared()
  smokeCleared = false
end
function IsBanterSafeToFire()
  return CanFireBanter() and smokeCleared
end
function CanFireBanter()
  local enemiesAlive = player:FindEnemies(20)
  return #enemiesAlive <= 0 and IsValidCineNum()
end
function IsValidCineNum()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  return 185 <= cineNum and cineNum < 187
end
function FoothillStoneTrollReact_Banter()
end
function TrollFight1_Over()
  FoothillStoneTrollDead_Banter()
end
function TrollFight1_Start()
  FoothillStoneTrollReact_Banter()
end
function FoothillStoneTrollReact_Banter()
end
function FoothillStoneTrollDead_Banter()
  if not banterPlayed.FoothillStoneTrollDead then
    timers.StartLevelTimer(4, function()
      game.Audio.PlayBanter("006_FoothillStoneTrollDead")
    end)
    banterPlayed.FoothillStoneTrollDead = true
  end
end
function MotherWouldDisagree_Banter()
  if not banterPlayed.MotherWouldDisagree then
    timers.StartLevelTimer(4, function()
      game.Audio.PlayBanter("020_MotherWouldDisagree", MotherWouldDisagree_Complete)
    end)
    banterPlayed.MotherWouldDisagree = true
  end
end
function JustCleanedThat_Banter()
  if not banterPlayed.JustCleanedThat then
    game.Audio.PlayBanter("012_JustCleanedThat")
    banterPlayed.JustCleanedThat = true
  end
end
function MotherWouldDisagree_Complete()
  GameObjects.Cbt_Foot100_R03_Script.LuaObjectScript.Banter_020_OnComplete()
end
