local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, enc_1_fight_1, enc_1_fight_2a, enc_1_fight_2b, enc_1_fight_5, enc_1_fight_6, enc_1_fight_1Alert
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  FNC_1_Fight_1()
  FNC_1_Fight_2a()
end
function OnStart(level, obj)
  if enc_1_fight_1:WasRunning() then
    enc_1_fight_1:Start()
  end
  GameObjects.EntZn_Wulver_Ledge_Spawn1:HideEntityVolume()
  GameObjects.EntZn_Wulver_Ledge_Spawn2:HideEntityVolume()
  GameObjects.EntZn_Wulver_Ambush:HideEntityVolume()
end
function FNC_1_Fight_1()
  enc_1_fight_1 = EC.NewEncounter(thisLevel, "[EC1] Foot100 - R03 - Jotunn + Wulver Fight", {CheckpointOnComplete = true})
  enc_1_fight_1:AddWave({
    {
      spawners = "Wulver00_PL5_Pwr_SUP_TrollPath",
      spawnWad = "Foot100_Base_AI_Visit03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Jotunn10_PL3_SPA",
      spawnWad = "Foot100_Base_AI_Visit03",
      markerID = "Troll",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer10_PL2_U_Pather_1",
      spawnWad = "Foot100_Base_AI_Visit03",
      spawnLocators = "A1_O_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0.5,
      totalSpawns = 1,
      spawnCooldown = {2, 3}
    },
    {
      spawners = "Flyer10_PL2_U_Pather_2",
      spawnWad = "Foot100_Base_AI_Visit03",
      maxActive = 1,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1,
      totalSpawns = 1,
      spawnCooldown = {2, 3}
    }
  })
  enc_1_fight_1:SetStartZone(GameObjects.EntZn_Troll00_Spawn, {cineRequirement = 450})
  enc_1_fight_1:SetAlertZone(GameObjects.EntZn_Wulver_Path_Alert)
  enc_1_fight_1:OnComplete(function()
    GameObjects.Btr_Foot100.LuaObjectScript.TrollFight1_Over()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wulver_Power")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Possess")
  end)
end
function FNC_1_Fight_2a()
  enc_1_fight_2a = EC.NewEncounter(thisLevel, "[EC2a] Foot100 - R03 - Pathing Wulver 1", {CheckpointOnComplete = false})
  enc_1_fight_2a:AddWave({
    {
      spawners = "Wulver00_PL2_SUP_Path1",
      spawnWad = "Foot100_Base_AI_Visit03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
end
function FNC_1_Fight_2b()
  enc_1_fight_2b = EC.NewEncounter(thisLevel, "[EC2b] Foot100 - R03 - Pathing Wulver 2", {CheckpointOnComplete = false})
  enc_1_fight_2b:AddWave({
    {
      spawners = "Wulver00_PL2_SUP_Path2",
      spawnWad = "Foot100_Base_AI_Visit03",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  enc_1_fight_2b:SetAlertZone(GameObjects.EntZn_Wulver_Path_Alert)
end
function Banter_020_OnComplete()
  enc_1_fight_1:Start()
  enc_1_fight_2a:Start()
  GameObjects.EntZn_Wulver_Ledge_Spawn1:ShowEntityVolume()
  GameObjects.EntZn_Wulver_Ledge_Spawn2:ShowEntityVolume()
  GameObjects.EntZn_Wulver_Ambush:ShowEntityVolume()
end
