local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local uiCalls = require("ui.uicalls")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, sindriActor, gearProp, hammerProp, tableProp, wrenchProp, brushProp
local cineProps = {}
local lightObj, camCineEnterSindriIntro
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(thisObj)
end
function OnStart(level, obj)
  SetupActors()
  SetupProps()
  SetupLights()
end
function SpawnOrFindSindri()
  local sindri = ND.FindSindri()
  if sindri == nil then
    local jointFace = thisObj:GetWorldJointForward(thisObj:GetJointIndex("Sindri_StartJoint"))
    local jointPos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("Sindri_StartJoint"))
    return game.AI.Spawn(game.FindLevel("Foot100_Base"), jointPos, jointFace, "CRT_Sindri00")
  end
  return sindri
end
function RunFunctionOnObjectsInTable(obj_table, func_name, ...)
  for _, this_obj in ipairs(obj_table) do
    this_obj[func_name](this_obj, ...)
  end
end
function SetupProps()
  gearProp = GameObjects.gearProp.Child
  hammerProp = GameObjects.sindriHammerProp.Child
  tableProp = GameObjects.sindriTableProp.Child
  wrenchProp = GameObjects.wrenchProp.Child
  brushProp = GameObjects.brushProp.Child
  cineProps = {
    gearProp,
    hammerProp,
    tableProp,
    wrenchProp,
    brushProp
  }
  HideAllProps()
end
function SetupActors()
  kraActor = actor.Actor.New("SINDRI INTRO: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SINDRI INTRO: Son Actor", game.AI.FindSon)
  sindriActor = actor.Actor.New("SINDRI INTRO: Sindri Actor")
  sindriActor:SetSpawnFunction(SpawnOrFindSindri)
end
function SetupLights()
  lightObj = GameObjects.Cine_Start_185
  lightObj:Hide()
end
function PlayLights()
  lightObj:Show()
  lightObj:JumpAnimToFrame(0)
  lightObj:PlayAnimToEnd()
end
function SetupCineSequence()
  local doorObj = GameObjects.Door_FromCal.Child
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Sindri Intro Sequence")
  local slaveTab = {
    {Actor = sonActor},
    {Actor = sindriActor},
    {
      Obj = gearProp,
      Anim = "narFootSindriIntro000CineScene"
    },
    {
      Obj = hammerProp,
      Anim = "narFootSindriIntro000CineScene"
    },
    {
      Obj = wrenchProp,
      Anim = "narFootSindriIntro000CineScene"
    },
    {
      Obj = brushProp,
      Anim = "narFootSindriIntro000CineScene"
    },
    {
      Obj = tableProp,
      Anim = "narFootSindriIntro000CineScene"
    },
    {
      Obj = doorObj,
      Anim = "narFootSindriIntro000CineScene"
    }
  }
  doorObj.LuaObjectScript.EnableCinematicTrigger()
  cineSeq:SetPostSkipMusic("SND_MX_FOOT_start_master", nil, nil, nil, nil, "SND_MX_FOOT_explore2_in")
  cineSeq:MarkAbleToSkip()
  cineSeq:SpawnActorAndWait(sindriActor)
  cineSeq:Do(CamStartCineEnterSindriIntro)
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_SindriIntro",
    ReferenceJoint = "SindriIntro_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.StopTurnRadius,
    weapon_state = "bare_on_back",
    completion_percentage = 0.75,
    INT8_HACK_final_equip_move = "MOV_EquipWeaponAxeToBare_Interact"
  })
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_SindriIntro",
    ReferenceJoint = "SindriIntro_SynchJoint"
  })
  cineSeq:Do(PlayLights)
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 30)
  cineSeq:Do(function()
    uiCalls.UI_Event_DiscoverLocation("Foothills")
  end)
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 440)
  cineSeq:Do(ShowAllProps)
  cineSeq:Do(function()
    game.FindLevel("Foot100_Base"):CallScript("EnableCheckpointZone")
  end)
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 676)
  cineSeq:WaitUntilActorAnimPastPercentage(sindriActor, 0.999)
  cineSeq:StopPuppetingActor(sindriActor)
  cineSeq:Do(BranchSindriToTableIdle)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:Do(function()
    Complete_RP_Obj956()
  end)
  cineSeq:Do(function()
    lightObj:Hide()
  end)
  cineSeq:Do(function()
    game.FindLevel("Foot050_Sound"):CallScript("Foot1ExploreMusic")
  end)
  cineSeq:Do(SindriBestiaryEntry)
  cineSeq:SetCompletedCineNumber(185)
  cineSeq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "04_Foothills_010_Start"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  cineSeq:StartSequence()
end
function BranchSindriToTableIdle()
  game.FindLevel("Foot100_Base"):CallScript("LuaFunctionForwarding_StartCounterRequest", sindriActor:GetCreature())
end
function ShowAllProps()
  RunFunctionOnObjectsInTable(cineProps, "Show")
end
function HideAllProps()
  RunFunctionOnObjectsInTable(cineProps, "Hide")
end
function CanSeqFire()
  return game.Level.GetVariable("CompletedCineNumber") < 185
end
function CamStartCineEnterSindriIntro()
  game.SubObject.Wake(thisObj)
  camCineEnterSindriIntro = CCEC.CineEnterCamera.New("ENV_CineEnter_narFootSindriIntro000CineScene", 5, nil)
  camCineEnterSindriIntro:SetCallback(DestroyCamSindriIntro)
  camCineEnterSindriIntro:Start()
end
function DestroyCamSindriIntro()
  game.SubObject.Sleep(thisObj)
  camCineEnterSindriIntro = nil
end
function Complete_RP_Obj956()
  game.QuestManager.ProposeQuestState("Quest_RiverPass_Objective956", "Complete")
  LD.CallFunctionAfterDelay(AttemptToTriggerGreeting, 4)
end
function SindriBestiaryEntry()
  LD.UnlockBestiaryEntry("Bestiary_Unlock_Sindri")
end
function AttemptToTriggerGreeting()
  local player = game.Player.FindPlayer()
  local foot100 = game.FindLevel("Foot100_Base")
  local shop = foot100:GetGameObject("Shop")
  local talkInteract = shop.Child:FindSingleGOByName("TalkInteract_SM")
  talkInteract.Child:CallScript("AttemptToTriggerGreeting")
  print("Attempting to trigger greeting with the child check")
end
function OnUpdate(level, obj)
  if camCineEnterSindriIntro ~= nil then
    camCineEnterSindriIntro:Update()
  end
end
