local LD = require("design.LevelDesignLibrary")
timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local thisLevel, son
local Ambush_Triggered = false
local A1_ZM_1, A1_ZM_2, Area_1_Encounter_2, enc_Witch_RunAway, playedPoleBtr, A2_ZM_1, A2_ZM_2, Area_2_Encounter_1, Area_2_Encounter_2, Enemy_HealthMonitor
banterBrotherFoundComplete = false
function OnScriptLoaded(level)
  thisLevel = level
  son = game.AI.FindSon()
  Area_2_Fight_1()
  Witch_RunAway()
end
function OnFirstStart(level)
  GameObjects.EntZn_V1_WitchRun_Spawn:HideEntityVolume()
  GameObjects.EntZn_V1_WitchRun_Alert:HideEntityVolume()
end
function OnPreStart(level)
  GameObjects.coffin_tier1_foot200_1.LuaObjectScript.DisableCheckpointRequirement()
end
function OnStart(level)
  GameObjects.EntZn_V1_WitchRun_Spawn:HideEntityVolume()
  GameObjects.EntZn_V1_WitchRun_Alert:HideEntityVolume()
  if game.Level.GetVariable("CompletedCineNumber") >= 440 then
    GameObjects.BrokenTotems:Show()
    GameObjects.PoisonTotem_Enc1_01.LuaObjectScript.Disable()
    GameObjects.PoisonTotem_Enc1_02.LuaObjectScript.Disable()
    GameObjects.PoisonTotem_Enc1_03.LuaObjectScript.Disable()
    GameObjects.PoisonTotem_Enc1_01:Hide()
    GameObjects.PoisonTotem_Enc1_02:Hide()
    GameObjects.PoisonTotem_Enc1_03:Hide()
    GameObjects.CA_TotemSaveSpot_01_A.LuaObjectScript.Disable()
    GameObjects.CA_TotemSaveSpot_02_A.LuaObjectScript.Disable()
    GameObjects.EntryZone_001:HideEntityVolume()
    GameObjects.Behavior_PoisonRunout_Zone:HideEntityVolume()
  else
    GameObjects.BrokenTotems:Hide()
    GameObjects.CA_TotemSaveSpot_01_A.LuaObjectScript.Enable()
    GameObjects.CA_TotemSaveSpot_02_A.LuaObjectScript.Enable()
  end
  GameObjects.CA_Totem_03_RunOut_A.LuaObjectScript.Disable()
  GameObjects.CA_Totem_03_RunOut_B.LuaObjectScript.Disable()
  GameObjects.CA_Totem_03_RunOut_C.LuaObjectScript.Disable()
end
function OnUpdate(level)
end
function OnUseWorld(level)
end
function UpdateLoadGroup()
  game.EvaluateLoadZones()
end
function OnEvaluateLoadGroup_LoadGroup_AI_200()
  if game.Level.GetVariable("CompletedCineNumber") < 440 then
    return "AI_Visit_01"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 440 and game.Level.GetVariable("CompletedCineNumber") < 470 then
    return "AI_Visit_02"
  end
end
function OnSaveCheckpoint(level)
  return {
    levelState = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelState)
end
function Foot300_LoadCheck()
  game.UI.LoadCheck("Foot300_Hallway")
end
function Foot240_LoadCheck()
  game.UI.LoadCheck("Foot240_ChiselSite")
end
function Foot100_LoadCheck()
  game.UI.LoadCheck("Foot100_Base")
end
function EnterBehaviorContext_WAIT_AND_EXPLORE()
  son:CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
end
function EnterBehaviorContext_NEARPOISON()
  son:CallScript("EnterBehaviorContext", "SICK_BEHAVIOR_CONTEXT_CONFIG")
end
function ClearBehaviorContext()
  son:CallScript("ClearBehaviorContext")
end
function Enable_NearPoison_Zone_01()
  GameObjects.Behavior_NearPoison_01:ShowEntityVolume()
  GameObjects.CA_TotemSaveSpot_01_A.LuaObjectScript.Enable()
end
function Disable_NearPoison_Zone_01()
  GameObjects.Behavior_NearPoison_01:HideEntityVolume()
  GameObjects.CA_TotemSaveSpot_01_A.LuaObjectScript.Disable()
end
function Enable_NearPoison_Zone_02()
  GameObjects.Behavior_NearPoison_02:ShowEntityVolume()
  GameObjects.CA_TotemSaveSpot_02_A.LuaObjectScript.Enable()
end
function Disable_NearPoison_Zone_02()
  GameObjects.Behavior_NearPoison_02:HideEntityVolume()
  GameObjects.CA_TotemSaveSpot_02_A.LuaObjectScript.Disable()
end
function Enable_NearPoison_Zone_03()
  GameObjects.Behavior_NearPoison_03:ShowEntityVolume()
  GameObjects.PoisonReact_03_Unenbed.LuaObjectScript.Trigger()
  timers.StartLevelTimer(0.1, function()
    GameObjects.Behavior_PoisonRunout_Zone:ShowEntityVolume()
  end)
end
function Disable_NearPoison_Zone_03()
  GameObjects.Behavior_NearPoison_03:HideEntityVolume()
  timers.StartLevelTimer(0.1, function()
    GameObjects.Behavior_PoisonRunout_Zone:HideEntityVolume()
  end)
end
function Enter_RunOut_Zone_03()
  GameObjects.CA_Totem_03_RunOut_A.LuaObjectScript.Enable()
  GameObjects.CA_Totem_03_RunOut_B.LuaObjectScript.Enable()
  GameObjects.CA_Totem_03_RunOut_C.LuaObjectScript.Enable()
end
function Exit_RunOut_Zone_03()
  GameObjects.CA_Totem_03_RunOut_A.LuaObjectScript.Disable()
  GameObjects.CA_Totem_03_RunOut_B.LuaObjectScript.Disable()
  GameObjects.CA_Totem_03_RunOut_C.LuaObjectScript.Disable()
end
function Enable_CAs_OutsideCubby()
  GameObjects.ContextAction_OutsideCubby.LuaObjectScript.Enable()
end
function Disable_CAs_OutsideCubby()
  GameObjects.ContextAction_OutsideCubby.LuaObjectScript.Disable()
end
function CA_Son_LiftGate_ShutOff()
  GameObjects.LiftGate_Zone:HideEntityVolume()
  Disable_CAs_LiftGate()
end
function Enable_CAs_LiftGate()
  GameObjects.ContextAction_LiftGate.LuaObjectScript.Enable()
end
function Disable_CAs_LiftGate()
  GameObjects.ContextAction_LiftGate.LuaObjectScript.Disable()
end
function ChestEnable()
  GameObjects.coffin_tier1_foot200_1.LuaObjectScript.Enable()
end
function ChestDisable()
  GameObjects.coffin_tier1_foot200_1.LuaObjectScript.Disable()
end
function ScornPoleAmbush()
  if Ambush_Triggered == false then
    Ambush_Triggered = true
    Area_2_Encounter_1:Start()
  end
end
function Area_2_Fight_1()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC: Poison Ambush Foot200", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.CheckpointOverride_WitchFight
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Witch_P_SEIF",
      spawnLocators = "A2_O_Loc_01",
      markerID = "Ambush_Witch",
      spawnWad = "Foot200_Mid_AI_Visit01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Area_2_Encounter_1:SetStartZone(GameObjects.EntZn_A1_V1_ChkPnt_Spawn, {
    cineRequirement = {184, 186}
  })
  Area_2_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Revenant_Poison")
  end)
end
function WitchSpawn(Enemy)
  if Enemy ~= nil then
    local EnemyHealth = Enemy:GetHitPoints()
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = EnemyHealth * 0.45
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Area_2_Encounter_1:StartWave()
    end)
  end
end
function RevenantRun()
  if Area_2_Encounter_1 ~= nil and not Area_2_Encounter_1:IsComplete() and not Area_2_Encounter_1:IsRunning() then
    GameObjects.EntZn_V1_WitchRun_Spawn:ShowEntityVolume()
    timers.StartLevelTimer(1, function()
      GameObjects.EntZn_V1_WitchRun_Alert:ShowEntityVolume()
    end)
  end
end
function Witch_RunAway()
  enc_Witch_RunAway = EC.NewEncounter(thisLevel, "Witching Spawns and Runs", {LoadCheck = false})
  enc_Witch_RunAway:AddWave({
    {
      spawners = "Witch_P_UIC_SRR",
      spawnWad = "Foot200_Mid_AI_Visit01",
      markerID = "Fake_Witch",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  enc_Witch_RunAway:OnEnemySpawn(TriggerWitchRun, {markerID = "Fake_Witch"})
  enc_Witch_RunAway:SetStartZone(GameObjects.EntZn_V1_WitchRun_Spawn, {
    cineRequirement = {184, 186}
  })
  enc_Witch_RunAway:SetAlertZone(GameObjects.EntZn_V1_WitchRun_Alert)
end
function TriggerWitchRun()
  local dragurIntro2 = LD.FindSingleAIByMarker("Fake_Witch")
  if dragurIntro2 ~= nil then
    timers.StartLevelTimer(2, function()
      dragurIntro2:TriggerMoveEvent("kLEAlert")
    end)
  end
  timers.StartLevelTimer(2, function()
    enc_Witch_RunAway:AlertEnemies()
  end)
  timers.StartLevelTimer(2, function()
    game.Audio.PlayBanter("Foot200_WitchSurprise")
  end)
  game.Audio.SetBanterFact("GlobalEncEndCD", "True", 200)
  timers.StartLevelTimer(4.5, function()
    enc_Witch_RunAway:DespawnEnemies()
  end)
  timers.StartLevelTimer(5, function()
    enc_Witch_RunAway:SetComplete()
  end)
end
function PlayBanterBrotherFound01(level)
  local questState = game.QuestManager.GetQuestState("Quest_UnfinishedBusiness01_Objective_01")
  if questState == "Active" and banterBrotherFoundComplete == false then
    game.Audio.PlayBanter("UB1_EnteringLevel")
    banterBrotherFoundComplete = true
  end
end
