local LD = require("design.LevelDesignLibrary")
local EC = require("design.Encounter")
local thisLevel, enc_1_fight_1, enc_1_fight_2, enc_2_fight_1, enc_3_fight_1, enc_4_fight_1
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  FNC_2_Fight_1()
end
function FNC_1_Fight_1()
  enc_1_fight_1 = EC.NewEncounter(thisLevel, "[EC1a] Foot200 - R02 - A1 Flyer Spawn  ", {CheckpointOnComplete = false})
  enc_1_fight_1:AddWave({
    {
      spawners = "Flyer10_PL2_SUA",
      spawnLocators = "A1_A_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot200_Mid_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer10_PL2_SUA",
      spawnLocators = "A1_A_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot200_Mid_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  enc_1_fight_1:SetStartZone(GameObjects.EntZn_A1_R03_Spawn_01, {cineRequirement = 450})
end
function FNC_1_Fight_2()
  enc_1_fight_2 = EC.NewEncounter(thisLevel, "[EC1b] Foot200 - R02 - A2 Flyer Spawn  ", {CheckpointOnComplete = false})
  enc_1_fight_2:AddWave({
    {
      spawners = "Flyer10_PL2_SUA",
      spawnLocators = "A2_A_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot200_Mid_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer10_PL2_SUA",
      spawnLocators = "A2_A_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot200_Mid_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  enc_1_fight_2:SetStartZone(GameObjects.EntZn_A1_R03_Spawn_01, {cineRequirement = 450})
end
function FNC_2_Fight_1()
  enc_2_fight_1 = EC.NewEncounter(thisLevel, "[EC2] Foot200 - A1R02 Helwalker Attack  ", {CheckpointOnComplete = true})
  enc_2_fight_1:AddWave({
    {
      spawners = "Helwalker_SH_PL2_Patrol_PathA",
      spawnWad = "Foot200_Mid_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = 0,
      spawnCooldown = 1
    },
    {
      spawners = "Helwalker_S_PL3_Patrol_PathC",
      spawnWad = "Foot200_Mid_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = 1,
      spawnCooldown = 0
    }
  })
  enc_2_fight_1:SetStartZone(GameObjects.EntZnGrp_A1_R03_Spawn_02, {cineRequirement = 450})
  enc_2_fight_1:OnComplete(function()
    game.UI.LoadCheck("Foot300_Hallway")
    game.FindLevel("Foot300_Hallway"):GetGameObject("Foot300_Banter"):CallScript("RespectYourMother_Banter")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Walker_Shield")
  end)
end
function FNC_3_Fight_1()
  enc_3_fight_1 = EC.NewEncounter(thisLevel, "[EC3] Foot200 - R02 - A2 Crawler Attack  ", {CheckpointOnComplete = true})
  enc_3_fight_1:AddWave({
    {
      spawners = "Crawler_PL2_SPA_PathA",
      spawnWad = "Foot200_Mid_AI_Visit02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Crawler_PL2_SPA_PathB",
      spawnWad = "Foot200_Mid_AI_Visit02",
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {2, 3}
    }
  })
  enc_3_fight_1:SetStartZone(GameObjects.EntZn_A2_R03_Spawn_01, {cineRequirement = 450})
end
function FNC_4_Fight_1()
  enc_4_fight_1 = EC.NewEncounter(thisLevel, "[EC4] Foot200 - R02 - A2 Flyer10 Spawn  ", {CheckpointOnComplete = false})
  enc_4_fight_1:AddWave({
    {
      spawners = "Flyer10_PL2_SUA",
      spawnWad = "Foot200_Mid_AI_Visit02",
      spawnLocators = "A2_A_Loc_01",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Flyer10_PL2_SUA",
      spawnWad = "Foot200_Mid_AI_Visit02",
      spawnLocators = "A2_A_Loc_02",
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {2, 3}
    }
  })
  enc_4_fight_1:SetStartZone(GameObjects.EntZn_A2_R03_Spawn_01, {cineRequirement = 450})
end
