local timer = require("level.timer")
local thisObj
local scornPoison_CoffinOpened = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.scornPoison_CoffinOpened = scornPoison_CoffinOpened
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  scornPoison_CoffinOpened = savedInfo.scornPoison_CoffinOpened
end
function OpenCoffin()
  if not scornPoison_CoffinOpened then
    scornPoison_CoffinOpened = true
    timer.StartLevelTimer(1, function()
      game.Audio.PlayBanter("030_ScornPole_CoffinOpen")
    end)
  end
end
function CoffinOpened()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  return 263 <= cineNum and cineNum < 400 and scornPoison_CoffinOpened
end
