local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local thisLevel, player
son = nil
local foot250, ChiselElevator, ElevatorManager, pad
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  pad = player.Pad
  SoundInit()
  ChiselElevator = level:GetGameObject("ChiselDungeon_Elevator")
  ElevatorManager = ChiselElevator:FindSingleGOByName("ElevatorManager")
end
function OnStart(level)
  SoundOnStart()
end
function JumpElevator()
  ElevatorManager.LuaObjectScript.JumpToBottomFloor()
end
function JumpElevatorToTop()
  ElevatorManager.LuaObjectScript.JumpToTopFloor()
end
function ClearSlowWalk()
  player:ClearMaxSpeedOverride()
  if pad.ClearAllDisabledGameButtons then
    pad:ClearAllDisabledGameButtons()
  end
end
function Foot250LoadCheck()
  game.UI.LoadCheck("Foot250_ChiselArena")
end
function LoadCheck_Foot200()
  game.UI.LoadCheck("Foot200_Mid")
end
function Foot250_LTW_Enable()
  local foot250 = game.FindLevel("Foot250_ChiselArena")
  if foot250 ~= nil then
    foot250:CallScript("LTW_Lobby_Enable", "CA_Lobby_Enable")
  end
end
function Foot250_LTW_Disable()
  local foot250 = game.FindLevel("Foot250_ChiselArena")
  if foot250 ~= nil then
    foot250:CallScript("LTW_Lobby_Disable", "CA_Lobby_Disable")
  end
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("Foothills Chisel Dungeon")
  ChiselLabor()
end
function ChiselLabor()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Open_Foot")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Open_Foot")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Open", 1)
  end
end
function switchedLever02()
  if GameObjects.anim_elevator_02.AnimFrame == 0 then
    GameObjects.anim_elevator_02:PlayAnimToEnd()
  elseif GameObjects.anim_elevator_02.AnimFrame == GameObjects.anim_elevator_02.AnimLengthFrames then
    GameObjects.anim_elevator_02:PlayAnimToEnd(-1)
  end
end
function EnableChiselMarker()
  LD.SetMarkerState("FOOT_240_ChiselEntrance", 1)
  LD.UpdateMap("FOOT_240_ChiselEntrance", 0)
  ChiselQuest()
end
function DisableChiselMarker()
  LD.SetMarkerState("FOOT_240_ChiselEntrance", 0)
end
function ChiselQuest()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Find_Foot")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Find_Foot")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Find", 1)
  end
end
local elevatorManagerObject
local elevatorSoundOverride = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 1
}
local ChiselDoorSoundEvents = {
  isLooping = false,
  OnInteractForward_Left = "SND_DOOR_Forest_Double_Door_Open_L",
  OnInteractForward_Right = "SND_DOOR_Forest_Double_Door_Open_R",
  OnInteractBackward_Left = "SND_DOOR_Forest_Double_Door_Open_L",
  OnInteractBackward_Right = "SND_DOOR_Forest_Double_Door_Open_R",
  OnInteractClose_Left = "SND_DOOR_Forest_Double_Door_Close_L",
  OnInteractClose_Right = "SND_DOOR_Forest_Double_Door_Close_R",
  OnInteractCloseFrameDelay = 100
}
function SoundInit()
  elevatorManagerObject = thisLevel:GetGameObject("ElevatorManager")
  elevatorSoundOverride.SoundEmitter = elevatorManagerObject.Parent:FindSingleSoundEmitterByName("SNDChiselElevator")
end
function SoundOnStart()
  elevatorManagerObject.LuaObjectScript.SoundSetup(elevatorSoundOverride)
  GameObjects.ChiselDoor_Regular:FindSingleGOByName("SpreadDoor").LuaObjectScript.SoundSetup(ChiselDoorSoundEvents)
end
