local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local thisLevel, player, son, Enc_Valkyrie_Fight
local b_DraugrChallenge = false
local msg_DraugrChallenge = ""
local Enc_DraugrChallenge_Fight
local KillCount = 100
local DraugrChallenge_KillCount = KillCount
local Valkyrie_Monitor, OneHitCallMonitor
function OnScriptLoaded(level, obj)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  Arena_Valkyrie_Fight()
end
function OnFirstStart(level, obj)
end
function OnUpdate(level, obj)
  if b_DraugrChallenge then
    uiCalls.UI_Event_SendDesignerMessage("Enemies Remaining: \n" .. DraugrChallenge_KillCount, 0.03)
  end
end
function Arena_Challenge01_Fight()
  Enc_DraugrChallenge_Fight = EC.NewEncounter(thisLevel, "[Chisel Arena]EC: Draugr Challenge", {
    CheckpointOnComplete = true,
    spawnWad = "Foot250_ChiselArena"
  })
  Enc_DraugrChallenge_Fight:AddWave({
    requireOnScreenSpawners = true,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 5,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 0.2
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldown = 0.5,
      maxActive = 9,
      totalSpawns = 9,
      spawnCooldown = 3
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    requireOnScreenSpawners = true,
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 2.5,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.2
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    prioritizeOnScreenSpawners = true,
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 3
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "S_Draugr_N_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldown = {0.5, 1},
      maxActive = 5,
      totalSpawns = 5,
      spawnCooldown = 1.5
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    requireOnScreenSpawners = true,
    requiredWaveCompletion = 51,
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.2
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 3,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.2
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    prioritizeOnScreenSpawners = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "SH_Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = {0, 0.5},
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 3
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "Draugr_L_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 2,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 5
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.2
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    requiredWaveCompletion = 50,
    {
      spawners = "S_Draugr_N_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldown = {1, 2},
      maxActive = 5,
      totalSpawns = 5,
      spawnCooldown = 3
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldown = {1, 2},
      maxActive = 5,
      totalSpawns = 5,
      spawnCooldown = 3
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    prioritizeOnScreenSpawners = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = {1, 2},
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 3
    },
    {
      spawners = "SH_Draugr_N_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 1.5
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    requireOnScreenSpawners = true,
    {
      spawners = "DW_Draugr_L_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 0.8
    },
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.2
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = {1, 2},
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 3
    },
    {
      spawners = "Draugr_B_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "H_Draugr_B_SFG",
      spawnLocators = "Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 2,
      spawnCooldown = 3
    },
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldown = {1, 2},
      maxActive = 7,
      totalSpawns = 7,
      spawnCooldown = 3
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "SH_Draugr_E_SFG",
      spawnLocators = "Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.83
    },
    {
      spawners = "SH_Draugr_L_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = {3, 5},
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 3
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    requireOnScreenSpawners = true,
    {
      spawners = "Draugr_E_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 0.8
    },
    {
      spawners = "Draugr_P_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 0.2
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldown = 0.5,
      maxActive = 9,
      totalSpawns = 9,
      spawnCooldown = 3
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "H_Draugr_P_SFG",
      spawnLocators = "Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 3
    },
    {
      spawners = "SH_Draugr_N_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = {1, 2},
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 3
    },
    {
      spawners = "S_Draugr_N_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 3,
      initialSpawnCooldown = {1, 2},
      maxActive = 5,
      totalSpawns = 5,
      spawnCooldown = 5
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "U_Draugr_PL_SFG",
      spawnLocators = "Loc_I*",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 3
    },
    {
      spawners = "DW_Draugr_B_SFG",
      spawnLocators = "Loc_O*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = {1, 2},
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 3
    }
  })
  Enc_DraugrChallenge_Fight:SetStartZone(GameObjects.EntZn_Start_ValkyrieFight)
  Enc_DraugrChallenge_Fight:OnStart(function()
    GameObjects.ChainPull_02.LuaObjectScript.Disable()
    uiCalls.UI_Event_SendTutorialMessage([[
Kill a 100 Enemies 
Better to fight and fall than to live without hope ]], 8)
    b_DraugrChallenge = true
  end)
  Enc_DraugrChallenge_Fight:OnEnemyDeath(function()
    DraugrChallenge_KillCount = DraugrChallenge_KillCount - 1
  end)
  Enc_DraugrChallenge_Fight:OnComplete(function()
    b_DraugrChallenge = false
    uiCalls.UI_Event_SendTutorialMessage("Congratz", -1)
    GameObjects.ChainPull_02.LuaObjectScript.Unlock()
    GameObjects.ChainPull_02.LuaObjectScript.Enable()
  end)
end
function Arena_Challenge02_Fight()
  Enc_DraugrChallenge_Fight = EC.NewEncounter(thisLevel, "[Chisel Arena]EC: Zero Damage Draugr Challenge", {
    CheckpointOnComplete = true,
    spawnWad = "Foot250_ChiselArena"
  })
  Enc_DraugrChallenge_Fight:AddWave({
    requireOnScreenSpawners = true,
    {
      spawners = "Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      initialSpawnCooldown = 5,
      maxActive = 3,
      totalSpawns = 3,
      spawnCooldown = 5
    },
    {
      spawners = "H_Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 1,
      initialSpawnCooldown = 1.5,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.2
    }
  })
  Enc_DraugrChallenge_Fight:AddWave({
    {
      spawners = "S_Draugr_N_SFG",
      spawnLocators = "Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 4,
      initialSpawnCooldown = 3,
      maxActive = 9,
      totalSpawns = 9,
      spawnCooldown = 2
    }
  })
  Enc_DraugrChallenge_Fight:SetStartZone(GameObjects.EntZn_Start_ValkyrieFight)
  Enc_DraugrChallenge_Fight:OnEnemyDeath(function()
    DraugrChallenge_KillCount = DraugrChallenge_KillCount - 1
  end)
  Enc_DraugrChallenge_Fight:OnStart(function()
    DraugrChallenge_KillCount = KillCount
    One_Hit_Challenge()
    b_DraugrChallenge = true
    uiCalls.UI_Event_SendTutorialMessage("Defeat all enemies without taking damage ", 3)
  end)
  Enc_DraugrChallenge_Fight:OnComplete(function()
    uiCalls.UI_Event_SendTutorialMessage("Congratulations all enemies defeated", -1)
    b_DraugrChallenge = false
  end)
end
function Arena_Valkyrie_Fight()
  Enc_Valkyrie_Fight = EC.NewEncounter(thisLevel, "[Chisel Arena]EC: Valkyrie00", {
    CheckpointOnComplete = false,
    spawnWad = "Foot250_ChiselArena",
    LeashZone = "LshZn_Foot250_Valk"
  })
  Enc_Valkyrie_Fight:AddWave({
    {
      spawners = "Valkyrie_Shooter_SSD",
      markerID = "Valkyrie_Foot250",
      initialSpawnAmount = 1,
      initialSpawnCooldown = 0,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Enc_Valkyrie_Fight:OnComplete(function()
    _G.SetEncounterComplete()
    _G.CA_Arena_Enable()
    _G.LTW_Lobby_Enable()
    GameObjects.CA_Observe_On_Alert_Arena.LuaObjectScript.Disable()
  end)
  Enc_Valkyrie_Fight:SetStartZone(GameObjects.EntZn_Start_ValkyrieFight)
  Enc_Valkyrie_Fight:SetAlertZone(GameObjects.EntZn_Alert_ValkyrieFight)
end
function EventFailed_OneHit()
  uiCalls.UI_Event_SendDesignerMessage("You have failed to kill the enemies without getting hit", -1)
  Enc_DraugrChallenge_Fight:DespawnEnemies()
  Enc_DraugrChallenge_Fight:Reset()
  Enc_DraugrChallenge_Fight:Stop()
  b_DraugrChallenge = false
  player:Warp(GameObjects.PlayerLocator1:GetWorldPosition(), GameObjects.PlayerLocator1:GetWorldForward())
  son:Warp(GameObjects.PlayerLocator1:GetWorldPosition() + engine.Vector.New(0, 0, -0.3), player:GetWorldForward())
  Enc_DraugrChallenge_Fight:SetStartZone(GameObjects.EntZn_Start_ValkyrieFight)
  uiCalls.UI_Event_SendDesignerMessage("You have failed to kill the enemies without getting hit", -1)
end
function One_Hit_Challenge()
  OneHitCallMonitor = monitors.CreateHealthMonitor(player)
  OneHitCallMonitor:OnHealthLessThan(player:MeterGetValue("Health"), function()
    OneHitCallMonitor:Stop()
    OneHitCallMonitor = nil
    EventFailed_OneHit()
  end)
end
