local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local thisLevel, player, son
local firstVisit = true
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") >= 440 then
    GameObjects.BrokenTotems:Show()
    GameObjects.PoisonTotem_01.LuaObjectScript.Disable()
    GameObjects.PoisonTotem_01:Hide()
    GameObjects.CA_TotemSaveSpot_01.LuaObjectScript.Disable()
    GameObjects.CA_TotemSaveSpot_02.LuaObjectScript.Disable()
  else
    GameObjects.BrokenTotems:Hide()
    GameObjects.CA_TotemSaveSpot_01.LuaObjectScript.Enable()
    GameObjects.CA_TotemSaveSpot_02.LuaObjectScript.Enable()
  end
end
function OnUpdate(level)
end
function OnUseWorld(level)
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
end
function UpdateLoadGroup()
  game.EvaluateLoadZones()
end
function OnEvaluateLoadGroup_LoadGroup_AI_to200()
  if game.Level.GetVariable("CompletedCineNumber") < 440 then
    return "AI_Visit_01"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 440 then
    return "AI_Visit_02"
  end
end
function OnEvaluateLoadGroup_LoadGroup_AI_to400()
  if game.Level.GetVariable("CompletedCineNumber") < 440 then
    return "AI_Visit_01"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 440 then
    return "AI_Visit_02"
  end
end
function Foot200_LoadCheck()
  game.UI.LoadCheck("Foot200_Mid")
end
function Foot400_LoadCheck()
  game.UI.LoadCheck("Foot400_Arena")
end
function Foot400ArenaSyncExit()
  if firstVisit then
    firstVisit = false
  else
    GameObjects.CA_Climb_01_Exit.LuaObjectScript.Enable()
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    firstVisit = firstVisit
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  firstVisit = savedInfo.firstVisit
end
