local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, thisLevel, player
local banterPlayed = {}
local seq
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
  end
end
function SonJabs_Banter()
  if seq == nil and game.Level.GetVariable("CompletedCineNumber") < 187 then
    seq = LD.CreateCineSequence(thisLevel, thisObj, "SonJabs")
    seq:WaitForFunctionTrue(function()
      return player:IsPlayingMove("MOV_Crack_Climb_Up_Enter")
    end)
    seq:WaitSeconds(0.8)
    seq:Do(function()
      game.Audio.PlayBanter("035_SonJabs", function()
        GameObjects.Btr_SonJabs:Hide()
      end)
    end)
    seq:StartSequence()
  end
end
function RespectYourMother_Banter()
  if not banterPlayed.RespectYourMother then
    timers.StartLevelTimer(4, function()
      game.Audio.PlayBanter("030_RespectYourMother")
    end)
    banterPlayed.RespectYourMother = true
  end
end
