local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local monitors = require("level.MonitorLibrary")
local thisLevel, player, son, Area_1_Encounter_1, Area_1_Encounter_2, Area_1_Encounter_2_Cine, BanditTrip_ZoneMonitor, foot400Door
local musicPlayedJotDoor = false
local ogreMusic = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  Area_1_Fight_1()
  if game.Level.GetVariable("CompletedCineNumber") < 250 then
    Area_1_Fight_2_Cine()
    Area_1_Fight_2()
  end
  foot400Door = GameObjects.HingeDoor_Foot400
  if foot400Door.IsRefNode then
    foot400Door = foot400Door.Child
  end
end
function OnUpdate(level)
  if Area_1_Encounter_2 and Area_1_Encounter_2:IsRunning() and player:IsPlayingMove("MOV_CSRageGrabJotunnEnter") then
    Area_1_Encounter_2:StartWave(3)
  end
end
function OnFirstStart(level)
  local BlockedChest = thisLevel:GetGameObject("coffin_tier1_foot400_1")
  BlockedChest.LuaObjectScript.Disable()
  GameObjects.RiftCollisionSpheres:HideCollision()
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") > 190 then
    UnlockDoor()
  end
  if game.Level.GetVariable("CompletedCineNumber") < 250 and Area_1_Encounter_2:WasRunning() then
    Area_1_Encounter_2:OnStart(function()
      Area_1_Encounter_2:StartWave(2)
      Area_1_Encounter_2:AlertEnemies()
    end)
    Area_1_Encounter_2:Start()
  end
  GameObjects.RiftCollisionSpheres:HideCollision()
  SoundOnStart()
end
function Foot300_LoadCheck()
  game.UI.LoadCheck("Foot300_Hallway")
end
function Foot500_LoadCheck()
  game.UI.LoadCheck("Foot500_Top")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function UpdateLoadGroup()
  game.EvaluateLoadZones()
end
function OnEvaluateLoadGroup_LoadGroup_AI_400()
  if game.Level.GetVariable("CompletedCineNumber") < 250 then
    return "AI_Visit_01"
  elseif game.Level.GetVariable("CompletedCineNumber") >= 440 then
    return "AI_Visit_02"
  end
end
function EnterBehaviorContext_WAIT_AND_EXPLORE()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
end
function ClearBehaviorContext()
  son:CallScript("ClearBehaviorContext")
end
function ShowSurvey()
end
function UnlockDoor()
  foot400Door.LuaObjectScript.Enable()
  foot400Door.LuaObjectScript.Unlock()
end
function EnableCoffin()
  local TotemScratch = thisLevel:GetGameObject("PoisonTotem_02")
  print(tostring(TotemScratch))
  local Totem = TotemScratch:FindSingleGOByName("ScornPole_root")
  print(tostring(Totem))
  if Totem ~= nil then
    print(tostring(Totem.Broken))
    if Totem.Broken == true then
      GameObjects.chest_legendary_tier1_foot400_1.LuaObjectScript.Enable()
    end
  else
    GameObjects.chest_legendary_tier1_foot400_1.LuaObjectScript.Enable()
  end
end
function DisableCoffin()
  GameObjects.chest_legendary_tier1_foot400_1.LuaObjectScript.Disable()
end
function HideBomb_01()
  timers.StartLevelTimer(1.5, HideBomb_01_Delay)
end
function HideBomb_01_Delay()
  local BombScratch = thisLevel:GetGameObject("PoisonTotem_02_Bomb")
  local Bomb = BombScratch:FindSingleGOByName("HangingBomb_Lit_Fuse")
  Bomb:Hide()
end
function ShowBomb_01()
  timers.StartLevelTimer(0.3, ShowBomb_01_Delay)
end
function ShowBomb_01_Delay()
  local BombScratch = thisLevel:GetGameObject("PoisonTotem_02_Bomb")
  local Bomb = BombScratch:FindSingleGOByName("HangingBomb_Lit_Fuse")
  Bomb:Show()
end
function HideBomb_02()
  timers.StartLevelTimer(1.5, HideBomb_02_Delay)
end
function HideBomb_02_Delay()
  local BombScratch = thisLevel:GetGameObject("BombBlocker_02_Bomb")
  local Bomb = BombScratch:FindSingleGOByName("HangingBomb_Lit_Fuse")
  Bomb:Hide()
end
function ShowBomb_02()
  timers.StartLevelTimer(0.3, ShowBomb_02_Delay)
end
function ShowBomb_02_Delay()
  local BombScratch = thisLevel:GetGameObject("BombBlocker_02_Bomb")
  local Bomb = BombScratch:FindSingleGOByName("HangingBomb_Lit_Fuse")
  Bomb:Show()
end
function Trigger_BreakTotem_01()
  timers.StartLevelTimer(0.2, Destroy_BreakTotem_01)
end
function Destroy_BreakTotem_01()
  GameObjects.PoisonTotem_02.LuaObjectScript.Disable()
end
function Trigger_BombBlocker_01()
  timers.StartLevelTimer(0.1, Destroy_BombBlocker_01)
end
function Destroy_BombBlocker_01()
  local BlockedChest = thisLevel:GetGameObject("coffin_tier1_foot400_1")
  BlockedChest.LuaObjectScript.Enable()
end
function Trigger_BombBlocker_02()
end
function Disable_Table_NoGoZone()
  GameObjects.BreakableTable_NoGoZone:HideNavObstacle()
end
function CSDraugr_CS_Spawn()
  Area_1_Encounter_2_Cine:Start()
end
function CSDraugr_CleanupDummies()
  for _, go in ipairs(thisLevel:FindGameObjectsByMarker("CSDraugr_AI", game.Player.FindPlayer().WorldPosition, 1000)) do
    go:Destroy()
    print(go)
  end
  timers.StartLevelTimer(1, CSDraugr_Spawn)
end
function CSDraugr_Spawn()
end
function AwakeEnemies()
  timers.StartLevelTimer(function()
    LD.FindSingleAIByMarker("InitialSpawn01"):TriggerMoveEvent("kLEAlert")
  end, 1)
  timers.StartLevelTimer(function()
    LD.FindSingleAIByMarker("InitialSpawn02"):TriggerMoveEvent("kLEAlert")
  end, 1.5)
  timers.StartLevelTimer(function()
    LD.FindSingleAIByMarker("InitialSpawn03"):TriggerMoveEvent("kLEAlert")
  end, 1.8)
end
function Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC: Pre Battle with Wolves Foot400", {
    CheckpointOnComplete = true,
    LeashZone = "LeashFoot400",
    spawnWad = "Foot400_Arena_AI_Visit01"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Wolves_Pois_Eat01",
      spawnLocators = "A1_O_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolves_Pois_Eat02",
      spawnLocators = "A1_O_Loc_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.7
    },
    {
      spawners = "Helwalkers_L1_UNAWARE",
      spawnLocators = "A1_O_Loc_04",
      useSpawnLocatorsOnly = true,
      markerID = "KillTarget",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_Area_1_Spawn_1, {
    cineRequirement = {0, 250}
  })
  Area_1_Encounter_1:SetAlertZone(GameObjects.EntZn_Area_1_Alert)
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wolf_Rabid")
  end)
end
function Area_1_Fight_2_Cine()
  Area_1_Encounter_2_Cine = EC.NewEncounter(thisLevel, "[Area 1]EC: Intro Jot Foot400 CINE ONLY", {
    CheckpointOnComplete = false,
    spawnWad = "Foot400_Arena_AI_Visit01"
  })
  Area_1_Encounter_2_Cine:AddWave({
    {
      spawners = "Helwalkers_Cine_01",
      spawnLocators = "A1_CS_Loc_01",
      markerID = "InitialSpawn01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 42.7
    },
    {
      spawners = "Helwalkers_Cine_02",
      spawnLocators = "A1_CS_Loc_04",
      markerID = "InitialSpawn02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 48.8
    },
    {
      spawners = "Helwalkers_Cine_03",
      spawnLocators = "A1_CS_Loc_02",
      markerID = "InitialSpawn03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 44
    },
    {
      spawners = "Helwalkers_Cine_04",
      spawnLocators = "A1_CS_Loc_03",
      markerID = "InitialSpawn04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 43
    },
    {
      spawners = "Helwalkers_Cine_05",
      spawnLocators = "A1_CS_Loc_05",
      markerID = "InitialSpawn05",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 38
    }
  })
  Area_1_Encounter_2_Cine:OnStart(function()
    timers.StartLevelTimer(55, function()
      Area_1_Encounter_2_Cine:DespawnEnemies()
    end)
    timers.StartLevelTimer(56, function()
      Area_1_Encounter_2_Cine:SetComplete()
    end)
  end)
end
function Area_1_Fight_2()
  Area_1_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC: Intro Jot Foot400", {
    CheckpointOnComplete = true,
    spawnWad = "Foot400_Arena_AI_Visit01"
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Jotunn_N_Cine",
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_2:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Helwalkers_L1_SRFC",
      spawnLocators = "A1_O_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalkers_L1_SRFC",
      spawnLocators = "A1_O_Loc_06",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalkers_L2_SRFC",
      spawnLocators = "A1_O_Loc_07",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalkers_L1_SRFC",
      spawnLocators = "A1_O_Loc_08",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    },
    {
      spawners = "Helwalkers_L1_SRFC",
      spawnLocators = "A1_O_Loc_09",
      useSpawnLocatorsOnly = true,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_2:AddWave({
    {
      spawners = "Helwalkers_L2_CLIMB01",
      spawnCooldown = 0
    },
    {
      spawners = "Helwalkers_L2_CLIMB02",
      spawnCooldown = 2
    },
    {
      spawners = "Helwalkers_L2_CLIMB01",
      spawnCooldown = 4.5
    }
  })
  Area_1_Encounter_2:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  Area_1_Encounter_2:OnComplete(OgreIntroComplete)
  Area_1_Encounter_2:OnEnemySpawn(OgreSpawned, {wave = 1})
end
function OgreIntroComplete()
  timers.StartLevelTimer(2, function()
    game.Audio.PlayBanter("037_PostOgreFight")
  end)
  game.Compass.SetDesignerForcedHide(false)
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Seidr_Bandit")
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Ogre_Basher")
  foot400OgreMusic()
end
function GetOgre()
  return Area_1_Encounter_2:GetActiveEnemies(1)[1]
end
function OgreSpawned(ogre)
  if game.Level.GetVariable("CompletedCineNumber") <= 185 then
    local warpJoint = GameObjects.JotunnCinematic_WarpLoc:GetJointIndex("warpLoc")
    ogre:Warp(GameObjects.JotunnCinematic_WarpLoc:GetWorldJointPosition(warpJoint), GameObjects.JotunnCinematic_WarpLoc:GetWorldJointForward(warpJoint))
  end
end
function GetOgreEncounter()
  return Area_1_Encounter_2
end
function StartOgreEncounter_w2()
  Area_1_Encounter_2:StartWave(2)
end
local OverrideSoundEvents = {
  isLooping = false,
  OnInteractForward_Center = "",
  OnInteractForward_Left = "SND_DOOR_Stone_Double_Door_Push_Open_L",
  OnInteractForward_Right = "SND_DOOR_Stone_Double_Door_Push_Open_R",
  OnInteractBackward_Center = "",
  OnInteractBackward_Left = "SND_DOOR_Stone_Double_Door_Push_Open_L",
  OnInteractBackward_Right = "SND_DOOR_Stone_Double_Door_Push_Open_R",
  OnInteractClose_Center = "",
  OnInteractClose_Left = "SND_DOOR_Stone_Double_Door_Push_Close_L",
  OnInteractClose_Right = "SND_DOOR_Stone_Double_Door_Push_Close_R"
}
function SoundOnStart()
  GameObjects.HingeDoor_Foot400.LuaObjectScript.SoundSetup(OverrideSoundEvents)
end
function JotDoorMusic()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if musicPlayedJotDoor == false and 187 <= cineNum and cineNum < 190 then
    game.Audio.StartMusic("SND_MX_FOOT_jotunn_reveal")
    musicPlayedJotDoor = true
  end
end
function foot400CSOgreMusic()
  if Area_1_Encounter_2:GetNumEnemiesAlive() == 1 then
    game.Audio.StartMusic("SND_MX_FOOT_ogre_battle_cs_kill")
    game.Audio.SetCheckpointedMusic("SND_MX_FOOT4_explore1_in")
    ogreMusic = true
  else
    game.Audio.StartMusic("SND_MX_FOOT_ogre_battle_cs_kill")
    game.Audio.SetCheckpointedMusic("SND_MX_FOOT4_explore1_in")
  end
end
function foot400OgreMusic()
  if ogreMusic == false then
    game.Audio.StartMusic("SND_MX_FOOT_ogre_battle_out")
  end
end
