local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, enc_1_fight_3
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  FNC_1_Fight_3()
end
function FNC_1_Fight_3()
  enc_1_fight_3 = EC.NewEncounter(thisLevel, "[EC1c] Foot400 - Rift Seidr Projections ", {
    CheckpointOnComplete = true,
    LeashZone = "LeashFoot400",
    StartMusic = "SND_MX_FOOT4_rift_fight_in",
    StopMusic = "SND_MX_FOOT4_rift_fight_out"
  })
  enc_1_fight_3:AddWave({
    {
      spawners = "Projection00_S_PL4_SPA",
      spawnLocators = "Loc_Ground_B_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot400_Arena_AI_Visit02",
      maxActive = 2,
      totalSpawns = 5,
      spawnCooldown = {1, 2}
    },
    {
      spawners = "Projection00_S_PL3_SPA",
      spawnLocators = "Loc_Ground_B_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot400_Arena_AI_Visit02",
      maxActive = 3,
      totalSpawns = 5,
      spawnCooldown = {1, 3}
    }
  })
  enc_1_fight_3:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Projection00_S_PL4_SPA",
      spawnLocators = "Loc_Ground_A_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot400_Arena_AI_Visit02",
      maxActive = 2,
      totalSpawns = 3,
      spawnCooldown = {1, 2}
    },
    {
      spawners = "Projection00_S_PL3_SPA",
      spawnLocators = "Loc_Ground_A_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot400_Arena_AI_Visit02",
      maxActive = 2,
      totalSpawns = 4,
      spawnCooldown = {1, 3}
    }
  })
  enc_1_fight_3:AddWave({
    triggerWaveFromScript = true,
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Projection00_S_PL4_SPA",
      spawnLocators = "Loc_Ground_C_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot400_Arena_AI_Visit02",
      maxActive = 3,
      totalSpawns = 8,
      spawnCooldown = {1, 3}
    },
    {
      spawners = "Projection00_S_PL3_SPA",
      spawnLocators = "Loc_Ground_C_0*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Foot400_Arena_AI_Visit02",
      maxActive = 2,
      totalSpawns = 6,
      spawnCooldown = {1, 3}
    }
  })
  enc_1_fight_3:SetStartZone(GameObjects.EntZn_Area1_V02_Spawn, {cineRequirement = 450})
  enc_1_fight_3:OnComplete(function()
    GameObjects.Foot400_Banter.LuaObjectScript.EnoughAboutOdin_Banter()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Projection_Brood")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Projection_Brood")
    GameObjects.RiftCollisionSpheres:HideCollision()
  end)
  enc_1_fight_3:OnEnemyDeath(function()
    enc_1_fight_3:StartWave(2)
  end, {count = 8})
  enc_1_fight_3:OnEnemyDeath(function()
    enc_1_fight_3:StartWave(3)
  end, {count = 7})
  enc_1_fight_3:OnStart(function()
    GameObjects.PktRft_Foot400_Projection_02.LuaObjectScript.StartCombatState()
    GameObjects.RiftCollisionSpheres:ShowCollision()
  end, 1)
  enc_1_fight_3:OnStart(function()
    GameObjects.PktRft_Foot400_Projection_01.LuaObjectScript.StartCombatState()
  end, 2)
  enc_1_fight_3:OnStart(function()
    GameObjects.PktRft_Foot400_Projection_03.LuaObjectScript.StartCombatState()
  end, 3)
  enc_1_fight_3:OnComplete(function()
    GameObjects.PktRft_Foot400_Projection_02.LuaObjectScript.SpawningDone()
  end, 1)
  enc_1_fight_3:OnComplete(function()
    GameObjects.PktRft_Foot400_Projection_01.LuaObjectScript.SpawningDone()
  end, 2)
  enc_1_fight_3:OnComplete(function()
    GameObjects.PktRft_Foot400_Projection_03.LuaObjectScript.SpawningDone()
  end, 3)
  enc_1_fight_3:OnEnemySpawn(function()
    GameObjects.PktRft_Foot400_Projection_02.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 1})
  enc_1_fight_3:OnEnemySpawn(function()
    GameObjects.PktRft_Foot400_Projection_01.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 2})
  enc_1_fight_3:OnEnemySpawn(function()
    GameObjects.PktRft_Foot400_Projection_03.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end, {wave = 3})
end
