local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local thisObj, thisLevel, sonActor, kratosActor
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
  end
end
function Indeed_Seq()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 187 <= cineNum and cineNum < 190 and not banterPlayed.Indeed then
    local redDoor = GameObjects.HingeDoor_Foot400.Child
    local seq = LD.CreateCineSequence(thisLevel, redDoor, "indeed_RedDoorReveal")
    local actorTable = {
      {Actor = sonActor},
      {
        Obj = redDoor,
        Anim = "DoorDoublePushCloseLook"
      }
    }
    redDoor.LuaObjectScript.EnableCinematicTrigger()
    seq:RequestCineModeAndWait(kratosActor, thisObj)
    seq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_Indeed",
      ReferenceJoint = "synchJointBack",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.StopTurnRadius,
      weapon_state = "bare"
    })
    seq:ActorSync(kratosActor, {
      Slaves = actorTable,
      Branch = "BRA_Indeed",
      ReferenceJoint = "synchJointBack"
    })
    seq:Do(function()
      LD.CallFunctionAfterDelay(function()
        redDoor.LuaObjectScript.PlaySoundOnInteract_Forward()
      end, 1.035)
    end)
    seq:WaitSeconds(4)
    seq:Do(function()
      uiCalls.UI_Event_DiscoverLocation("Base of the Mountain")
    end)
    seq:WaitSeconds(5)
    seq:Do(function()
      game.Audio.PlayBanter("040_Indeed")
    end)
    seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    seq:Do(function()
      banterPlayed.Indeed = true
    end)
    seq:StopPuppetingActor(sonActor)
    seq:StopPuppetingActor(kratosActor)
    seq:StartSequence()
  end
end
