local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, ogreActor, pillarProp, cineEnterJotunnEncounter
local ogreSpawned = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  pillarProp = GameObjects.debrisPillarProp.Child
  if game.Level.GetVariable("CompletedCineNumber") < 187 then
    SetupActors()
    pillarProp.LuaObjectScript.DisableBack()
    _G.GetOgreEncounter():OnEnemySpawn(function()
      ogreSpawned = true
    end, {wave = 1, element = 1})
  else
    GameObjects.NoGo_OgreIntro:Hide()
    pillarProp:Hide()
    pillarProp.LuaObjectScript:Disable()
  end
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnUpdate(level, obj)
  if cineEnterJotunnEncounter ~= nil then
    cineEnterJotunnEncounter:Update()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("OGRE INTRO: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("OGRE INTRO: Son Actor", game.AI.FindSon)
  ogreActor = actor.Actor.New("OGRE INTRO: Ogre Actor")
  ogreActor:SetSpawnFunction(function()
    return _G.GetOgre()
  end)
  SetupPillarPropIdle()
end
function SetupPillarPropIdle()
  local setupSeq = LD.CreateCineSequence(thisLevel, thisObj, "OgreIntro PillarPropIdle")
  setupSeq:WaitForFunctionTrue(function()
    return game.FindLevel("Foot400_Arena_AI_Visit01") ~= nil
  end)
  setupSeq:Do(function()
    pillarProp:PlayAnimationToEnd({
      Animation = "narFootJotunnEncounterCineIdle"
    })
  end)
  setupSeq:StartSequence()
end
function OgreIntroSequence()
  local doorObj = GameObjects.HingeDoor_Foot400
  if doorObj.IsRefNode then
    doorObj = doorObj.Child
  end
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "OgreIntro")
  local slaveTab = {
    {Actor = sonActor},
    {Actor = ogreActor},
    {
      Obj = pillarProp,
      Anim = "narFootJotunnEncounterCineScene"
    },
    {
      Obj = doorObj,
      Anim = "narFootJotunnEncounterCineScene"
    }
  }
  pillarProp.LuaObjectScript.EnableCinematicTrigger()
  cineSeq:SetPostSkipMusic("SND_MX_FOOT_start_master", nil, nil, nil, nil, "SND_MX_FOOT_ogre_battle_in")
  cineSeq:MarkAbleToSkip()
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:Do(CameraStartJotunnCineEnter)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_JotunnEncounter",
    ReferenceJoint = "JotunnEncounter_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.StopTurnRadius,
    weapon_state = "bare_on_back"
  })
  cineSeq:Do(function()
    _G.GetOgreEncounter():Start()
  end)
  cineSeq:WaitForFunctionTrue(function()
    return ogreSpawned
  end)
  cineSeq:SpawnActorAndWait(ogreActor)
  cineSeq:Do(function()
    GameObjects.NoGo_OgreIntro:Hide()
  end)
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_JotunnEncounter",
    ReferenceJoint = "JotunnEncounter_SynchJoint"
  })
  cineSeq:Do(function()
    _G.CSDraugr_CS_Spawn()
  end)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:StopPuppetingActor(ogreActor)
  cineSeq:Do(function()
    pillarProp:Hide()
  end)
  cineSeq:Do(function()
    pillarProp.LuaObjectScript:Disable()
    doorObj.LuaObjectScript.Enable()
  end)
  cineSeq:Do(function()
    _G.StartOgreEncounter_w2()
  end)
  cineSeq:SetCompletedCineNumber(187)
  cineSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  cineSeq:StartSequence()
end
function WarpObj(warpObj, refObj, refJoint)
  local jointPos = refObj:GetWorldJointPosition(refObj:GetJointIndex(refJoint))
  local jointFace = refObj:GetWorldJointForward(refObj:GetJointIndex(refJoint))
  warpObj:SetWorldPosition(jointPos)
  warpObj:SetWorldFacing(jointFace)
end
function CameraStartJotunnCineEnter()
  game.SubObject.Wake(thisObj)
  cineEnterJotunnEncounter = CCEC.CineEnterCamera.New("ENV_CineEnter_narFootJotunnEncounterCineScene", 5, nil)
  cineEnterJotunnEncounter:SetCallback(CameraDestroyJotunnCineEnter)
  cineEnterJotunnEncounter:Start()
end
function CameraDestroyJotunnCineEnter()
  game.SubObject.Sleep(thisObj)
  cineEnterJotunnEncounter = nil
end
