local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local LM = require("level.loadmonitor")
local player, thisLevel, son
local camInSide070 = false
local FreyaLock_EventEnabled = false
local FreyaLock_MessageActive = false
local elevatorManager, topFloor_CollisionCap, UpperLedgeCollision, bottomFloorCollisionBlocker, LowerCartExit_TraversalLink, LowerGondolaBase_TraversalLink, RockFall_Trigger, RockFall_Breakable, RockFall_GapJumpLink, RockFall_RockClimb, blackBreathCine_Monitor
local blackBreathCleared = false
local GondolaStage = 0
local DoorUnlocked = false
local soundEmitterGondolaLeft, soundEmitterGondolaRight, playerCurve, playerCurveName
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  thisLevel = level
  son = game.AI.FindSon()
  RockFall_Breakable = level:GetGameObject("RockFall_Breakable"):FindSingleGOByName("break_GRP")
  topFloor_CollisionCap = level:GetGameObject("Cart_TopFloor_CollisionCap")
  UpperLedgeCollision = level:GetGameObject("UpperLedge_LedgeBlocker")
  LowerCartExit_TraversalLink = level:GetGameObject("LowerCartExit_TraversalLink")
  LowerGondolaBase_TraversalLink = level:GetGameObject("LowerGondolaBase_TraversalLink")
  elevatorManager = GameObjects.Gondola_Elevator:FindSingleGOByName("Gondola_Manager")
  bottomFloorCollisionBlocker = GameObjects.BottomBaseCollision
  SoundInit()
  CompassGatewayToggle()
end
function OnFirstStart(level)
  GameObjects.IrritatingDwarf_SpeedCtrlZone:HideEntityVolume()
  GameObjects.GondolaPlatform_SpeedCtrlZone:HideEntityVolume()
  GameObjects.GondolaExit_FreyaLTW:HideEntityVolume()
  GameObjects.CheckpointZone_FromPeaks.LuaObjectScript.Disable()
  GameObjects.GapJump_Collision_01:HideCollision()
  GameObjects.GapJump_Collision_02:HideCollision()
  UpperLedgeCollision:Hide()
  GameObjects.LowerCartExit_TraversalLink:HideTraverseLink()
  GameObjects.TraverseLink_GapJump:HideTraverseLink()
  GameObjects.coffin_tier5_foot500_1.LuaObjectScript.Disable()
  GameObjects.chest_common_tier5_foot500_1.LuaObjectScript.Disable()
  GameObjects.CA_GondolaTrip_atBase_GetOnGondola:HideEntityVolume()
  GameObjects.StoneTroll_Broken:Hide()
  GameObjects.NavDecals_Jump:Hide()
  LD.HideFX(GameObjects.Bifrost_BlackBreath_Blast_FX)
end
function OnStart(level)
  local Zipline_TopPOS = thisLevel:GetGameObject("Zipline_Top")
  local Zipline_BottomPOS = thisLevel:GetGameObject("Zipline_Bottom")
  local Zipline_fromShipVis = thisLevel:GetGameObject("zipline_Foot500").Child
  Zipline_fromShipVis:SetZiplineStartAndEnd(Zipline_TopPOS:GetWorldPosition(), Zipline_BottomPOS:GetWorldPosition())
  local LoadZones_CS190 = thisLevel:GetGameObject("Load_CS190")
  local LoadZones_CS320 = thisLevel:GetGameObject("Load_CS320")
  local LoadZones_CS000 = thisLevel:GetGameObject("Load_CS000")
  if game.Level.GetVariable("CompletedCineNumber") >= 450 then
    game.Compass.SetGatewayMarkerIsOpen("FOOT_500_Helper9", false)
  end
  if game.Level.GetVariable("CompletedCineNumber") < 200 then
    LoadZones_CS190:ShowEntityVolume()
    LoadZones_CS320:HideEntityVolume()
    LoadZones_CS000:HideEntityVolume()
    GameObjects._Checkpoint_Zone_FromGondola:HideEntityVolume()
  else
    GameObjects._Checkpoint_Zone_FromGondola:ShowEntityVolume()
    GondolaBlocker_TurnOff()
    LoadZones_CS190:HideEntityVolume()
    LoadZones_CS320:HideEntityVolume()
    LoadZones_CS000:ShowEntityVolume()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 310 then
    GameObjects.CheckpointZone_FromPeaks.LuaObjectScript.Enable()
  end
  local interactZones = elevatorManager.LuaObjectScript.GetElevatorSwitch().LuaObjectScript.GetInteractZoneTable()
  interactZones[1]:SetXZRange(1.75)
  interactZones[1]:SetInteractFrontAngle(120)
  interactZones[1]:SetInteractFrontAngleWeight(0)
  interactZones[1]:SetCameraFrontAngle(0, 110)
  interactZones[1]:SetCameraFrontAngleWeight(0.5)
  interactZones[1]:SetOnScreenPercent(0.6, 0.3)
  elevatorManager.LuaObjectScript.AddWaitingCallback(WaitingAtElevatorCallback)
  elevatorManager.LuaObjectScript.AddOnWaitCompleteCallback(OnWaitCompleteElevatorCallback)
  LD.RegisterForCineUpdate(level, {
    {
      at = 182,
      immediateFn = FirstArrivalSetup,
      fn = FirstArrivalSetup
    },
    {
      at = 195,
      immediateFn = PostFreyaLeadWaySetup,
      fn = PostFreyaLeadWaySetup
    },
    {
      at = 439,
      immediateFn = StormArrivalSetup,
      fn = StormArrivalSetup
    },
    {
      at = 470,
      immediateFn = PostStormSetup,
      fn = PostStormSetup
    }
  })
  SetupSoundOverrides()
  GameObjects.Gondola_Elevator:FindSingleGOByName("CA_SonIdle_FreyaLTW").LuaObjectScript.Disable()
end
function OnUpdate(level)
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_FaceClimb_Side_070") then
    game.Camera.SubmitCameraByName("PLYR_CrackClimb_OrbitOffset")
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_VertClimb_ByZipline") then
    game.Camera.SubmitCameraByName("PLYR_CrackClimb_ReducedConstraint_ByZipline")
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_ConstraintLMT_Cliffhanger") then
    game.Camera.SubmitCameraByName("PLYR_CrackClimb_ReducedConstraint_CliffhangerArea")
  end
  if player:HasMarker("BlackBreath") then
    playerCurve = player:GetNavCurve()
    if playerCurve ~= nil then
      playerCurveName = playerCurve:GetName()
      if playerCurveName == "BlackBreathLower_SplineNode" then
        game.Camera.SubmitCameraByName("PLYR_Nav_BlackBreath_Lower")
      elseif playerCurveName == "BlackBreathUpper_SplineNode" then
        game.Camera.SubmitCameraByName("PLYR_Nav_BlackBreath_Upper")
      end
    end
  end
end
function Foot400_LoadCheck()
  game.UI.LoadCheck("Foot400_Arena")
end
function Peak100_LoadCheck()
  game.UI.LoadCheck("Peak100_Entrance")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    blackBreathCleared = blackBreathCleared
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  blackBreathCleared = savedInfo.blackBreathCleared
end
function FirstArrivalSetup()
  UpperLedgeCollision:Hide()
  GameObjects.NavDecals_ClimbUp:Show()
  GameObjects.StoneTroll_Statues:Show()
  GameObjects.TraversePath_toPeaks:HideTraversePath()
  SonScripting_FirstTripThough_Enable()
end
function PostFreyaLeadWaySetup()
  elevatorManager.LuaObjectScript.EnableElevator()
  elevatorManager.LuaObjectScript.JumpToBottomFloor()
  SonScripting_FirstTripThough_Disable()
  SonScripting_SecondTripThough_Enable()
end
function StormArrivalSetup()
  GameObjects.TraversePath_toPeaks_Zone:HideEntityVolume()
  GameObjects.StoneTroll_Complete:Hide()
  GameObjects.NavDecals_ClimbUp:Hide()
  GameObjects.NavDecals_Jump:Show()
  SonScripting_SecondTripThough_Disable()
  SonScripting_ThirdTripThough_Enable()
  GameObjects.StoneTroll_Statues:Hide()
  GameObjects.StoneTroll_Broken:Show()
  elevatorManager.LuaObjectScript.DisableElevator({
    animName = "envFootIdleHang",
    cycleAnim = true
  })
  UpperLedgeCollision:Show()
end
function PostStormSetup()
  elevatorManager.LuaObjectScript.EnableElevator()
  elevatorManager.LuaObjectScript.JumpToBottomFloor()
  SonScripting_ThirdTripThough_Disable()
end
function UpdateLoadGroup()
  game.EvaluateLoadZones()
end
function OnEvaluateLoadGroup_LoadGroup_AI_400()
  if game.Level.GetVariable("CompletedCineNumber") < 250 then
    return "AI_Visit_01"
  elseif game.Level.GetVariable("CompletedCineNumber") > 250 then
    return "AI_Visit_02"
  end
end
function OnEvaluateLoadGroup_LoadGroup_AI_500()
  if game.Level.GetVariable("CompletedCineNumber") < 250 then
    return "AI_Visit_01"
  elseif game.Level.GetVariable("CompletedCineNumber") > 250 then
    return "AI_Visit_02"
  end
end
function CA_LowerSonSplines_Disable()
  GameObjects.EntryZone_001:HideEntityVolume()
end
function SonScripting_FirstTripThough_Enable()
  GameObjects.SonSpline_On_Zone:ShowEntityVolume()
  GameObjects.SonSpline_Off_Zone:ShowEntityVolume()
  GameObjects.CA_MtTrip_atBranch_RockLean_Zone:ShowEntityVolume()
  GameObjects.CA_MtTrip_atBranch_Idle.LuaObjectScript.Enable()
  GameObjects.CA_MtTrip_atBranch_OutOfBreath.LuaObjectScript.Enable()
end
function SonScripting_FirstTripThough_Disable()
  GameObjects.SonSpline_On_Zone:HideEntityVolume()
  GameObjects.SonSpline_Off_Zone:HideEntityVolume()
  GameObjects.CA_MtTrip_atBranch_RockLean_Zone:HideEntityVolume()
  GameObjects.CA_MtTrip_atBranch_Idle.LuaObjectScript.Disable()
  GameObjects.CA_MtTrip_atBranch_OutOfBreath.LuaObjectScript.Disable()
end
function SonScripting_SecondTripThough_Enable()
  GameObjects.SonSpline_On_Zone:ShowEntityVolume()
  GameObjects.SonSpline_Off_Zone:ShowEntityVolume()
  GameObjects.CA_GondolaTrip_atBase_GetOnGondola:ShowEntityVolume()
  GameObjects.CA_MtTrip_atBranch_RockLean_Zone:ShowEntityVolume()
  GameObjects.CA_MtTrip_atBranch_Idle.LuaObjectScript.Enable()
  GameObjects.CA_MtTrip_atBranch_OutOfBreath.LuaObjectScript.Disable()
end
function SonScripting_SecondTripThough_Disable()
  GameObjects.SonSpline_On_Zone:HideEntityVolume()
  GameObjects.SonSpline_Off_Zone:HideEntityVolume()
  GameObjects.CA_MtTrip_atBranch_RockLean_Zone:HideEntityVolume()
  GameObjects.CA_MtTrip_atBranch_Idle.LuaObjectScript.Disable()
  GameObjects.CA_MtTrip_atBranch_OutOfBreath.LuaObjectScript.Disable()
  SonScripting_getOnGondolaAid_TurnOff()
end
function SonScripting_ThirdTripThough_Enable()
  GameObjects.SonSpline_On_Zone:ShowEntityVolume()
  GameObjects.SonSpline_Off_Zone:ShowEntityVolume()
  GameObjects.CA_MtTrip_atBranch_RockLean_Zone:ShowEntityVolume()
  GameObjects.SonSpline_Trip3_TurnOff_Zone:ShowEntityVolume()
end
function SonScripting_ThirdTripThough_Disable()
  GameObjects.SonSpline_On_Zone:ShowEntityVolume()
  GameObjects.SonSpline_Off_Zone:ShowEntityVolume()
  GameObjects.CA_MtTrip_atBranch_RockLean_Zone:HideEntityVolume()
end
function SonScripting_TurnOffSpline()
  GameObjects.SonSpline_LTW.LuaObjectScript.Disable()
  GameObjects.SonSpline_On_Zone:HideEntityVolume()
  GameObjects.SonSpline_Off_Zone:HideEntityVolume()
end
function SonScripting_getOnGondolaAid_TurnOff()
  GameObjects.CA_GondolaTrip_atBase_GetOnGondola:HideEntityVolume()
  GameObjects.SonSpline_GondolaTrip.LuaObjectScript.Disable()
  GameObjects.Ca_GondolaTrip_Becon.LuaObjectScript.Disable()
end
function BlackBreathComplete()
  blackBreathCleared = true
  LD.CallFunctionAfterDelay(function()
    local peak100Monitor = LM.CreateLoadMonitor()
    peak100Monitor:AddCallback({
      Wads = {
        "Peak100_Entrance"
      },
      Functions = {
        Peak100Ready
      }
    })
  end, 1.2)
end
function Peak100Ready(wads)
  wads.Peak100_Entrance:CallScript("SCA_PreDoorEnable")
end
function SyncExitToPeaks()
  if not blackBreathCleared then
    GameObjects.CA_Climb_01_Exit.LuaObjectScript.Enable()
  else
    GameObjects.CA_Climb_01_Exit_02.LuaObjectScript.Enable()
  end
end
function GondolaBlocker_TurnOff()
  GameObjects.GondolaBlocker:Hide()
end
function OnGondola_ReachTopFloor()
  topFloor_CollisionCap:ShowCollision()
  bottomFloorCollisionBlocker:Show()
  LowerGondolaBase_TraversalLink:ShowTraverseLink()
  local Foot100_Level = game.FindLevel("Foot100_Base")
  if Foot100_Level ~= nil then
    Foot100_Level:CallScript("Disable_GondolaNoGo")
  end
  SetGondolaWheelsState("Rest")
end
function OnGondola_ReachBottomFloor()
  UpperLedgeCollision:Show()
  bottomFloorCollisionBlocker:Show()
  local Foot100_Level = game.FindLevel("Foot100_Base")
  if Foot100_Level ~= nil then
    Foot100_Level:CallScript("Enable_GondolaNoGo")
  end
  SetLTWToFire()
  if game.Level.GetVariable("CompletedCineNumber") == 190 then
    GameObjects.Gondola_Elevator:FindSingleGOByName("CA_SonIdle_FreyaLTW").LuaObjectScript.Disable()
    GameObjects.GondolaExit_FreyaLTW:ShowEntityVolume()
    elevatorManager.LuaObjectScript.DisableElevator()
    local Foot100_Level = game.FindLevel("Foot100_Base")
    if Foot100_Level ~= nil then
      Foot100_Level:CallScript("LockCrackClimb")
      Foot100_Level:CallScript("FLW_Disable_ContextActions")
    end
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "04_Foothills_030_GondolaUnlocked"]
    tableEntry.OverrideObject = GameObjects.CheckpointOverride_GondolaUnlocked
    game.World.StoreCheckpointAndBookmark(tableEntry)
  else
    LowerCartExit_TraversalLink:ShowTraverseLink()
  end
  SetGondolaWheelsState("Rest")
end
function OnGondola_Move()
  local cineNum = LD.GetEntityVariable("CompletedCineNumber")
  UpperLedgeCollision:Hide()
  topFloor_CollisionCap:HideCollision()
  bottomFloorCollisionBlocker:Hide()
  LowerCartExit_TraversalLink:HideTraverseLink()
  LowerGondolaBase_TraversalLink:HideTraverseLink()
  if cineNum == 190 then
    GameObjects.GondolaPlatform_SpeedCtrlZone:HideEntityVolume()
    local Foot400_Level = game.FindLevel("Foot400_Arena")
    if Foot400_Level ~= nil then
      Foot400_Level:CallScript("UnlockDoor")
    end
  elseif 250 < cineNum and cineNum < 270 then
    GameObjects.POI_CarryAgain_Group.LuaObjectScript.CreateCarryAgainSeq()
  end
  PlayGondolaMovingSound()
end
function OnGondola_PlayerMoveElevator()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if 250 < completedCineNum and completedCineNum < 270 then
    SonScripting_getOnGondolaAid_TurnOff()
  end
  SetGondolaWheelsState("Prepared")
end
function OnGondola_TravelCine()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if completedCineNum == 190 then
    elevatorManager.LuaObjectScript.PlayerMoveElevator("envFootTravelCine02", 0.7)
  end
end
function WaitingAtElevatorCallback(elevatorState)
  if elevatorState == "Top" then
    GameObjects.CA_Gondola_EnterTop.LuaObjectScript.Enable()
  else
    GameObjects.Ca_GondolaTrip_Becon.LuaObjectScript.Enable()
    GameObjects.Ca_GondolaTrip_Becon1.LuaObjectScript.Enable()
  end
end
function OnWaitCompleteElevatorCallback(elevatorState)
  if elevatorState == "Top" then
    GameObjects.CA_Gondola_EnterTop.LuaObjectScript.Disable()
  else
    GameObjects.Ca_GondolaTrip_Becon.LuaObjectScript.Disable()
    GameObjects.Ca_GondolaTrip_Becon1.LuaObjectScript.Disable()
  end
end
function EnableBottomGondolaTraverseLink()
  LowerCartExit_TraversalLink:ShowTraverseLink()
  GameObjects.GondolaExit_FreyaLTW:HideEntityVolume()
end
function HideBushCollision()
end
function PlayShakes_RockFall()
  timer.StartLevelTimer(3.4, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_GIANT",
      Duration = 0.8,
      TweenIn = {Time = 0.3},
      TweenOut = {Time = 0.3},
      Priority = 3
    })
  end)
  timer.StartLevelTimer(3.4, function()
    game.Blender.Trigger({
      Name = "FFB_GIANT",
      Duration = 0.8,
      TweenIn = {Time = 0.3},
      TweenOut = {Time = 0.3},
      Priority = 3
    })
  end)
  timer.StartLevelTimer(0, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_SMALL",
      Duration = 3.4,
      TweenIn = {Time = 1.4},
      TweenOut = {Time = 1},
      Priority = 5
    })
  end)
  timer.StartLevelTimer(0, function()
    game.Blender.Trigger({
      Name = "FFB_LOOP_SMALL",
      Duration = 3.4,
      TweenIn = {Time = 1.4},
      TweenOut = {Time = 0.3},
      Priority = 1
    })
  end)
  timer.StartLevelTimer(3.8, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_TREMORS_LEVEL_0",
      Duration = 2.6,
      TweenIn = {Time = 0.2},
      TweenOut = {Time = 0.3},
      Priority = 5
    })
  end)
  timer.StartLevelTimer(3.8, function()
    game.Blender.Trigger({
      Name = "FFB_LOOP_MEDIUM",
      Duration = 2.6,
      TweenIn = {Time = 0.2},
      TweenOut = {Time = 0.3},
      Priority = 5
    })
  end)
  timer.StartLevelTimer(6.2, function()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_SMALL",
      Duration = 1.6,
      TweenIn = {Time = 0.2},
      TweenOut = {Time = 1},
      Priority = 5
    })
  end)
  timer.StartLevelTimer(6.2, function()
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_LOW",
      Duration = 1.6,
      TweenIn = {Time = 0.2},
      TweenOut = {Time = 1},
      Priority = 5
    })
  end)
end
function RockFall_PlayAnim()
  if game.Level.GetVariable("CompletedCineNumber") >= 440 then
    PlayShakes_RockFall()
    RockFall_Breakable:PlayAnimToEnd(1)
    PlayBoulderFall()
    GameObjects.RockFall_EntityZoneEvents.LuaObjectScript.Disable()
    GameObjects.RockFall_Event:HideEntityVolume()
    GameObjects.GapJump_Collision_01:ShowCollision()
    GameObjects.GapJump_Collision_02:ShowCollision()
    GameObjects.TraverseLink_GapJump:ShowTraverseLink()
    timer.StartLevelTimer(3, function()
      GameObjects.Foot500_Banter.LuaObjectScript.RockFallNiceTry_Banter()
    end)
    timer.StartLevelTimer(3, function()
      GameObjects.RockFall_Reaction.LuaObjectScript.Trigger()
    end)
  end
end
function Enable_ClimbToPeaks()
  if game.Level.GetVariable("CompletedCineNumber") < 440 then
    GameObjects.TraversePath_toPeaks:ShowTraversePath()
  end
end
function Disable_ClimbToPeaks()
  if game.Level.GetVariable("CompletedCineNumber") < 440 then
    GameObjects.TraversePath_toPeaks:HideTraversePath()
  end
end
function FirstClimb_RockFall_01()
  local FallingRock = thisLevel:GetGameObject("crack_climb_rocks01"):FindSingleGOByName("MaleMeFallYo1")
  FallingRock:PlayAnimToEnd(1)
  climbBreakSound01()
end
function FirstClimb_RockFall_02()
  local FallingRock = thisLevel:GetGameObject("crack_climb_rocks02"):FindSingleGOByName("MaleMeFallYo1")
  FallingRock:PlayAnimToEnd(1)
  climbBreakSound02()
end
function FirstClimb_RockFall_03()
  local FallingRock = thisLevel:GetGameObject("crack_climb_rocks03"):FindSingleGOByName("MaleMeFallYo1")
  FallingRock:PlayAnimToEnd(1)
  climbBreakSound03()
end
function Open_BrambleLoot_01()
  GameObjects.coffin_tier5_foot500_1.LuaObjectScript.Enable()
end
function Open_BrambleLoot_03()
  GameObjects.chest_common_tier5_foot500_1.LuaObjectScript.Enable()
end
function Open_BrambleLoot_05()
  GameObjects.chest_legendary_tier4_foot500_1.LuaObjectScript.Enable()
end
function Open_BladesBlocker_06()
  GameObjects.BladeBramble_Chest_03.LuaObjectScript.Enable()
end
function CompleteFoothills_Objective100()
  LD.CompleteQuest("Quest_Foothills_Objective100")
end
function CompassGatewayToggle()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 439 < cineNumber then
    game.Compass.SetGatewayMarkerIsOpen("FOOT_500_Helper6", false)
  elseif elevatorManager.LuaObjectScript.IsEnabled() == false then
    game.Compass.SetGatewayMarkerIsOpen("FOOT_500_Helper6", false)
  elseif elevatorManager.LuaObjectScript.IsEnabled() == true then
    game.Compass.SetGatewayMarkerIsOpen("FOOT_500_Helper6", true)
  end
end
function EnterBehaviorContext_WAIT_AND_EXPLORE()
  if game.Level.GetVariable("CompletedCineNumber") < 440 or game.Level.GetVariable("CompletedCineNumber") > 470 then
    son:CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
  else
    son:CallScript("EnterBehaviorContext", "FRUSTRATED_BEHAVIOR_CONTEXT_CONFIG")
  end
end
function EnterBehaviorContext_COLD()
  if game.Level.GetVariable("CompletedCineNumber") < 440 or game.Level.GetVariable("CompletedCineNumber") > 470 then
    son:CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
  else
    son:CallScript("EnterBehaviorContext", "FRUSTRATED_BEHAVIOR_CONTEXT_CONFIG")
  end
end
function ClearBehaviorContext()
  son:CallScript("ClearBehaviorContext")
end
function Trigger_OutOfBreath()
  GameObjects.React_OutOfBreath.LuaObjectScript.Trigger()
end
local gondolaOverrideSoundEvents = {
  soundOnReturnToStart = "SND_MECH_Gondola_Platform_Hits_Stop_Point",
  soundOnForward = "SND_MECH_Gondola_LP",
  soundOnBackward = "SND_MECH_Gondola_LP",
  soundOnEnd = "SND_MECH_Gondola_Platform_Hits_Stop_Point"
}
local gondolaOverrideSoundFrames_FreyaLTW = {
  soundAnimFrameOnReturnToStart = 1150,
  soundAnimFrameOnForward = 35,
  soundAnimFrameOnBackward = 35,
  soundAnimFrameOnEnd = 1150,
  soundAnimFrameTopFloor = 1150,
  soundAnimFrameBottomFloor = 1150
}
local gondolaOverrideSoundFrames_Normal = {
  soundAnimFrameOnReturnToStart = 688,
  soundAnimFrameOnForward = 35,
  soundAnimFrameOnBackward = 35,
  soundAnimFrameOnEnd = 688,
  soundAnimFrameTopFloor = 688,
  soundAnimFrameBottomFloor = 688
}
local gondolaWheelsState = "Rest"
local soundEmitterGondolUpper, soundEmitterGondolaLower, soundEmitterbreak_GRP
local GondolaWheelLoop = "SND_MECH_Gondola_Wheel_Rotate_LP"
local BoulderFallSound = "SND_BRK_PeaksPass_Rockfall_Break"
local BoulderImpactSound = "SND_BRK_PeaksPass_Rockfall_Impact"
local soundEmitterFreyaVines, soundEmitterRockBreak1, soundEmitterRockBreak2, soundEmitterRockBreak3
function SoundInit()
  soundEmitterGondolUpper = GameObjects.Gondola_Elevator_Platforms:FindSingleSoundEmitterByName("SNDGondola_Upper")
  soundEmitterGondolaLower = GameObjects.Gondola_Elevator_Platforms:FindSingleSoundEmitterByName("SNDGondola_Lower")
  soundEmitterbreak_GRP = GameObjects.RockFall_Breakable.Child:FindSingleSoundEmitterByName("SNDbreak_GRP")
  soundEmitterFreyaVines = GameObjects.SNDGrpFreyaVines:FindSingleSoundEmitterByName("SNDFreyaVines")
  soundEmitterRockBreak1 = thisLevel:GetGameObject("crack_climb_rocks01").Child:FindSingleSoundEmitterByName("SNDMaleMeFallYo1")
  soundEmitterRockBreak2 = thisLevel:GetGameObject("crack_climb_rocks02").Child:FindSingleSoundEmitterByName("SNDMaleMeFallYo1")
  soundEmitterRockBreak3 = thisLevel:GetGameObject("crack_climb_rocks03").Child:FindSingleSoundEmitterByName("SNDMaleMeFallYo1")
end
function SetupSoundOverrides()
  elevatorManager.LuaObjectScript.SoundSetup(gondolaOverrideSoundEvents)
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cineNumber < 210 then
    elevatorManager.LuaObjectScript.SoundSetup(gondolaOverrideSoundFrames_FreyaLTW)
  else
    elevatorManager.LuaObjectScript.SoundSetup(gondolaOverrideSoundFrames_Normal)
  end
end
function SetGondolaWheelsState(newState)
  gondolaWheelsState = newState
end
function PlayGondolaMovingSound()
  if gondolaWheelsState == "Prepared" then
    SetGondolaWheelsState("Active")
    LD.PlaySound(soundEmitterGondolaLower, GondolaWheelLoop)
    LD.PlaySound(soundEmitterGondolUpper, GondolaWheelLoop)
    local cineNumber = game.Level.GetVariable("CompletedCineNumber")
    if cineNumber < 210 then
      LD.StopSoundOnFrame(soundEmitterGondolaLower, GameObjects.Gondola_Elevator.Child, "SND_MECH_Gondola_Wheel_Rotate_LP", 1150, "forward")
      LD.StopSoundOnFrame(soundEmitterGondolUpper, GameObjects.Gondola_Elevator.Child, "SND_MECH_Gondola_Wheel_Rotate_LP", 1150, "forward")
    else
      LD.StopSoundOnFrame(soundEmitterGondolaLower, GameObjects.Gondola_Elevator.Child, "SND_MECH_Gondola_Wheel_Rotate_LP", 688, "forward")
      LD.StopSoundOnFrame(soundEmitterGondolUpper, GameObjects.Gondola_Elevator.Child, "SND_MECH_Gondola_Wheel_Rotate_LP", 688, "forward")
    end
  end
end
function PlayBoulderFall()
  LD.PlaySound(soundEmitterbreak_GRP, BoulderFallSound)
  LD.PlaySoundOnFrame(soundEmitterbreak_GRP, RockFall_Breakable, BoulderImpactSound, 102)
  print("sound emitter: ", soundEmitterbreak_GRP, "sound event :", BoulderFallSound)
  print("sound emitter: ", soundEmitterbreak_GRP, "sound event :", BoulderImpactSound)
end
function LuaHook_LVLFreyaVinesStart()
  LD.PlaySound(soundEmitterFreyaVines, "SND_CINE_Freya_Dispels_Gondola_Blockage_LP")
end
function LuaHook_LVLFreyaVinesEnd()
  LD.StopSound(soundEmitterFreyaVines, "SND_CINE_Freya_Dispels_Gondola_Blockage_LP")
end
function climbBreakSound01()
  LD.PlaySound(soundEmitterRockBreak1, "SND_BRK_Stone_Rubble_Pile_01")
end
function climbBreakSound02()
  LD.PlaySound(soundEmitterRockBreak2, "SND_BRK_Stone_Rubble_Pile_02")
end
function climbBreakSound03()
  LD.PlaySound(soundEmitterRockBreak3, "SND_BRK_Stone_Rubble_Pile_03")
end
function SetLTWToFire()
  local freLTWWad = game.FindLevel("FreyaLTW")
  if freLTWWad ~= nil then
    freLTWWad:CallScript("LTW_ExitGondola_Start")
  end
end
function DisableSonUpperLTWAndSpeedControl()
  local freLTWWad = game.FindLevel("FreyaLTW")
  if freLTWWad ~= nil then
    freLTWWad:CallScript("TurnOffSonLTW")
  end
end
function AbortSonRuneRead()
  local soninteraction = thisLevel:FindSingleGameObject("LoreMarker_01_ReadPoint")
  if soninteraction then
    soninteraction.LuaObjectScript.InteractAbort()
  end
end
