local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local player
local boolRBreathBeGone = false
local boolRBreathBeGone_Clear = false
local rBreathBeGoneMonitor, rBreathBeGone_ClearMonitor
local btrRBreathBeGone = "070_R_BreathBeGone"
local btrRBreathBeGone_Clear = "070_R_BreathBeGone_Clear"
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  InitializeVariables()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {playedSetupBool = boolRBreathBeGone, playedSetupBool = boolRBreathBeGone_Clear}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
  boolRBreathBeGone = savedInfo.playedSetupBool
  boolRBreathBeGone_Clear = savedInfo.playedSetupBool
end
function InitializeVariables()
  if boolRBreathBeGone == false then
    rBreathBeGoneMonitor = monitors.CreateEntityZoneMonitor(player, "BtrZone_BreathBeGone")
    rBreathBeGoneMonitor:OnEnter(function()
      if game.Level.GetVariable("CompletedCineNumber") > 250 and game.Level.GetVariable("CompletedCineNumber") < 270 then
        boolRBreathBeGone = true
        game.Audio.PlayBanter(btrRBreathBeGone)
        rBreathBeGoneMonitor:Stop()
        rBreathBeGoneMonitor = nil
      end
    end)
  end
  if boolRBreathBeGone_Clear == false then
    rBreathBeGone_ClearMonitor = monitors.CreateEntityZoneMonitor(player, "BtrZone_BreathBeGone_Clear")
    rBreathBeGone_ClearMonitor:OnEnter(function()
      if game.Level.GetVariable("CompletedCineNumber") > 250 and game.Level.GetVariable("CompletedCineNumber") < 270 then
        boolRBreathBeGone_Clear = true
        game.Audio.PlayBanter(btrRBreathBeGone_Clear)
        rBreathBeGone_ClearMonitor:Stop()
        rBreathBeGone_ClearMonitor = nil
      end
    end)
  end
end
