local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timers = require("level.timer")
local actor = require("narrative.actor")
local thisLevel, kraActor, freActor
local boolCartButton = false
local boolWorldSnakeExplained = false
local cartSwitchInteractedWith = false
local freyaSuggestedTurningSwitch = false
local btrCartButton = "090_CartButton"
local btrCartButtonPressed = "090_CartButton_Push"
function OnScriptLoaded(level, obj)
  thisLevel = level
end
function OnStart(level, obj)
  if not boolCartButton and game.Level.GetVariable("CompletedCineNumber") <= 190 then
    CreateActors()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {playedSetupBool = boolCartButton}
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  boolCartButton = savedInfo.playedSetupBool
end
function CreateActors()
  kraActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  freActor = actor.Actor.New("Freya", ND.FindFreya)
end
function CartButtonStartedUse()
  if game.Level.GetVariable("CompletedCineNumber") < 210 then
    cartSwitchInteractedWith = true
  end
end
function CartButtonUsed()
  if game.Level.GetVariable("CompletedCineNumber") < 210 then
    if freyaSuggestedTurningSwitch == true then
      game.Audio.PlayBanter(btrCartButtonPressed)
    end
    local fre = ND.FindFreya()
    if fre then
      fre:CallScript("LuaHook_HeadTrack_ClearForcedTarget")
    end
  end
end
function BuildCartButtonSeq()
  local seq = ND.CreateCineSequence(thisLevel, GameObjects.Gondola_Elevator.Child:FindSingleGOByName("CartButtonGroup_Freya"), "CartButton")
  seq:ActorForceApproachAndWait(freActor, {
    Branch = "BRA_CartButtonEnter",
    ReferenceJoint = "CartButton_Freya_SynchJoint",
    speed = ND.FreyaWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius
  })
  seq:ActorSync(freActor, {
    Branch = "BRA_CartButtonEnter",
    ReferenceJoint = "CartButton_Freya_SynchJoint"
  })
  seq:Do(DisableUpperFreyaSplineNav)
  seq:WaitForActorPlayingMove(freActor, "MOV_CartButtonIdle")
  seq:WaitForActorInZone(kraActor, "BtrZone_CartButton_Pushed")
  seq:Do(function()
    if cartSwitchInteractedWith == false then
      LD.FindFreya():TriggerMoveEvent("kLE_Gesture02")
      game.Audio.PlayBanter("090_CartButton")
      freyaSuggestedTurningSwitch = true
    end
  end)
  seq:WaitForFunctionTrue(function()
    return boolCartButton
  end)
  seq:StopPuppetingActor(freActor)
  seq:Do(CleanupFreya)
  seq:StartSequence()
end
function CleanupFreya()
  LD.FindFreya():TriggerMoveEvent("kLE_Disengage")
end
function CartRideDone()
  boolCartButton = true
end
function DisableUpperFreyaSplineNav()
  local freLTWWad = game.FindLevel("FreyaLTW")
  if freLTWWad ~= nil then
    freLTWWad:CallScript("TurnOffFreyaLTW")
  end
end
