local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local player, thisLevel, domeFX, dispelFX
local clearedLower = false
local clearedUpper = false
local musicOn = false
local blastFlashParams = {
  EffectName = "FSE_BLACKBREATH_FLASH",
  Duration = 0.1,
  TweenInTime = 0.1,
  TweenOutTime = 1.6
}
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function Checkpoint()
  game.World.StoreCheckpoint()
end
function OnSaveCheckpoint(level, obj)
  return {clearedLower = clearedLower, clearedUpper = clearedUpper}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  clearedLower = savedInfo.clearedLower or false
  clearedUpper = savedInfo.clearedUpper or false
end
function OnStart(level, obj)
  SetProperState_InteractZones()
  SetProperState_BlockerCollision()
  SetProperState_SoundEmitters()
  SetProperState_BlackBreathFX()
end
function SetProperState_BlackBreathFX()
  if clearedLower then
    LD.HideFX(GameObjects.BlackBreath_Fall_BlastDispel_FX)
  end
  if clearedUpper then
    LD.HideFX(GameObjects.BlackBreath_Fall_DoorBlast_FX)
  end
end
function LuaHook_BlackBreath_DomeFX_On()
  if domeFX.Child.AnimPercent == 1 then
    domeFX.Child:JumpAnimToPercent(0)
  end
  domeFX.Child:ShowParticles()
  domeFX.Child:ShowParticleEmitter()
  domeFX.Child:ShowModel()
  domeFX.Child:PlayAnimToEnd()
end
function LuaHook_BlackBreath_DomeFX_Off()
  if domeFX ~= nil then
    LD.HideFX(domeFX)
    if domeFX.Child.AnimFrame > 30 then
      domeFX.Child:JumpAnimToFrame(30)
    end
    domeFX.Child:PlayAnimToEnd(-1)
  end
end
function CleanupDomeFX()
  if domeFX ~= nil then
    domeFX:Destroy()
    domeFX = nil
  end
end
function LuaHook_BlackBreath_DispelFX_On()
  if dispelFX == nil then
    local attachJoint = "JOBifrostHolster1_JOLeftWrist1_0"
    local attachJointPos = player:GetWorldJointPosition(player:GetJointIndex(attachJoint))
    dispelFX = game.FX.Spawn("Bifrost_Blackbreath_Dispel_FX", thisLevel, {
      AutoDelete = false,
      GameObject = player,
      Joint = attachJoint
    })
    dispelFX:SetWorldPosition(attachJointPos)
    LD.CallFunctionAfterDelay(function()
      LD.ShowFX(dispelFX.Child)
    end, 0.1)
  end
  if domeFX == nil then
    local attachJoint = "linkJoint"
    local attachJointPos = player:GetWorldJointPosition(player:GetJointIndex(attachJoint))
    domeFX = game.FX.Spawn("Bifrost_BlackBreath_EnergyDome_FX", thisLevel, {
      AutoDelete = false,
      GameObject = player,
      Joint = attachJoint
    })
    domeFX:SetWorldPosition(attachJointPos)
  end
  GameObjects.Bifrost_BlackBreath_EnterFX_Ref:SetWorldPosition(player:GetWorldJointPosition(player:GetJointIndex("linkJoint")))
  GameObjects.Bifrost_BlackBreath_EnterFX_Ref:SetWorldFacing(player:GetWorldForward())
  LD.HideFX(GameObjects.Bifrost_BlackBreath_EnterFX_Ref, {immediate = true})
  LD.ShowFX(GameObjects.Bifrost_BlackBreath_EnterFX_Ref)
end
function LuaHook_BlackBreath_BlastFX_Start()
  local attachJointIndex = player:GetJointIndex("linkJoint")
  local attachJointPos = player:GetWorldJointPosition(attachJointIndex)
  local attachDir = player:GetWorldForward()
  local fxRef
  if clearedUpper == false then
    fxRef = GameObjects.Bifrost_BlackBreath_Blast_FX
  else
    fxRef = GameObjects.Bifrost_BlackBreath_Blast_Upper_FX
  end
  fxRef:SetWorldPosition(attachJointPos)
  fxRef:SetWorldFacing(attachDir)
  LD.ShowFX(fxRef)
end
function LuaHook_BlackBreath_BlastFX_Trigger()
  game.FX.SubmitEffect(blastFlashParams)
  CleanupDispelFX()
  CleanupDomeFX()
  if clearedUpper == false then
    GameObjects.BlackBreathLower_SplineController.LuaObjectScript.Disable()
    GameObjects._BlackBreath_Fall:Hide()
    GameObjects._BlackBreath_Steps:Hide()
    StopSoundDissolvingLoop_OnLower()
  else
    GameObjects.BlackBreathUpper_SplineController.LuaObjectScript.Disable()
    GameObjects._PeakEntrance_BlackBreath_FX:Hide()
    StopSoundDissolvingLoop_OnUpper()
  end
end
function CleanupDispelFX()
  if dispelFX ~= nil then
    dispelFX:Destroy()
    dispelFX = nil
  end
end
function SetProperState_InteractZones()
  if game.Level.GetVariable("CompletedCineNumber") >= 250 then
    if clearedLower == false then
      GameObjects.BlackBreathLower_InteractZone.LuaObjectScript.Enable()
    elseif clearedLower == true then
      GameObjects.BlackBreathLower_InteractZone.LuaObjectScript.Disable()
    end
    if clearedUpper == false then
      GameObjects.BlackBreathUpper_InteractZone.LuaObjectScript.Enable()
    elseif clearedUpper == true then
      GameObjects.BlackBreathUpper_InteractZone.LuaObjectScript.Disable()
    end
  else
    GameObjects.BlackBreathLower_InteractZone.LuaObjectScript.Disable()
    GameObjects.BlackBreathUpper_InteractZone.LuaObjectScript.Disable()
  end
end
function SetProperState_BlockerCollision()
  if clearedLower == true then
    GameObjects.BlackBreathBlocker:HideCollision()
  else
    GameObjects.BlackBreathBlocker:ShowCollision()
  end
  if clearedUpper == true then
    GameObjects.BlackBreathBlocker_Upper:HideCollision()
  else
    GameObjects.BlackBreathBlocker_Upper:ShowCollision()
  end
end
function EnterBlackBreathSpline_Lower()
  _G.SonScripting_SecondTripThough_Disable()
  _G.SonScripting_TurnOffSpline()
  local ApproachCompleteFn = function()
    if musicOn == false then
      game.Audio.StartMusic("SND_MX_FOOT_clear_black_breath")
      musicOn = true
    end
    PlaySoundDissolvingLoop_OnLower()
  end
  local SyncCompleteFn = function()
    GameObjects.BlackBreathLower_SplineController.LuaObjectScript.Enable()
  end
  LD.PlaySingleSynchMove_KratosObject(GameObjects.BlackBreathLower_SplinePupObj, "dummyJoint", "Black Breath Enter", "BRA_BlackBreathEnter", "", nil, nil, nil, {OnApproachComplete = ApproachCompleteFn, OnSyncComplete = SyncCompleteFn})
  GameObjects.BlackBreathBlocker:HideCollision()
  clearedLower = true
end
function ExitBlackBreathSpline_Lower()
  LD.ShowFX(GameObjects.BlackBreath_Fall_BlastDispel_FX)
  local heroPuppeteer = game.Puppeteer.NewForce(GameObjects.BlackBreathLower_SplinePupObj, "Black Breath Exit Move (Foot500_Top.lua)", player)
  heroPuppeteer:StartMove("MOV_BlackBreathExitBlast")
  heroPuppeteer:OnComplete(function()
    if heroPuppeteer ~= nil then
      heroPuppeteer:Clear()
      heroPuppeteer = nil
    end
    QuestUpdate()
    GameObjects.Foot500_Banter.LuaObjectScript.PathDestroyed_Banter()
  end)
end
function QuestUpdate()
  game.QuestManager.ProposeQuestState("Quest_Foothills_Objective200", "Complete")
  LD.ActivateQuest("Quest_PeaksPass_Parent")
  Checkpoint()
end
function EnterBlackBreathSpline_Upper()
  local ApproachCompleteFn = function()
    PlaySoundDissolvingLoop_OnUpper()
    game.Audio.StartMusic("SND_MX_FOOT_clear_black_breath_2")
  end
  local SyncCompleteFn = function()
    GameObjects.BlackBreathUpper_SplineController.LuaObjectScript.Enable()
  end
  LD.PlaySingleSynchMove_KratosObject(GameObjects.BlackBreathUpper_SplinePupObj, "dummyJoint", "Black Breath Enter", "BRA_BlackBreathEnter", "", nil, nil, nil, {OnApproachComplete = ApproachCompleteFn, OnSyncComplete = SyncCompleteFn})
  GameObjects.BlackBreathBlocker_Upper:HideCollision()
  clearedUpper = true
end
function ExitBlackBreathSpline_Upper()
  LD.HideFX(GameObjects.Bifrost_BlackBreath_EnterFX_Ref, {immediate = true})
  LD.CallFunctionAfterDelay(function()
    LD.ShowFX(GameObjects.BlackBreath_Fall_DoorBlast_FX)
  end, 0.5)
  local heroPuppeteer = game.Puppeteer.NewForce(GameObjects.BlackBreathUpper_SplinePupObj, "Black Breath Exit Move (Foot500_Top.lua)", player)
  heroPuppeteer:StartMove("MOV_BlackBreathExitBlast")
  heroPuppeteer:OnComplete(function()
    if heroPuppeteer ~= nil then
      heroPuppeteer:Clear()
      heroPuppeteer = nil
    end
  end)
end
local activeSoundLoop = "SND_MAG_Black_Breath_Smolder_LP"
local dissolvingSoundLoop = "SND_MAG_Black_Breath_Dissolve_LP"
local lowerEmitter, upperEmitter
function SetProperState_SoundEmitters()
  if clearedLower == true then
    GameObjects.SNDBlackBreathAudioSplineLower:Hide()
  else
    lowerEmitter = GameObjects.SNDBlackBreathAudioSplineLower:FindSingleSoundEmitterByName("SNDBlackBreathLower")
    PlaySoundActiveLoop(lowerEmitter)
  end
  if clearedUpper == true then
    GameObjects.SNDBlackBreathAudioSplineUpper:Hide()
  else
    upperEmitter = GameObjects.SNDBlackBreathAudioSplineUpper:FindSingleSoundEmitterByName("SNDBlackBreathUpper")
    PlaySoundActiveLoop(upperEmitter)
  end
end
function PlaySoundActiveLoop(emitter)
  LD.PlaySound(emitter, activeSoundLoop)
end
function StopSoundActiveLoop(emitter)
  LD.StopSound(emitter, activeSoundLoop)
end
function PlaySoundDissolvingLoop_OnLower()
  PlaySoundDissolvingLoop(lowerEmitter)
end
function PlaySoundDissolvingLoop_OnUpper()
  PlaySoundDissolvingLoop(upperEmitter)
end
function PlaySoundDissolvingLoop(emitter)
  StopSoundActiveLoop(emitter)
  LD.PlaySound(emitter, dissolvingSoundLoop)
end
function StopSoundDissolvingLoop_OnLower()
  GameObjects.SNDBlackBreathAudioSplineLower:Hide()
end
function StopSoundDissolvingLoop_OnUpper()
  GameObjects.SNDBlackBreathAudioSplineUpper:Hide()
end
