local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, A1_ZM_1, A1_ZM_2, A2_ZM_1, Area_3_Encounter_1, Area_1_Visit02_Encounter_1, Area_1_Visit02_Encounter_2, Area_2_Visit02_Encounter_1, Area_2_Visit02_Encounter_2, Area_3_Visit02_Encounter_1, Area_3_Visit02_Encounter_2, Enemy_HealthMonitor, enc_1_V02_fight_1Alert
function OnScriptLoaded(level, obj)
  thisLevel = level
  Area_1_V02_Fight_2()
end
function OnStart(level, obj)
  GameObjects.EntZn_A1_V2_Spawn_02:HideEntityVolume()
end
function Area_2_Fight_1_Start()
end
function Area_1_V02_Fight_2()
  Area_1_Visit02_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]EC2: Foot500 Arena", {
    spawnWad = "Foot500_Top_AI_Visit02",
    CheckpointOnComplete = false,
    LeashZone = "LshZn_Foot500_Arena_1"
  })
  Area_1_Visit02_Encounter_2:AddWave({
    prioritizeOnScreenSpawners = true,
    timeBeforeNextWave = 0.25,
    {
      spawners = "Flyer00_Ice_PL3_SFG",
      spawnLocators = "Loc_A1_Air_0*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0.5, 1}
    }
  })
  Area_1_Visit02_Encounter_2:AddWave({
    prioritizeOffScreenSpawners = true,
    {
      spawners = "Flyer00_Ice_PL3_SFG",
      spawnLocators = "Loc_A1_Ground_0*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0.5, 1}
    },
    {
      spawners = "Flyer00_Blind_PL3_SFG",
      spawnLocators = "Loc_A1_Ground_0*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {0, 0}
    }
  })
  Area_1_Visit02_Encounter_2:AddWave({
    spawnPattern = "Clumped",
    prioritizeOnScreenSpawners = true,
    {
      spawners = "Flyer00_Sui_PL3_SFG",
      spawnLocators = "Loc_A1_Ground_0*",
      useSpawnLocatorsOnly = true,
      initialSpawnAmount = 2,
      maxActive = 2,
      totalSpawns = 2,
      initialSpawnCooldown = {0, 2},
      spawnCooldown = {0.25, 2}
    }
  })
  Area_1_Visit02_Encounter_2:SetStartZone(GameObjects.EntZn_A1_V2_Spawn_02, {cineRequirement = 450})
  Area_1_Visit02_Encounter_2:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Ice")
  end)
end
function A1_V02_TrgVolShow()
  GameObjects.EntZn_A1_V2_Spawn_02:ShowEntityVolume()
end
function Area_2_V02_Fight_2()
  Area_2_Visit02_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 3]EC: Before Cave Foot500", {
    spawnWad = "Foot500_Top_AI_Visit02",
    CheckpointOnComplete = false,
    LeashZone = "LshZn_Foot500_Arena_2"
  })
  Area_2_Visit02_Encounter_2:AddWave({
    {
      spawners = "Flyer00_Ice_PL3_SFG",
      spawnLocators = "Loc_A2_Air_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0, 1}
    },
    {
      spawners = "Flyer00_Ice_PL3_SFG",
      spawnLocators = "Loc_A2_Air_04",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {1, 2}
    }
  })
  Area_2_Visit02_Encounter_2:SetStartZone(GameObjects.EntZn_A2_V2_Spawn_02, {cineRequirement = 450})
end
