local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local uiCalls = require("ui.uicalls")
local freyaSpawnJoint, freyaSpawnPos, freyaSpawnFacing, freyaAiObject, thisLevel, thisObj, freyaActor, kratosActor, sonActor
local interactApproved = false
local blackBreath_actorTable, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_Foot500_StairwayToBlackSmoke", 7.3, nil)
  cameraCineEnter:SetObjectToSleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 200 then
    CreateActorsAndPositions()
  end
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function CreateActorsAndPositions()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  freyaActor = actor.Actor.New("Freya", ND.FindFreya)
  blackBreath_actorTable = {
    {Actor = sonActor},
    {Actor = freyaActor}
  }
end
function BlackBreathCineSequence()
  if game.Level.GetVariable("CompletedCineNumber") < 190 then
    game.Compass.SetDesignerForcedHide(true)
    local Foot500_Level = game.FindLevel("Foot500_Top")
    if Foot500_Level ~= nil then
      Foot500_Level:CallScript("SonScripting_FirstTripThough_Disable")
      Foot500_Level:CallScript("GondolaBlocker_TurnOff")
    end
    local Foot100_Level = game.FindLevel("Foot100_Base")
    if Foot100_Level ~= nil then
      Foot100_Level:CallScript("DisableShop")
    end
    local blackBreathSeq = ND.CreateCineSequence(thisLevel, thisObj, "blackBreath")
    blackBreathSeq:SetPostSkipMusic("SND_MX_FOOT_start_master")
    blackBreathSeq:MarkAbleToSkip()
    blackBreathSeq:Do(DisableSonCombatAvailability)
    blackBreathSeq:Do(LockRedDoor)
    blackBreathSeq:RequestCineModeAndWait(kratosActor, thisObj)
    blackBreathSeq:Do(SpawnFreya)
    blackBreathSeq:WaitForFunctionTrue(DoesFreyaExist)
    blackBreathSeq:Do(StartPreCineCamera)
    blackBreathSeq:Do(AbortExitingSonInteraction)
    blackBreathSeq:Do(function()
      game.Player.FindPlayer():SetAccelerationOverride(2)
    end)
    blackBreathSeq:Do(function()
      game.Player.FindPlayer():SetDecelerationOverride(6)
    end)
    blackBreathSeq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_Blackbreath",
      ReferenceJoint = "Cine_Blackbreath_SyncJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      foot = game.Creature.Foot.kLeft,
      radius = ND.ArrivalRadius,
      weapon_state = "bare",
      ignore_navmesh = false
    })
    blackBreathSeq:ActorSync(kratosActor, {
      Slaves = blackBreath_actorTable,
      Branch = "BRA_Blackbreath",
      ReferenceJoint = "Cine_Blackbreath_SyncJoint"
    })
    blackBreathSeq:WaitForLoadCheck("FreyaLTW")
    blackBreathSeq:Do(EnableLTW)
    blackBreathSeq:Do(function()
      game.AI.FindSon():SetAccelerationOverride(1.8)
    end)
    blackBreathSeq:WaitForActorFinishMove(freyaActor, "MOV_Blackbreath")
    blackBreathSeq:StopPuppetingActor(freyaActor)
    blackBreathSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    blackBreathSeq:Do(function()
      game.Player.FindPlayer():ClearDecelerationOverride()
    end)
    blackBreathSeq:Do(function()
      game.Player.FindPlayer():ClearAccelerationOverride()
    end)
    blackBreathSeq:Do(function()
      GameObjects.NoGoZone_Blackbreath:Hide()
    end)
    blackBreathSeq:SetCompletedCineNumber(190)
    blackBreathSeq:Do(CompleteRiverPassQuest)
    blackBreathSeq:Do(ActivateFoothillsParent)
    blackBreathSeq:Do(CompassHelper)
    blackBreathSeq:StopPuppetingActor(sonActor)
    blackBreathSeq:StopPuppetingActor(kratosActor)
    blackBreathSeq:WaitForFunctionTrue(function()
      return game.AI.FindSon().WorldPosition:Distance(freyaActor:GetCreature().WorldPosition) > 5.5
    end)
    blackBreathSeq:Do(UpdateSonFollowParams)
    blackBreathSeq:Do(Checkpoint)
    blackBreathSeq:StartSequence()
  end
end
function DisableSonCombatAvailability()
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", {AvailableForCombat = false})
end
function LockRedDoor()
  local foot400_Arena = game.FindLevel("Foot400_Arena")
  local redDoor = foot400_Arena:GetGameObject("HingeDoor_Foot400").Child
  redDoor:CallScript("Lock")
end
function AbortExitingSonInteraction()
  local son = sonActor:GetCreature()
  if son:IsInteracting() then
    local foot500 = game.FindLevel("Foot500_Top")
    foot500:CallScript("AbortSonRuneRead")
  end
end
function StartPreCineCamera()
  cameraCineEnter:Start()
end
function DoesFreyaExist()
  freyaAiObject = ND.CatchFreyaReference(freyaAiObject)
  if freyaAiObject ~= nil then
    return true
  else
    return false
  end
end
function SpawnFreya()
  if LD.FindFreya() == nil then
    local objName = "Cine_Blackbreath"
    local jointName = "FreyaSpawnJoint"
    local spawnPosVector = LD.GetWorldJointPosition(objName, jointName)
    local spawnDirVector = LD.GetWorldJointForward(objName, jointName)
    ND.SpawnFreyaAtVector(spawnPosVector, spawnDirVector)
  end
end
function EnableLTW()
  game.FindLevel("FreyaLTW"):CallScript("LTW_DownFoothills_Start")
end
function UpdateSonFollowParams()
  local freLTWWad = game.FindLevel("FreyaLTW")
  if freLTWWad ~= nil then
    freLTWWad:CallScript("LTW_DownFoothills_UpdateSonFollowParams")
  end
end
function CompassHelper()
  game.Compass.SetGatewayMarkerIsOpen("FOOT_100_Helper3", true)
  game.Compass.SetDesignerForcedHide(false)
end
function CompleteRiverPassQuest()
  game.QuestManager.ProposeQuestState("Quest_RiverPass_Objective960", "Complete")
end
function ActivateFoothillsParent()
  LD.ActivateQuest("Quest_Foothills_Parent01")
end
function Checkpoint()
  game.World.StoreCheckpoint()
end
