local timers = require("level.timer")
local thisObj
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
  end
end
function RockFallNiceTry_Banter()
  if not banterPlayed.RockFallNiceTry then
    game.Audio.PlayBanter("050_RockFallNiceTry")
    banterPlayed.RockFallNiceTry = true
  end
end
function BrokenAgain_Banter()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 450 <= cineNum and cineNum < 470 and not banterPlayed.BrokenAgain then
    GameObjects.Gondola_SwitchWall.LuaObjectScript.EnableCinematicTrigger()
    GameObjects.Gondola_Manager.LuaObjectScript.DisableElevator()
    game.Audio.PlayBanter("010_BrokenAgain", function()
      banterPlayed.BrokenAgain = true
    end)
  end
end
function PathDestroyed_Banter()
  if not banterPlayed.PathDestroyed then
    game.Audio.PlayBanter("080_R_PathDestroyed")
    banterPlayed.PathDestroyed = true
  end
end
