local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, sonActor
local boolCarryAgainSeen = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.boolCarryAgainSeen = boolCarryAgainSeen
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    boolCarryAgainSeen = savedInfo.boolCarryAgainSeen
  end
end
function CreateActors()
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function CreateCarryAgainSeq()
  local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
  if not boolCarryAgainSeen and 250 < completedCineNum and completedCineNum < 270 then
    CreateActors()
    local seq = ND.CreateCineSequence(thisLevel, thisObj, "Carry Again")
    local elevatorObject = GameObjects.Gondola_Elevator:FindSingleGOByName("Gondola_Manager")
    local branchName
    if game.Audio.CanBanterConversationPlay("050_R_CarryAgain") then
      branchName = "BRA_CarryAgain"
    else
      branchName = "BRA_CarryAgain_IdleOnly"
    end
    seq:WaitForFunctionTrue(function()
      return elevatorObject.LuaObjectScript.GetState() ~= "Top" and elevatorObject.LuaObjectScript.GetState() ~= "Bottom"
    end)
    seq:Do(function()
      GameObjects.MoveToPoint_Son.LuaObjectScript.Disable()
    end)
    seq:Do(function()
      boolCarryAgainSeen = true
    end)
    seq:Do(function()
      GameObjects.MoveToPoint_Son.LuaObjectScript.Disable()
    end)
    seq:ActorSync(sonActor, {
      Branch = branchName,
      ReferenceJoint = "POI_CarryAgain_SynchJoint"
    })
    seq:WaitForActorPlayingMove(sonActor, "MOV_CarryAgain_Idle")
    seq:WaitForFunctionTrue(function()
      return elevatorObject.LuaObjectScript.GetState() == "Top" or elevatorObject.LuaObjectScript.GetState() == "Bottom"
    end)
    seq:Do(function()
      sonActor:GetCreature():TriggerMoveEvent("LE_CarryAgain_Exit")
    end)
    seq:WaitForActorFinishMove(sonActor, "MOV_CarryAgain_Exit")
    seq:StopPuppetingActor(sonActor)
    seq:StartSequence()
  end
end
