local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, freActor, sonActor, vinesObj0, vinesObj1, vinesObj2, vinesObj3
local boolIrritatingDwarf = false
local synchJoint = "IrritatingDwarf_SynchJoint"
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  if not boolIrritatingDwarf and game.Level.GetVariable("CompletedCineNumber") <= 190 then
    SetupActors()
    SetupVines()
  else
    HideVines()
  end
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {playedSetupBool = boolIrritatingDwarf}
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  boolIrritatingDwarf = savedInfo.playedSetupBool
end
function SetupActors()
  freActor = actor.Actor.New("IRRITATINGDWARF POI: Freya Actor", ND.FindFreya)
  sonActor = actor.Actor.New("IRRITATINGDWARF POI: Son Actor", game.AI.FindSon)
end
function SetupVines()
  vinesObj0 = GameObjects.freyaVinesProp0.Child
  vinesObj0:JumpAnimationToFrame(0, {
    Animation = "poiFootIrritatingDwarf020CineScene"
  })
  vinesObj0:PauseAnimation()
  vinesObj1 = GameObjects.freyaVinesProp1.Child
  vinesObj1:JumpAnimationToFrame(0, {
    Animation = "poiFootIrritatingDwarf020CineScene1"
  })
  vinesObj1:PauseAnimation()
  vinesObj2 = GameObjects.freyaVinesProp2.Child
  vinesObj2:JumpAnimationToFrame(0, {
    Animation = "poiFootIrritatingDwarf020CineScene2"
  })
  vinesObj2:PauseAnimation()
  vinesObj3 = GameObjects.freyaVinesProp3.Child
  vinesObj3:JumpAnimationToFrame(0, {
    Animation = "poiFootIrritatingDwarf020CineScene3"
  })
  vinesObj3:PauseAnimation()
end
function HideVines()
  GameObjects.freyaVinesProp0:Hide()
  GameObjects.freyaVinesProp1:Hide()
  GameObjects.freyaVinesProp2:Hide()
  GameObjects.freyaVinesProp3:Hide()
end
function SetupPOISeq()
  local player = game.Player.FindPlayer()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "IrritatingDwarf")
  local slaveTab = {
    {
      Actor = freActor,
      Branch = "BRA_IrritatingDwarf"
    },
    {
      Obj = vinesObj0,
      Anim = "poiFootIrritatingDwarf020CineScene"
    },
    {
      Obj = vinesObj1,
      Anim = "poiFootIrritatingDwarf020CineScene1"
    },
    {
      Obj = vinesObj2,
      Anim = "poiFootIrritatingDwarf020CineScene2"
    },
    {
      Obj = vinesObj3,
      Anim = "poiFootIrritatingDwarf020CineScene3"
    }
  }
  seq:Do(function()
    GameObjects.IrritatingDwarf_SpeedCtrlZone:ShowEntityVolume()
  end)
  seq:Do(function()
    GameObjects.GondolaPlatform_SpeedCtrlZone:ShowEntityVolume()
  end)
  seq:ActorForceApproachAndWait(freActor, {
    Branch = "BRA_IrritatingDwarfIdle",
    ReferenceJoint = synchJoint,
    speed = ND.FreyaWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = 1.3
  })
  seq:ActorSync(freActor, {
    Branch = "BRA_IrritatingDwarfIdle",
    ReferenceJoint = synchJoint
  })
  seq:Do(function()
    game.AI.FindSon():ClearAccelerationOverride()
  end)
  seq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_IrritatingDwarf",
    ReferenceJoint = synchJoint,
    speed = 3.8,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.RunArrivalRadius
  })
  seq:Do(function()
    game.Audio.PlayBanter("080_IrritatingDwarf")
  end)
  seq:ActorSync(sonActor, {
    Slaves = slaveTab,
    Branch = "BRA_IrritatingDwarf",
    ReferenceJoint = synchJoint
  })
  seq:Do(EnableSpecialGondolaSonContextAction)
  seq:Do(UpdateUpperLTWParams)
  seq:WaitForActorPuppeteerComplete(sonActor)
  seq:StopPuppetingActor(freActor)
  seq:StopPuppetingActor(sonActor)
  seq:Do(function()
    GameObjects.IrritatingDwarf_SpeedCtrlZone:HideEntityVolume()
  end)
  seq:Do(function()
    boolIrritatingDwarf = true
  end)
  seq:StartSequence()
end
function EnableSpecialGondolaSonContextAction()
  GameObjects.Gondola_Elevator:FindSingleGOByName("CA_SonIdle_FreyaLTW").LuaObjectScript.Enable()
end
function UpdateUpperLTWParams()
  local freLTWWad = game.FindLevel("FreyaLTW")
  if freLTWWad ~= nil then
    freLTWWad:CallScript("LTW_DownFoothills_UpdateParams")
  end
end
