local uiCalls = require("ui.uicalls")
local checkedShallNotPass = false
local son, cineNum
function OnStart(level)
  son = game.AI.FindSon()
  cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 65 then
    GameObjects.LTW_TempleInterior_Follow.LuaObjectScript.Disable()
    local availabilityState = {
      AvailableForSync = true,
      AvailableForBanter = true,
      AvailableInLevel = true,
      AvailableForCombat = false
    }
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  elseif 65 < cineNum then
    GameObjects.LTW_TempleInterior_Follow.LuaObjectScript.Enable()
  end
  if cineNum < 100 then
    GameObjects.CP_Retraversal:HideEntityVolume()
  else
    GameObjects.CP_Retraversal:ShowEntityVolume()
    GameObjects.ForestLeadTheWay.LuaObjectScript.Disable()
    GameObjects.ForestLeadTheWay_Follow.LuaObjectScript.Enable()
  end
  GameObjects.LTW_Exit_Alley:ShowEntityVolume()
end
function OnFirstStart(level)
  GameObjects.LTW_ChainClimb_Bottom:HideEntityVolume()
  GameObjects.LTW_LedgeDown:HideEntityVolume()
end
function OnUpdate()
  if checkedShallNotPass == false and game.Level.GetVariable("CompletedCineNumber") > 100 then
    checkedShallNotPass = true
    DisableNoPass()
  end
end
function For000_Bookmark_LeadTheWay()
  EnableLeadANDNoPass()
end
function DisableNoPass()
  GameObjects.ForestYouShallNotPass.LuaObjectScript.Disable()
  GameObjects.YouShallNotPass_DeerKill.LuaObjectScript.Disable()
  GameObjects.ShallNotPass_TempleInterior.LuaObjectScript.Disable()
end
function EnableNoPass()
  print("EnableNoPass")
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.ForestYouShallNotPass.LuaObjectScript.Enable()
  end
end
function HideSecondTracks_ShallNotPass()
  GameObjects.EnableLTW:HideEntityVolume()
end
function EnableLeadTheWay()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.ForestLeadTheWay.LuaObjectScript.Enable()
    GameObjects.LTW_TracksSupport.LuaObjectScript.Enable()
  else
    GameObjects.ForestLeadTheWay.LuaObjectScript.Disable()
    GameObjects.ForestLeadTheWay_Follow.LuaObjectScript.Enable()
  end
end
function DisableLeadTheWay()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.ForestLeadTheWay.LuaObjectScript.Disable()
    GameObjects.LTW_TracksSupport.LuaObjectScript.Disable()
    GameObjects.LTW_TempleInterior.LuaObjectScript.Disable()
  else
    GameObjects.LTW_TempleInterior_Follow.LuaObjectScript.Disable()
  end
end
function DisableLeadANDNoPass()
  GameObjects.ForestLeadTheWay.LuaObjectScript.Disable()
  GameObjects.LTW_TracksSupport.LuaObjectScript.Disable()
  GameObjects.ForestYouShallNotPass.LuaObjectScript.Disable()
end
function EnableLeadANDNoPass()
  print("EnableLeadANDNoPass")
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.ForestLeadTheWay.LuaObjectScript.Enable()
    GameObjects.LTW_TracksSupport.LuaObjectScript.Enable()
    GameObjects.ForestYouShallNotPass.LuaObjectScript.Enable()
  end
end
function For200_EnableLeadAndNoPassOnly()
  print("For200_EnableLeadAndNoPassOnly")
  if game.Level.GetVariable("CompletedCineNumber") == 20 then
    GameObjects.ForestLeadTheWay.LuaObjectScript.Enable()
  end
end
function ChainClimbed_Up()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.LTW_ChainClimb_Top:HideEntityVolume()
    GameObjects.LTW_ChainClimb_Bottom:ShowEntityVolume()
    GameObjects.LTW_LedgeDown:ShowEntityVolume()
  end
end
function ChainClimbed_Down()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.LTW_ChainClimb_Top:ShowEntityVolume()
    GameObjects.LTW_ChainClimb_Bottom:HideEntityVolume()
    GameObjects.LTW_LedgeDown:HideEntityVolume()
    EnterAlley()
  end
end
function Ledge_Down()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.LTW_ChainClimb_Top:ShowEntityVolume()
    GameObjects.LTW_ChainClimb_Bottom:HideEntityVolume()
    GameObjects.LTW_LedgeDown:HideEntityVolume()
    GameObjects.LTW_Alley.LuaObjectScript.Disable()
    GameObjects.LTW_TempleInterior.LuaObjectScript.Enable()
  else
    GameObjects.LTW_TempleInterior_Follow.LuaObjectScript.Enable()
  end
end
function BoatSpline_Enable()
  GameObjects.LTW_ToBoat.LuaObjectScript.Enable()
  if game.Level.GetVariable("CompletedCineNumber") < 65 then
    DisableNoPass()
  end
end
function BoatSpline_Disable()
  GameObjects.LTW_ToBoat.LuaObjectScript.Disable()
  if game.Level.GetVariable("CompletedCineNumber") < 65 then
    EnableNoPass()
  end
end
function EnterAlley()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    print("EnterAlley")
    GameObjects.ShallNotPass_TempleInterior.LuaObjectScript.Disable()
    GameObjects.LTW_Alley.LuaObjectScript.Enable()
    son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
  end
end
function ExitAlley()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.LTW_TempleInterior.LuaObjectScript.Enable()
    GameObjects.ShallNotPass_TempleInterior.LuaObjectScript.Enable()
    LTW_Update_TempleExterior()
    Disable_SlowDown()
    son:CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
  else
    GameObjects.LTW_TempleInterior_Follow.LuaObjectScript.Enable()
  end
end
function TempleShallNotPass_Enable()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.ShallNotPass_TempleInterior.LuaObjectScript.Enable()
  end
end
function TempleShallNotPass_Disable()
  GameObjects.ShallNotPass_TempleInterior.LuaObjectScript.Disable()
end
function Switch_ToRangeSpline()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.ForestLeadTheWay.LuaObjectScript.Disable()
    Enable_IntersectionLTW()
  end
end
function SwitchTo_TripleChest()
  son:CallScript("ClearBehaviorContext")
end
function SwitchTo_WolfPit()
  son:CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
end
function SwitchTo_TempleSpline()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.ForestLeadTheWay.LuaObjectScript.Disable()
    GameObjects.LTW_TripleChest.LuaObjectScript.Disable()
    GameObjects.LTW_WolfPit.LuaObjectScript.Disable()
    GameObjects.LTW_TempleInterior.LuaObjectScript.Enable()
  else
    GameObjects.LTW_TempleInterior_Follow.LuaObjectScript.Enable()
  end
end
function Disable_TempleSpline()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.LTW_TempleInterior.LuaObjectScript.Disable()
  else
    GameObjects.LTW_TempleInterior_Follow.LuaObjectScript.Disable()
  end
end
function SwitchTo_DeerKill()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.ForestLeadTheWay.LuaObjectScript.Disable()
    GameObjects.LTW_TripleChest.LuaObjectScript.Disable()
    GameObjects.LTW_WolfPit.LuaObjectScript.Disable()
    GameObjects.LTW_TempleInterior.LuaObjectScript.Enable()
    GameObjects.YouShallNotPass_DeerKill.LuaObjectScript.Enable()
  else
    GameObjects.LTW_TempleInterior_Follow.LuaObjectScript.Enable()
  end
end
function Disable_IntersectionLTW()
  GameObjects.LTW_TripleChest.LuaObjectScript.Disable()
  GameObjects.LTW_WolfPit.LuaObjectScript.Disable()
  GameObjects.ForestLeadTheWay.LuaObjectScript.Disable()
end
function Enable_IntersectionLTW()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.LTW_TripleChest.LuaObjectScript.Enable()
    GameObjects.LTW_WolfPit.LuaObjectScript.Enable()
    GameObjects.ForestLeadTheWay.LuaObjectScript.Enable()
  end
end
function Idle_Context_LeadTheWay()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.ForestYouShallNotPass.LuaObjectScript.Disable()
    son:CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
  end
end
function Disable_SlowDown()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    son:CallScript("LuaHook_ToggleSlowdownStops", false)
  end
end
function Enable_SlowDown()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    son:CallScript("LuaHook_ToggleSlowdownStops", true)
  end
end
function LTW_Update_Default()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    local defaultParams = {}
    defaultParams = {
      Speed = 4,
      LeaderDistance_Wait = 12,
      LeaderDistance_Continue = 8,
      LeaderDistance_Backtrack = 18,
      LeaderDistance_BacktrackDone = 14
    }
    GameObjects.ForestLeadTheWay.Child.LuaObjectScript.UpdateLeadTheWayParams(defaultParams)
  end
end
function LTW_Update_Intro()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    local introParams = {}
    introParams = {
      Speed = 4,
      LeaderDistance_Wait = 10,
      LeaderDistance_Continue = 6,
      LeaderDistance_Backtrack = 18,
      LeaderDistance_BacktrackDone = 14
    }
    GameObjects.ForestLeadTheWay.Child.LuaObjectScript.UpdateLeadTheWayParams(introParams)
  end
end
function LTW_Update_DeerTracks()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    local tracksParams = {}
    tracksParams = {
      Speed = 4,
      LeaderDistance_Wait = 13,
      LeaderDistance_Continue = 10,
      LeaderDistance_Backtrack = 24,
      LeaderDistance_BacktrackDone = 16
    }
    GameObjects.ForestLeadTheWay.Child.LuaObjectScript.UpdateLeadTheWayParams(tracksParams)
  end
end
function LTW_Update_DeerIntro()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    local introParams = {}
    introParams = {
      Speed = 3.7,
      LeaderDistance_Wait = 16,
      LeaderDistance_Continue = 12,
      LeaderDistance_Backtrack = 20,
      LeaderDistance_BacktrackDone = 14
    }
    GameObjects.ForestLeadTheWay.Child.LuaObjectScript.UpdateLeadTheWayParams(introParams)
  end
end
function LTW_Update_GapJump()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    local gapJumpParams = {}
    gapJumpParams = {
      Speed = 4.5,
      LeaderDistance_Wait = 16,
      LeaderDistance_Continue = 12,
      LeaderDistance_Backtrack = 18,
      LeaderDistance_BacktrackDone = 15
    }
    GameObjects.ForestLeadTheWay.Child.LuaObjectScript.UpdateLeadTheWayParams(gapJumpParams)
  end
end
function LTW_Update_AxeTutorial()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    local templeParams = {}
    templeParams = {
      Speed = 4.5,
      LeaderDistance_Wait = 50,
      LeaderDistance_Continue = 40,
      LeaderDistance_Backtrack = 60,
      LeaderDistance_BacktrackDone = 55
    }
    GameObjects.ForestLeadTheWay.Child.LuaObjectScript.UpdateLeadTheWayParams(templeParams)
  end
end
function LTW_Update_TripleChest()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    local tripleChestParams = {}
    tripleChestParams = {
      Speed = 4,
      LeaderDistance_Wait = 14,
      LeaderDistance_Continue = 8,
      LeaderDistance_Backtrack = 18,
      LeaderDistance_BacktrackDone = 11
    }
    GameObjects.LTW_TripleChest.Child.LuaObjectScript.UpdateLeadTheWayParams(tripleChestParams)
  end
end
function LTW_Update_TempleExterior()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    local templeParams = {}
    templeParams = {
      Speed = 4.25,
      LeaderDistance_Wait = 12,
      LeaderDistance_Continue = 8,
      LeaderDistance_Backtrack = 18,
      LeaderDistance_BacktrackDone = 12
    }
    GameObjects.LTW_TempleInterior.Child.LuaObjectScript.UpdateLeadTheWayParams(templeParams)
  end
end
function RemindQuestHome()
  local questState = game.QuestManager.GetQuestState("Quest_Forest_Objective800")
  if questState == "Active" then
    uiCalls.UI_Event_SendMsgToQuestLog({
      Category = 10250,
      Header = 4616,
      Body = 5349,
      MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
      Quest = "Quest_Forest_Objective800"
    })
  end
end
function LoadCheck_250()
  game.UI.LoadCheck("For250_ChiselSite", "For200_House")
end
function LoadCheck_650()
  game.UI.LoadCheck("For650_Bridge", "For666_LoadingDoor")
end
function LoadCheck_660()
  game.UI.LoadCheck("For660_TempleInterior", "For700_DeerKill", "For666_LoadingDoor")
end
function LoadCheck_400()
  game.UI.LoadCheck("For400_Intersection", "For101_RiverToHouse", "For550_BrokenForest")
end
function LoadCheck_Backyard()
  if game.Level.GetVariable("CompletedCineNumber") > 380 then
    game.UI.LoadCheck("For400_Intersection", "For101_RiverToHouse", "For200_c620_Epilogue")
  end
end
function LoadCheck_Dock()
  game.UI.LoadCheck("For200_House")
end
function LoadCheck_400Start()
  game.UI.LoadCheck("For200_House", "For500_ForestEntry")
end
function LoadCheck_350()
  game.UI.LoadCheck("For350_ExitTunnel")
end
function LoadCheck_800()
  game.UI.LoadCheck("For800_TrollArena", "For810_TrollArenaExit")
end
function LoadCheck_900()
  game.UI.LoadCheck("For900_ExitClimb", "For910_StaveVista", "For950_RiverPassLH")
end
function LoadCheck_Riv85()
  game.UI.LoadCheck("Riv085_DangersEntranceLH", "Riv100_DangersEntrance", "Riv000_Sky", "Riv000_Sound")
end
