local checkpoint = require("level.checkpoint")
local thisObj, player, pad, inputMaskPhase
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  pad = player.Pad
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") >= 10 and game.Level.GetVariable("CompletedCineNumber") < 65 then
    SetCustomInputMask()
  end
end
function OnUpdate(level, obj)
  SetCustomInputMask()
end
function SetCustomInputMask()
  local varNGP = game.GetNewGamePlus()
  if pad.DisableGameButton and pad.EnableGameButton then
    if inputMaskPhase == 0 then
      pad:DisableGameButton(tweaks.ePad.kPadSquare)
      pad:DisableGameButton(tweaks.ePad.kPadTriangle)
      pad:DisableGameButton(tweaks.ePad.kPadCross)
      pad:DisableGameButton(tweaks.ePad.kPadUp)
      pad:DisableGameButton(tweaks.ePad.kPadLeft)
      pad:DisableGameButton(tweaks.ePad.kPadDown)
      pad:DisableGameButton(tweaks.ePad.kPadRight)
      pad:DisableGameButton(tweaks.ePad.kPadL1)
      pad:DisableGameButton(tweaks.ePad.kPadL2)
      pad:DisableGameButton(tweaks.ePad.kPadL3)
      pad:DisableGameButton(tweaks.ePad.kPadR1)
      pad:DisableGameButton(tweaks.ePad.kPadR2)
      game.SubObject.Sleep(thisObj)
    elseif inputMaskPhase == 3 then
      pad:EnableGameButton(tweaks.ePad.kPadTriangle)
      pad:DisableGameButton(tweaks.ePad.kPadRight)
      pad:DisableGameButton(tweaks.ePad.kPadL2)
      pad:DisableGameButton(tweaks.ePad.kPadR1)
      pad:DisableGameButton(tweaks.ePad.kPadR2)
      pad:DisableGameButton(tweaks.ePad.kPadL3)
      pad:DisableGameButton(tweaks.ePad.kPadDown)
      if player:GetCurrentWeapon() == "Axe" then
        inputMaskPhase = 0
      end
    elseif inputMaskPhase == 4 then
      pad:EnableGameButton(tweaks.ePad.kPadR1)
      pad:EnableGameButton(tweaks.ePad.kPadR2)
      pad:EnableGameButton(tweaks.ePad.kPadL2)
      pad:EnableGameButton(tweaks.ePad.kPadL1)
      pad:EnableGameButton(tweaks.ePad.kPadCross)
      pad:EnableGameButton(tweaks.ePad.kPadRight)
      pad:EnableGameButton(tweaks.ePad.kPadTriangle)
      pad:EnableGameButton(tweaks.ePad.kPadSquare)
      if varNGP == true then
        pad:EnableGameButton(tweaks.ePad.kPadL3)
        pad:EnableGameButton(tweaks.ePad.kPadLeft)
      else
        pad:DisableGameButton(tweaks.ePad.kPadL3)
      end
      pad:DisableGameButton(tweaks.ePad.kPadDown)
    elseif inputMaskPhase == 6 then
      pad:EnableGameButton(tweaks.ePad.kPadL1)
      pad:EnableGameButton(tweaks.ePad.kPadCross)
      pad:EnableGameButton(tweaks.ePad.kPadR1)
      pad:EnableGameButton(tweaks.ePad.kPadR2)
      pad:EnableGameButton(tweaks.ePad.kPadL2)
      pad:EnableGameButton(tweaks.ePad.kPadRight)
      pad:EnableGameButton(tweaks.ePad.kPadR3)
      pad:EnableGameButton(tweaks.ePad.kPadSquare)
      pad:DisableGameButton(tweaks.ePad.kPadUp)
      if varNGP == true then
        pad:EnableGameButton(tweaks.ePad.kPadL3)
        pad:EnableGameButton(tweaks.ePad.kPadLeft)
      else
        pad:DisableGameButton(tweaks.ePad.kPadLeft)
      end
      pad:DisableGameButton(tweaks.ePad.kPadDown)
      pad:DisableGameButton(tweaks.ePad.kPadL3)
    end
  end
end
function AxtTut_Step_0()
  game.SubObject.Sleep(thisObj)
  inputMaskPhase = 0
  SetCustomInputMask()
end
function AxtTut_Step_3()
  game.SubObject.Wake(thisObj)
  inputMaskPhase = 3
  SetCustomInputMask()
end
function Melee_Step_1()
  inputMaskPhase = 4
  SetCustomInputMask()
end
function Melee_Step_3()
  inputMaskPhase = 6
  SetCustomInputMask()
end
function ClearInputMask()
  if pad.ClearAllDisabledGameButtons then
    inputMaskPhase = nil
    pad:ClearAllDisabledGameButtons()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {
    levelstate = checkpoint.Save(),
    inputMaskPhase = inputMaskPhase
  }
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  inputMaskPhase = savedInfo.inputMaskPhase
end
