local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local player, son, zoneMonitorRope, zoneMonitorHouseIn, zoneMonitorHouseOut, zoneMonitorTrack1, zoneMonitorTrack2, zoneMonitorBoatMusic, houseDoor, playerPosition, interactPosition, toInteract, interactFwd
local playingtrack1Music = false
local playingtrack2Music = false
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  zoneMonitorHouseIn = monitors.CreateEntityZoneMonitor(player, GameObjects.SNDGrpZoneIn)
  zoneMonitorHouseIn:OnEnter(SetStateHouseIn)
  zoneMonitorHouseOut = monitors.CreateEntityZoneMonitor(player, GameObjects.SNDGrpZoneOut)
  zoneMonitorHouseOut:OnEnter(SetStateHouseOut)
  SoundInit()
  zoneMonitorTrack1 = monitors.CreateEntityZoneMonitor(son, GameObjects.SNDGrpZnTracks1)
  zoneMonitorTrack2 = monitors.CreateEntityZoneMonitor(son, GameObjects.SNDGrpZnTracks2)
  game.Audio.StartMusicMaster("SND_MX_PRO_start_master")
end
function OnFirstStart(level)
  BoatMusicZoneReady()
end
function OnStart(level)
  ValidateRedStormState()
end
function OnUpdate(level)
  if son:IsInsideEntityZone("SNDGrpZnTracks1") and son:IsPlayingMove("MOV_poiForFirstTracks") and playingtrack1Music == false then
    playingtrack1Music = true
    SonTrack1Music()
  end
  if son:IsInsideEntityZone("SNDGrpZnTracks2") and son:IsPlayingMove("MOV_poiForSecondTracks") and playingtrack2Music == false then
    playingtrack2Music = true
    SonTrack2Music()
  end
end
function OnUseWorld(level)
  UpdateVectorData()
end
function UpdateVectorData()
  local for200 = game.FindLevel("For200_House")
  if for200 then
    houseDoor = for200:FindSingleGameObject("kratoshousedoor")
    playerPosition = player:GetWorldPosition()
    interactPosition = houseDoor:GetWorldPosition()
    toInteract = interactPosition - playerPosition
    interactFwd = houseDoor:GetWorldForward()
  end
end
function SonTrack1Music()
  game.Audio.StartMusic("SND_MX_PRO_hunt_footprints_1")
  zoneMonitorTrack1:Stop()
end
function SonTrack2Music()
  game.Audio.StartMusic("SND_MX_PRO_hunt_footprints_4")
  zoneMonitorTrack2:Stop()
end
function BoatMusicZoneReady()
  zoneMonitorBoatMusic = monitors.CreateEntityZoneMonitor(player, GameObjects.SNDGrpEntZnRiver)
  zoneMonitorBoatMusic:OnEnter(BoatInZoneMusic)
end
function BoatInZoneMusic()
  game.Audio.StartMusic("SND_MX_PRO_boat_river")
  zoneMonitorBoatMusic:Stop()
end
local SNDHouseIntZn, SNDBackyardZn, SNDHouseSideZn, SNDHouseIntStormZn, SNDBackyardStormZn, SNDHouseSideStormZn, SNDZnCourtyard, SNDZnAfterWater, SNDAfterWaterStormZn, SNDCourtyardStormZn, SNDWildlife, SNDBackyardToHouseIntPortal, SNDWaterToBackyardPortal
local treeEmitters = {}
local SNDGlbOut, SNDGlbIn
local playerIsInside = false
local spireMusic = false
function SoundInit()
  SNDGlbOut = GameObjects.SNDGrpGlbOut.SoundEmitters[1]
  SNDGlbIn = GameObjects.SNDGrpGlbIn.SoundEmitters[1]
  SNDWildlife = GameObjects.SNDGrpWildlife:FindSingleSoundEmitterByName("SNDWildlife")
  LD.PlaySound(SNDGlbOut, "SND_GLB_Exterior")
  LD.StopSound(SNDGlbIn, "SND_GLB_Interior")
end
function InitializeTreeEmitters()
  local soundEmitters = GameObjects.SNDForest200TreeEmitters.SoundEmitters
  for i = 1, #soundEmitters do
    table.insert(treeEmitters, {
      soundEmitters[i],
      "SND_AMB_EMIT_FOL_Tree_Leaves_LP_For200",
      "SND_AMB_Emit_RedStorm_Trees_LP"
    })
  end
end
function SetStateHouseIn()
  if toInteract == nil then
    UpdateVectorData()
  end
  if toInteract:Dot(interactFwd) > 0 then
    print("Turning off SND_GLB_Exterior and turning on SND_GLB_Interior")
    LD.PlaySound(SNDGlbIn, "SND_GLB_Interior")
    LD.StopSound(SNDGlbOut, "SND_GLB_Exterior")
  end
end
function SetStateHouseOut()
  if toInteract == nil then
    UpdateVectorData()
  end
  if toInteract:Dot(interactFwd) < 0 then
    print("Turning off SND_GLB_Interior and turning on SND_GLB_Exterior")
    LD.PlaySound(SNDGlbOut, "SND_GLB_Exterior")
    LD.StopSound(SNDGlbIn, "SND_GLB_Interior")
  end
end
function LuaHook_SetStateHouseIn()
end
function LuaHook_SetStateHouseOut()
end
function spireEnterMusic()
  if spireMusic == true then
    game.Audio.StartCheckpointedMusic("SND_MX_PRO_ruins_explore_in")
    spireMusic = false
  end
end
function spireMusVarChange()
  spireMusic = true
end
function exitClimbMusic()
  game.Audio.StartCheckpointedMusic("SND_MX_PRO_climb_to_vista")
end
function ValidateRedStormState()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 365 <= cineNumber and cineNumber < 390 then
    EnableRedStormState()
  else
    DisableRedStormState()
  end
end
function EnableRedStormState()
  game.Audio.SetWwiseState("Red_Storm", "Active")
end
function DisableRedStormState()
  game.Audio.SetWwiseState("Red_Storm", "Inactive")
end
function wildlifeSounds()
  LD.PlaySound(SNDWildlife, "SND_AMB_EMTI_Wildlife_One_Shot_For200")
end
function revisitMusic()
end
function musicRevisitOut()
  if game.Level.GetVariable("CompletedCineNumber") >= 400 then
    game.Audio.StartMusic("SND_MX_TRANS_TO_IDLE")
  end
end
function musicRevisitIn()
  if game.Level.GetVariable("CompletedCineNumber") >= 400 then
    game.Audio.StartCheckpointedMusic("SND_MX_PRO_revisit_explore_in")
  end
end
