local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local timer = require("level.timer")
thisLevel = nil
player = nil
son = nil
InitialZone = nil
BoatZone = nil
zoneMonitor2 = nil
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  BoatZone = GameObjects.entityZone02
  zoneMonitor2 = monitors.CreateEntityZoneMonitor(player, BoatZone)
  zoneMonitor2:SetTriggerCountLimit(1)
  zoneMonitor2:OnEnter(ShowBoatTutorialMsg)
  game.Compass.SetGatewayMarkerIsOpen("FOR_100_COMPASS_HELPER_DOCK", true)
end
function OnFirstStart(level)
  HideBoatRope()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    player:PickupAcquire("ForceRageModeDisabled")
  end
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") > 20 then
    GameObjects.BoatRope:Hide()
  end
end
function StartQuest_Boat2House()
  LD.ActivateQuest("Quest_Forest_Parent01")
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
end
function ShowBoatRope()
  GameObjects.BoatRope_Root:ShowModel()
end
function HideBoatRope()
  GameObjects.BoatRope_Root:HideModel()
end
function FinishBoatRope()
  HideBoatRope()
end
function UnparentLanternAndRope()
  GameObjects.BoatRope_Main:Unparent()
end
function AttachBoatRopeToVehicle(vehicle)
  local geo = vehicle:FindSingleGOByName("boat00_Midgard").Child
  geo:AddChild(GameObjects.BoatRope.Child, geo:GetJointIndex("ropeAttach"), 1)
end
function ShowBoatTutorialMsg()
  timer.StartLevelTimer(8.25, function()
    TUT.BoatSteering_Tutorial()
  end)
end
function RemoveBoatBanter()
  uiCalls.UI_Event_TurnOffTutorialMessage()
end
function StopSad()
end
function OnNewGame()
  GameObjects.Cine_Opening.LuaObjectScript.NewGameSelected()
end
function OnContinue()
  GameObjects.Cine_Opening.LuaObjectScript.ContinueSelected()
end
