local player, completedCineNumber
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  game.Compass.SetGatewayMarkerIsOpen("FOR_101_COMPASS_HELPER_DOCK", true)
  completedCineNumber = game.Level.GetVariable("CompletedCineNumber")
end
function OnStart(level)
  completedCineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 100 < completedCineNumber then
    if player:PickupIsAcquired("ForceRageModeDisabled") then
      player:PickupRelinquish("ForceRageModeDisabled")
    end
  elseif completedCineNumber < 15 then
    GameObjects.BoatDockArted1.LuaObjectScript.HasDiscoveredDock()
  end
end
function OnUpdate(level)
  completedCineNumber = game.Level.GetVariable("CompletedCineNumber")
  if completedCineNumber < 13 and player:HasMarker("Moving") and game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_LogCarry_Forced_010*") then
    game.Camera.SubmitCameraByName("PLYR_NarrativeCarry_Log_010")
  end
  if completedCineNumber < 15 and player:IsInVehicle() == true and game.World.IsInsideCameraZone(player.WorldPosition, "CamBoatZone_IntroTunnel*") then
    game.Camera.SubmitCameraByName("PLYR_Boat_Log_Sequence")
  end
  if completedCineNumber < 20 then
    if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_LogCarry_Forced_020*") then
      game.Camera.SubmitCameraByName("PLYR_NarrativeCarry_Log_020")
    end
    if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_LogCarry_Forced_030*") then
      game.Camera.SubmitCameraByName("PLYR_NarrativeCarry_Log_030")
    end
  end
end
function ResetBoatSpeed()
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
end
function OnEvaluateLoadGroup_Cinematic()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 20 then
    return "MothersKnifeCine"
  elseif cineNum < 72 and 20 <= cineNum then
    return "NoCine_BeforeBaldur"
  elseif cineNum < 78 and 72 <= cineNum then
    return "AshesGatheredCine"
  elseif cineNum < 80 and 78 <= cineNum then
    return "BaldurIntroCine"
  elseif cineNum < 100 and 80 <= cineNum then
    return "TimeToGoCine"
  elseif cineNum < 370 and 100 <= cineNum then
    return "NoCine_AfterBaldur"
  elseif cineNum <= 380 and 370 <= cineNum then
    return "RetrieveBladesCine"
  elseif 380 <= cineNum then
    return "EpilogueCine"
  end
end
function OnEvaluateLoadGroup_Cinematic_Alt()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 20 then
    return "MothersKnifeCine"
  elseif cineNum < 72 and 20 <= cineNum then
    return "NoCine_BeforeBaldur"
  elseif cineNum < 78 and 72 <= cineNum then
    return "AshesGatheredCine"
  elseif cineNum < 80 and 78 <= cineNum then
    return "BaldurIntroCine"
  elseif cineNum < 100 and 80 <= cineNum then
    return "TimeToGoCine"
  elseif cineNum < 370 and 100 <= cineNum then
    return "NoCine_AfterBaldur"
  elseif cineNum <= 380 and 370 <= cineNum then
    return "RetrieveBladesCine"
  elseif 380 <= cineNum then
    return "EpilogueCine"
  end
end
