local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local monitors = require("level.MonitorLibrary")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, kratosActor, sonActor, logActor, boatActor, boatNoose, boatRope30, boatRope31, boatRope32, cineEnterLogBoatExitCam
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  InitializeProps()
end
function OnUpdate(level, obj)
  if cineEnterLogBoatExitCam ~= nil then
    cineEnterLogBoatExitCam:Update()
  end
end
function DisableBoatToHouseLTW()
  GameObjects.LTW_BoatToHouse.LuaObjectScript.Disable()
  GameObjects.CA_Idle_PreMothersKnife.LuaObjectScript.Disable()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function InitializeProps()
  boatNoose = GameObjects.boatNoose00Top2.Child
  boatRope30 = GameObjects.boatRope30Top.Child
  boatRope31 = GameObjects.boatRope31.Child
  boatRope32 = GameObjects.boatRope32.Child
  boatNoose:StartAnim("narForLogBoatExit000CineScene")
  boatRope30:StartAnim("narForLogBoatExit000CineScene")
  boatRope31:StartAnim("narForLogBoatExit000CineScene1")
  boatRope32:StartAnim("narForLogBoatExit000CineScene2")
  boatNoose:JumpAnimToFrame(0)
  boatRope30:JumpAnimToFrame(0)
  boatRope31:JumpAnimToFrame(0)
  boatRope32:JumpAnimToFrame(0)
  boatNoose:PauseAnim()
  boatRope30:PauseAnim()
  boatRope31:PauseAnim()
  boatRope32:PauseAnim()
  HideProps()
end
function HideProps()
  boatNoose:Hide()
  boatRope30:Hide()
  boatRope31:Hide()
  boatRope32:Hide()
end
function ShowProps()
  boatNoose:Show()
  boatRope30:Show()
  boatRope31:Show()
  boatRope32:Show()
end
function SetupActors()
  kratosActor = actor.Actor.New("LOG BOAT EXIT - KRATOS", game.Player.FindPlayer)
  sonActor = actor.Actor.New("LOG BOAT EXIT - SON", game.AI.FindSon)
  logActor = actor.Actor.New("LOG BOAT EXIT - LOG")
  boatActor = actor.Actor.New("LOG BOAT EXIT - BOAT", game.Boat.GetPlayerBoat)
end
function SetSpawnFunctions()
  logActor:SetSpawnFunction(function()
    return game.AI.Spawn(thisLevel, engine.Vector.New(-280, 38, -736), engine.Vector.New(1, 0, 0), "CRT_Log00")
  end)
end
function CheckCineNumber()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 15 then
    GameObjects.BoatDockArted1.Child.LuaObjectScript.EnableCinematicTrigger()
  end
end
function PlayLogBoatExit()
  local boat = game.Boat.GetPlayerBoat()
  game.Boat.ClearOverrideSpeedControlData(boat)
  SetupActors()
  SetSpawnFunctions()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Log Boat Exit Sequence")
  local logBoatExit_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_LogBoatExit"
    },
    {
      Actor = kratosActor,
      Branch = "BRA_LogBoatExit"
    },
    {
      Actor = logActor,
      Branch = "BRA_LogBoatExit"
    },
    {
      Obj = boatNoose,
      Anim = "narForLogBoatExit000CineScene"
    },
    {
      Obj = boatRope30,
      Anim = "narForLogBoatExit000CineScene"
    },
    {
      Obj = boatRope31,
      Anim = "narForLogBoatExit000CineScene1"
    },
    {
      Obj = boatRope32,
      Anim = "narForLogBoatExit000CineScene2"
    }
  }
  cineSeq:Do(function()
    GameObjects.DeathPlane:HideCollision()
  end)
  cineSeq:Do(function()
    game.AI.FindSon():CallScript("EnterBehaviorContext", "SAD_BEHAVIOR_CONTEXT_CONFIG")
  end)
  cineSeq:SpawnActorAndWait(logActor)
  cineSeq:RequestCineModeAndWait(kratosActor, thisObj)
  cineSeq:ActorSync(boatActor, {
    Slaves = logBoatExit_ActorTable,
    Branch = "BRA_LogBoatExit",
    ReferenceJoint = "LogBoatExit_SynchJoint"
  })
  EnableStickInput()
  cineSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.08)
  cineSeq:Do(ShowProps)
  cineSeq:Do(HideBoatRope)
  cineSeq:Do(EnableLeadTheWay_ToHouse)
  cineSeq:Do(function()
    GameObjects.LogCarry_PlayerNavCurve.LuaObjectScript.Enable()
  end)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.3)
  cineSeq:Do(UnparentLanternAndRope)
  cineSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StopPuppetingActor(logActor)
  cineSeq:StopPuppetingActor(boatActor)
  cineSeq:Do(function()
    GameObjects.BoatDockArted1.LuaObjectScript.Disable()
  end)
  cineSeq:Do(RemoveBoatMarkers)
  cineSeq:Do(function()
    GameObjects.DeathPlane:ShowCollision()
  end)
  cineSeq:Do(HideProps)
  cineSeq:SetCompletedCineNumber(15)
  cineSeq:StartSequence()
end
function HideBoatRope()
  local For100 = game.FindLevel("For100_River")
  For100:CallScript("FinishBoatRope")
end
function UnparentLanternAndRope()
  local For100 = game.FindLevel("For100_River")
  For100:CallScript("UnparentLanternAndRope")
end
function RemoveBoatMarkers()
  game.Player.FindPlayer():RemoveMarker("logDock")
  game.AI.FindSon():RemoveMarker("logDock")
end
function EnableLeadTheWay_ToHouse()
  GameObjects.LTW_BoatToHouse.LuaObjectScript.Enable()
  GameObjects.CA_Idle_PreMothersKnife.LuaObjectScript.Enable()
end
function DisableStickInput()
  local pad = game.Player.FindPlayer().Pad
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickY)
  if game.Boat.EnableIsLimitedRotationControlModeAutoRotating then
    local boat = game.Boat.GetPlayerBoat()
    local data = {}
    data.AutoRotationLinearSpeedThreshold = 1
    data.AutoRotationLinearAccelerationSlow = 0.75
    data.AutoRotationAngularAccelerationSlow = 27.5
    data.AutoRotationLinearAccelerationFast = 0
    data.AutoRotationAngularAccelerationFast = 90
    game.Boat.EnableIsLimitedRotationControlModeAutoRotating(boat, data)
  end
end
function EnableStickInput()
  local pad = game.Player.FindPlayer().Pad
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickY)
end
function CameraStartLogBoatExit()
  game.SubObject.Wake(thisObj)
  cineEnterLogBoatExitCam = CCEC.CineEnterCamera.New("ENV_CineEnter_narForLogBoatExit000CineScene", 8)
  cineEnterLogBoatExitCam:SetCallback(CameraDestroyLogBoatExit)
  cineEnterLogBoatExitCam:Start()
end
function CameraDestroyLogBoatExit()
  cineEnterLogBoatExitCam = nil
  game.SubObject.Sleep(thisObj)
end
