local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local thisLevel, player, Area_0_Encounter_1, Area_0_Encounter_2, Area_1_Encounter_1, Helwalker_Fight_Start, Helwalker_Fight_Wave3, Helwalker_Rise, Helwalker_Rise2, Area_2_Encounter_1
PreBladesFight01Complete = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  Bandit_BoatRide1()
  Bandit_BoatRide2()
  Bandit_Ambush()
  Post_Blades_Fight()
end
function OnStart(level)
  if Area_2_Encounter_1 and Area_2_Encounter_1:WasRunning() then
    Area_2_Encounter_1:Start()
  end
end
function Bandit_BoatRide1()
  Area_0_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]Fake Bandits Boat Ride 1", {CheckpointOnComplete = false})
  Area_0_Encounter_1:AddWave({
    {
      spawners = "Bandit_S_BOAT1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_S_BOAT2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.5
    },
    {
      spawners = "Bandit_S_BOAT3",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    }
  })
  Area_0_Encounter_1:SetStartZone(GameObjects.EntZn_HelwalkerBoat1)
  Area_0_Encounter_1:OnStart(function()
    timers.StartLevelTimer(48, function()
      Area_0_Encounter_1:DespawnEnemies()
      Area_0_Encounter_1:SetComplete()
    end)
  end)
end
function Bandit_BoatRide2()
  Area_0_Encounter_2 = EC.NewEncounter(thisLevel, "[Area 1]Fake Bandits Boat Ride 2", {CheckpointOnComplete = false})
  Area_0_Encounter_2:AddWave({
    {
      spawners = "Bandit_S_BOAT4",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_S_BOAT5",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.8
    },
    {
      spawners = "Bandit_S_BOAT6",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10
    }
  })
  Area_0_Encounter_2:SetStartZone(GameObjects.EntZn_HelwalkerBoat2)
  Area_0_Encounter_2:OnStart(function()
    timers.StartLevelTimer(17, function()
      Area_0_Encounter_2:DespawnEnemies()
      Area_0_Encounter_2:SetComplete()
    end)
  end)
end
function Bandit_Ambush()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]Bandit Ambush", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_PRO_house_return_fight_in",
    StopMusic = "SND_MX_PRO_house_return_fight_out"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "H_Bandit_S_SPRINT",
      spawnLocators = "A1_A_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "Bandit_S_SPRINT",
      spawnLocators = "A1_B_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Lvl2_Bandit_S_SPRINT",
      spawnLocators = "A1_B_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Lvl2_H_Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    }
  })
  Area_1_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {7, 40},
    {
      spawners = "Lvl2_Bandit_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.7
    }
  })
  Area_1_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {7, 40},
    {
      spawners = "H_Bandit_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Lvl2_Bandit_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    }
  })
  Area_1_Encounter_1:SetStartZone(GameObjects.EntZn_HelwalkerAmbush)
  Area_1_Encounter_1:OnStart(function()
    game.World.StoreCheckpoint()
    game.Compass.SetDesignerForcedHide(true)
  end)
  Area_1_Encounter_1:OnComplete(PreBladesFightComplete)
  Helwalker_Fight_Start = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_HelwalkerFight)
  Helwalker_Fight_Start:OnEnter(function()
    Area_1_Encounter_1:StartWave(2)
  end)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(3)
  end, {count = 2})
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(4)
  end, {count = 4})
end
function Post_Blades_Fight()
  Area_2_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]Post Blades Fight", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_PRO_got_blades_fight_in",
    StopMusic = "SND_MX_PRO_got_blades_fight_out"
  })
  Area_2_Encounter_1:AddWave({
    timeBeforeNextWave = 0.1,
    {
      spawners = "Bandit_S_Patrol_A",
      spawnLocators = "A2_D_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_S_Patrol_B",
      spawnLocators = "A2_D_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_S_Patrol_D",
      spawnLocators = "A2_D_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_S_Patrol_E",
      spawnLocators = "A2_D_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_S_Patrol_F",
      spawnLocators = "A2_D_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_2_Encounter_1:AddWave({
    {
      spawners = "Bandit_S_DEAD1",
      spawnLocators = "A2_E_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    },
    {
      spawners = "Bandit_S_DEAD3",
      spawnLocators = "A2_E_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.1
    }
  })
  Area_2_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {5, 40},
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    }
  })
  Area_2_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {5, 40},
    {
      spawners = "Lvl2_H_Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "H_Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    }
  })
  Area_2_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {5, 40},
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    },
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.7
    }
  })
  Area_2_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {5, 40},
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    },
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.7
    }
  })
  Area_2_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {5, 40},
    {
      spawners = "H_Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.5
    },
    {
      spawners = "Bandit_A_S_VAULT",
      spawnLocators = "A2_B_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.7
    }
  })
  Area_2_Encounter_1:OnStart(function()
    game.Compass.SetDesignerForcedHide(true)
    game.FindLevel("For200_House"):CallScript("DisableFT")
    Helwalker_Rise = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_HelwalkerBlades)
    Helwalker_Rise:OnEnter(function()
      timers.StartLevelTimer(1.1, function()
        Area_2_Encounter_1:AlertEnemies(1)
      end)
    end)
    Helwalker_Rise2 = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_HelwalkerBlades)
    Helwalker_Rise2:OnEnter(function()
      timers.StartLevelTimer(0.7, function()
        Area_2_Encounter_1:AlertEnemies(1)
      end)
      timers.StartLevelTimer(1.8, function()
        Area_2_Encounter_1:AlertEnemies(2)
      end)
    end)
  end)
  Area_2_Encounter_1:OnComplete(function()
    PostBladesFightComplete()
    if Helwalker_Rise2 ~= nil then
      Helwalker_Rise2:Stop()
      Helwalker_Rise2 = nil
    end
    if Helwalker_Rise ~= nil then
      Helwalker_Rise:Stop()
      Helwalker_Rise = nil
    end
  end)
  Area_2_Encounter_1:OnEnemyDeath(function()
    Area_2_Encounter_1:StartWave(3)
  end, {count = 2})
  Area_2_Encounter_1:OnEnemyDeath(function()
    Area_2_Encounter_1:StartWave(4)
  end, {count = 4})
  Area_2_Encounter_1:OnEnemyDeath(function()
    Area_2_Encounter_1:StartWave(5)
  end, {count = 6})
  Area_2_Encounter_1:OnEnemyDeath(function()
    Area_2_Encounter_1:StartWave(6)
  end, {count = 9})
  Area_2_Encounter_1:OnEnemyDeath(function()
    Area_2_Encounter_1:StartWave(7)
  end, {count = 13})
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function PreBladesFightComplete()
  game.Compass.SetDesignerForcedHide(false)
  PreBladesFight01Complete = true
  local for200 = game.FindLevel("For200_House")
  local cineObj
  cineObj = for200:FindSingleGameObject("Cine_RetrieveBlades")
  cineObj:CallScript("EnableDoor")
end
function PostBladesFightComplete()
  AwardTrophy()
  GameObjects.EntZn_HelwalkerBlades:Hide()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("020_BurnablesIntro", FastTravel_And_Compass_On)
  end, 3)
  local uiCalls = require("ui.uicalls")
  LD.CallFunctionAfterDelay(function()
    uiCalls.SendBottomDesignerMessage({Text = 40956, DisplayTime = 9})
  end, 6)
end
function FastTravel_And_Compass_On()
  game.FindLevel("For200_House"):CallScript("ReEnableFT")
  game.Compass.SetDesignerForcedHide(false)
  LD.CompleteQuest("Quest_Caldera_Objective340")
  LD.GiveFastTravelStageOne()
  game.World.StoreCheckpoint()
end
function Helwalkers_Meet_Blades()
  Area_2_Encounter_1:Start()
end
function AwardTrophy()
  print("Trophy Awarded: Hello, Old Friend")
  game.UnlockTrophy(6)
end
