local LD = require("design.LevelDesignLibrary")
local player, pad
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  pad = player.Pad
end
function OnStart(level)
  HideFX()
end
function HideFX()
  GameObjects.Epilogue_FX:Hide()
end
function PlayFX()
  GameObjects.Epilogue_FX:Show()
  GameObjects.Epilogue_FX:PlayAnimToEnd()
  GameObjects.epilogue_roof_break.Child:PlayAnimToEnd()
  local houseLevel = game.FindLevel("For200_House")
  houseLevel:CallScript("CallScriptVisibility", "House_Roof_Hires_Pristine", false)
  GameObjects.CA_InsideHouse.LuaObjectScript.Disable()
end
function ResetRoof()
  GameObjects.epilogue_roof_break.Child:JumpAnimToFrame(0)
  GameObjects.epilogue_roof_break.Child:PauseAnim()
end
function OnCreditsDone()
  GameObjects.CA_StandInPlace.LuaObjectScript.Enable()
  ResetRoof()
  local cineWad = game.FindLevel("For200_House")
  if cineWad ~= nil then
    cineWad:CallScript("AfterCredits")
  end
  EZE_InpuMaskHouseInt_Off()
  EZE_InpuMaskHouseInt_On()
end
function UseDoorEnterCA()
  GameObjects.CA_InsideHouse.LuaObjectScript.Enable()
end
function RemoveSonIdleCA()
  GameObjects.CA_StandInPlace.LuaObjectScript.Disable()
end
function EZE_InpuMaskHouseInt_On()
  pad:EnableGameButton(tweaks.ePad.kPadCircle)
  pad:DisableGameButton(tweaks.ePad.kPadSquare)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadUp)
  pad:DisableGameButton(tweaks.ePad.kPadLeft)
  pad:DisableGameButton(tweaks.ePad.kPadDown)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  pad:DisableGameButton(tweaks.ePad.kPadR3)
end
function EZE_InpuMaskHouseInt_Off()
  if not game.Cinematics.IsInCinematicMode() then
    pad:ClearAllDisabledGameButtons()
  end
end
