local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local uiCalls = require("ui.uicalls")
local DL = require("design.DesignerLibrary")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local CCOS = require("camera.camera_oneshot")
local thisLevel, player, houseZone, HouseZoneMonitor, camOneShotLookMountain010, camOneShotLookMountain020
local varClimbPathUnblocked = false
local var5mDropLearned = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  houseZone = GameObjects.Zone_CheckPlayerProgression
  HouseZoneMonitor = monitors.CreateEntityZoneMonitor(player, houseZone)
  HouseZoneMonitor:OnEnter(function()
    CheckPlayerProgression()
    EnableForestLeadTheway()
  end)
  SoundInit()
end
function OnFirstStart(level)
  GameObjects.NGP_Hint:HideEntityVolume()
  GameObjects.for200_balder_roof_sequence_static:Hide()
  GameObjects.SCRIPT_Ground_Post_Baldur:Hide()
  GameObjects.SCRIPT_Ground_Post_Baldur:HideCollision()
  GameObjects.crt_deep_snow_Composite_post_baldur:Hide()
  GameObjects.ClimbPath_5M_ClimpUp:HideTraversePath()
  HideTrapDoorRug()
  GameObjects.trapDoorRug00RBCineOnly:Hide()
end
function HideTrapDoorRug()
  GameObjects.trapDoorRug10A:Hide()
end
function ShowTrapDoorRug()
  local rug = GameObjects.trapDoorRug10A
  rug:Show()
  rug.Child:StartAnim("narForBaldurIntro000Cine")
  rug.Child:JumpAnimToFrame(0)
  rug.Child:PauseAnim()
end
function EnableBedInteract()
  GameObjects.InteractZone_Epilogue.LuaObjectScript.Enable()
end
function ActivateClimbUp()
  if game.Level.GetVariable("CompletedCineNumber") > 380 then
    GameObjects.ClimbPath_5M_ClimpUp:ShowTraversePath()
    GameObjects.FakeClimbInteract.LuaObjectScript.Disable()
    GameObjects.NGP_Hint:HideEntityVolume()
    HideHint_NGP_Gated()
  else
    GameObjects.FakeClimbInteract.LuaObjectScript.Enable()
    GameObjects.FakeClimbInteract.LuaObjectScript.GetInteractZone():Lock()
    GameObjects.NGP_Hint:ShowEntityVolume()
    varClimbPathUnblocked = true
  end
end
function ShowHint_NGP_Gated()
  local varNGP = game.GetNewGamePlus()
  if varNGP == true then
    local varCineNum = game.Level.GetVariable("CompletedCineNumber")
    if varCineNum < 380 and (varCineNum < 80 or 100 <= varCineNum) and varClimbPathUnblocked == true then
      uiCalls.SendBottomDesignerMessage({
        Text = 44619,
        DisplayTime = 6,
        Critical = true
      })
    end
  end
end
function HideHint_NGP_Gated()
  local varNGP = game.GetNewGamePlus()
  if varNGP == true then
    local varCineNum = game.Level.GetVariable("CompletedCineNumber")
    if varCineNum < 380 and (varCineNum < 80 or 100 <= varCineNum) and varClimbPathUnblocked == true then
      uiCalls.UI_Event_TurnOffDesignerMessage()
    end
  end
end
function Lock_Traversal_NGP()
  GameObjects.FakeClimbInteract.LuaObjectScript.GetInteractZone():Lock()
end
function OnStart()
  CheckPlayerProgression()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if var5mDropLearned == false then
    GameObjects.flammablebramble_Wall.Child:HideBehaviors()
  end
  if varClimbPathUnblocked == true then
    if game.Level.GetVariable("CompletedCineNumber") > 380 then
      GameObjects.FakeClimbInteract.LuaObjectScript.Disable()
      GameObjects.ClimbPath_5M_ClimpUp:ShowTraversePath()
    else
      GameObjects.FakeClimbInteract.LuaObjectScript.GetInteractZone():Lock()
    end
  else
    GameObjects.FakeClimbInteract.LuaObjectScript.Disable()
  end
  if cineNumber == 370 or cineNumber == 375 then
    GameObjects.SCRIPT_ArenaBlocker:PlayAnimToEnd(-1)
    LD.CallFunctionAfterDelay(function()
      GameObjects.FastTravel_For200.LuaObjectScript.Disable()
      GameObjects.FastTravel_For200.Child:HideEntityVolume()
    end, 3)
  end
  if cineNumber == 20 then
    game.AI.FindSon():CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
  end
  if cineNumber < 65 then
    GameObjects.EntZn_EnableBackYardZones:HideEntityVolume()
    GameObjects.EntZn_ToFrontDoor:HideEntityVolume()
  end
  if 400 <= cineNumber then
    GameObjects.FastTravel_For200:ShowEntityVolume()
    if GameObjects.FastTravel_For200.Child ~= nil then
      GameObjects.FastTravel_For200.Child:ShowEntityVolume()
    end
  end
  if 100 < cineNumber then
    GameObjects.For200_House_Zone_4:ShowEntityVolume()
    GameObjects.LTW_NearRealmTravel.LuaObjectScript.Enable()
  else
    GameObjects.For200_House_Zone_4:HideEntityVolume()
    local FrontDoor_Interact = GameObjects.KratosHouseDoorA.LuaObjectScript.GetFrontInteractZone()
    FrontDoor_Interact:SetOnScreenPercent(0.4)
    FrontDoor_Interact:SetHintXZRange(10)
  end
  local for400 = game.FindLevel("For400_Intersection")
  if for400 == nil then
    GameObjects.For400_Cheap:Show()
  else
    GameObjects.For400_Cheap:Hide()
  end
  SoundOnStart()
end
function OnUpdate(level)
  if camOneShotLookMountain010 ~= nil then
    camOneShotLookMountain010:Update()
  end
  if camOneShotLookMountain020 ~= nil then
    camOneShotLookMountain020:Update()
  end
end
function AfterCredits()
  game.Audio.StartMusic("SND_MX_credits_roll_02_out")
  game.Audio.SetWwiseState("Credits", "out")
  uiCalls.UI_Event_Fade_In(1.5)
  game.UI.Idle(false)
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  game.UI.Anim(GameObjects.PresentDayMessageTO, 0, "", 1, 0)
  HideTrapDoorRug()
  LD.CallFunctionAfterDelay(function()
    GameObjects.KratosHouseDoorA.Child.LuaObjectScript.Enable()
    game.Audio.PlayBanter("Post Game")
  end, 3.5)
end
function EnableDoorCineInteract()
  GameObjects.KratosHouseDoorA.Child.LuaObjectScript.Enable()
end
function RemoveBurnableCollision()
  if not varClimbPathUnblocked then
    GameObjects.Blade_BurnBarrier_Wall:HideCollision()
  end
end
function RestoreBurnableCollision()
  if not varClimbPathUnblocked then
    GameObjects.Blade_BurnBarrier_Wall:ShowCollision()
  end
end
function DropLogs()
  if LD.GetEntityVariable("FOR_BackyardClear") == true then
    uiCalls.UI_Event_TurnOffDesignerMessage()
  end
  PlayAxeTargetSound()
  PlayLogsHitGround()
  LD.SetEntityVariable("FOR_LogDropClear", true)
  LD.CallFunctionAfterDelay(function()
    game.FindLevel("For250_ChiselSite"):CallScript("CA_Ready2Drop")
  end, 0.1)
end
function EnableBackyardDrop()
end
function DroppedIntoBackyard()
  if game.Level.GetVariable("CompletedCineNumber") == 72 then
    GameObjects.flammablebramble_Wall.Child:ShowBehaviors()
    var5mDropLearned = true
  end
end
function AnimateBreakables()
  GameObjects.roof_trim_break.Child:JumpAnimToFrame(0)
  GameObjects.for200_house_firsthit_landing.Child:JumpAnimToFrame(0)
  GameObjects.roof_trim_break.Child:PlayAnimToEnd()
  GameObjects.for200_house_firsthit_landing.Child:PlayAnimToEnd()
end
function AffrivedFromFastTravel()
  GameObjects.CA_syncexithelper_RealmTravel.LuaObjectScript.Enable()
  print("AffrivedFromFastTravel")
  game.Compass.SetDesignerForcedHide(true)
end
function CallScriptAnim(level, objectName, animType)
  if animType == "play" then
    DL.PlayObjectAnimationChild(thisLevel, objectName)
  elseif animType == "reset" then
    DL.ResetObjectAnimationChild(thisLevel, objectName)
  elseif animType == "finish" then
    DL.FinishObjectAnimationChild(thisLevel, objectName)
  end
end
function CallScriptAnimFrames(level, objectName, startFrame, endFrame)
  local objToAnim = level:FindSingleGameObject(objectName).Child
  objToAnim:JumpAnimToFrame(startFrame)
  objToAnim:PlayAnimToFrame(endFrame)
end
function CallScriptVisibility(level, objectName, isVisible)
  if isVisible then
    DL.ShowLevelObject(thisLevel, objectName)
  else
    DL.HideLevelObject(thisLevel, objectName)
  end
end
function OnSaveCheckpoint(level)
  local savedInfo = {
    levelstate = checkpoint.Save(),
    varClimbPathUnblocked = varClimbPathUnblocked,
    var5mDropLearned = var5mDropLearned
  }
  return savedInfo
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  varClimbPathUnblocked = savedInfo.varClimbPathUnblocked or false
  var5mDropLearned = savedInfo.var5mDropLearned or false
end
function CheckPlayerProgression()
  local CineNum = game.Level.GetVariable("CompletedCineNumber")
  if 30 <= CineNum then
    if CineNum < 400 then
      GameObjects.Gates_Into_Forest:JumpAnimToFrame(1)
      GameObjects.Gates_Into_Forest:PauseAnim()
    else
      GameObjects.Gates_Into_Forest:JumpAnimToFrame(0)
      GameObjects.Gates_Into_Forest:PauseAnim()
    end
  end
  if CineNum <= 78 then
    BulderTerrainSwitchBack()
  end
  if 100 <= CineNum then
    GameObjects.for200_balder_roof_sequence_static:Show()
    if CineNum < 370 then
      BulderTerrainSwitch()
      GameObjects.SCRIPTED_Mountains:Hide()
    else
      BulderTerrainSwitchBack()
      GameObjects.SCRIPTED_Mountains:Show()
    end
  end
end
function EnableForestLeadTheway()
  local for000_sky = game.FindLevel("For000_Sky")
  for000_sky:CallScript("For200_EnableLeadAndNoPassOnly")
end
function ShowBrokenRoof()
  GameObjects.for200_balder_roof_sequence_static:Show()
end
function BulderTerrainSwitch()
  GameObjects.SCRIPT_Ground_Post_Baldur:Show()
  GameObjects.SCRIPT_Ground_Post_Baldur:ShowCollision()
  GameObjects.crt_deep_snow_Composite_post_baldur:Show()
  GameObjects.SCRIPT_Ground_Pre_Baldur:Hide()
  GameObjects.SCRIPT_Ground_Pre_Baldur:HideCollision()
  GameObjects.crt_deep_snow_composite_pre_baldur:Hide()
  GameObjects.NGO_col_TrenchCover:HideCollision()
end
function BulderTerrainSwitchBack()
  GameObjects.SCRIPT_Ground_Post_Baldur:Hide()
  GameObjects.SCRIPT_Ground_Post_Baldur:HideCollision()
  GameObjects.crt_deep_snow_Composite_post_baldur:Hide()
  GameObjects.SCRIPT_Ground_Pre_Baldur:Show()
  GameObjects.SCRIPT_Ground_Pre_Baldur:ShowCollision()
  GameObjects.crt_deep_snow_composite_pre_baldur:Show()
  GameObjects.NGO_col_TrenchCover:ShowCollision()
end
function UpdateLoadGroup_TimeToGo()
  print("!!!! UpdateLoadGroup_TimeToGo: " .. tostring(game.Level.GetVariable("CompletedCineNumber")))
  if game.Level.GetVariable("CompletedCineNumber") == 80 and player:HasMarker("ReadyForTimeToGo") then
    game.Level.SetVariable("CompletedCineNumber", 99)
  end
  game.EvaluateLoadZones()
end
function OnEvaluateLoadGroup_Cinematic()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 60 then
    return "MothersKnifeCine"
  elseif cineNum < 78 then
    return "AshesGatheredCine"
  elseif cineNum < 80 then
    return "BaldurIntroCine"
  elseif cineNum == 80 then
    return "BaldurBoss"
  elseif cineNum == 99 then
    return "TimeToGoCine"
  elseif 100 <= cineNum and cineNum <= 370 then
    return "NoCine"
  elseif 370 < cineNum and cineNum <= 380 then
    return "RetrieveBladesCine"
  elseif 380 < cineNum and cineNum <= 600 then
    return "EpilogueCine"
  elseif 600 < cineNum then
    return "EpilogueCine"
  else
    return "NoCine"
  end
end
function OnEvaluateLoadGroup_CineWad()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 100 then
    return "Baldur"
  else
    return "EndGame"
  end
end
function OnEvaluateLoadGroup_Backyard()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 60 then
    return "MothersKnifeCine"
  elseif cineNum < 78 then
    return "AshesGatheredCine"
  elseif cineNum < 80 then
    return "BaldurIntroCine"
  elseif cineNum == 80 then
    return "BaldurBoss"
  elseif cineNum == 99 then
    return "TimeToGoCine"
  elseif 100 <= cineNum and cineNum <= 370 then
    return "NoCine"
  elseif 370 < cineNum and cineNum <= 380 then
    return "RetrieveBladesCine"
  elseif 380 < cineNum then
    return "EpilogueCine"
  else
    return "NoCine"
  end
end
function Quest_ReturnHome_Objective1_Complete()
  print("if we ever want to add in an objective for interacting with the bed, this is the spot")
end
function CA_BackYard_Start()
  GameObjects.EntZn_CA_EnableBackyard:ShowEntityVolume()
  GameObjects.EntZn_ToFrontDoor:ShowEntityVolume()
  CA_BackYard_Enable()
end
function CA_BackYard_Enable()
  GameObjects.LTW_BackYard.LuaObjectScript.Enable()
  CA_FrontYard_Disable()
end
function CA_FrontYard_Enable()
  GameObjects.CA_Idle_WaitNearFront.LuaObjectScript.Enable()
end
function CA_FrontYard_Disable()
  GameObjects.CA_Idle_WaitNearFront.LuaObjectScript.Disable()
end
function QuestRiverPassParentStart()
  StartMountainCameraSequence()
  timer.StartLevelTimer(1, function()
    player:SetMaxSpeedOverride(1.5)
  end)
  timer.StartLevelTimer(9, function()
    player:ClearMaxSpeedOverride()
  end)
  timer.StartLevelTimer(1, function()
    game.Audio.PlayBanter("455_MountainGoal")
  end)
end
function StartMountainCameraSequence()
  camOneShotLookMountain010 = CCOS.OneShotCamera.New("PLYR_Vista_GoToTheMountain_010", 1.5)
  camOneShotLookMountain020 = CCOS.OneShotCamera.New("PLYR_Vista_GoToTheMountain_020", 8.5)
  camOneShotLookMountain020:SetCallback(DestroyMountainCamera)
  camOneShotLookMountain010:Start()
  camOneShotLookMountain020:Start()
end
function DestroyMountainCamera()
  timer.StartLevelTimer(1, function()
    game.UI.Idle(false)
  end)
  print("CAMERA: Destroy trench open cameras ENV_Vista_TrenchReveal_010 and ENV_Vista_TrenchReveal_020")
  camOneShotLookMountain010 = nil
  camOneShotLookMountain020 = nil
end
function DisableFT()
  GameObjects.FastTravel_For200.LuaObjectScript.Disable()
  GameObjects.FastTravel_For200.Child:HideEntityVolume()
end
function ReEnableFT()
  GameObjects.FastTravel_For200.LuaObjectScript.Enable()
  GameObjects.FastTravel_For200.Child:ShowEntityVolume()
end
function For200_EnableLeadTheWay()
  timer.StartLevelTimer(6, For200_EnableLeadTheWay_PostTimer)
end
function For200_EnableLeadTheWay_PostTimer()
  if game.Level.GetVariable("CompletedCineNumber") <= 20 then
    GameObjects.Cine_MothersKnife.LuaObjectScript:StoreLeadTheWayVars()
    GameObjects.Cine_MothersKnife.LuaObjectScript:EnableLeadTheWay()
  end
end
function For200_Bookmark_GroundSwap()
  BulderTerrainSwitch()
end
local soundLogEmitter, soundAxeTargetEmitter, soundPyreFire, houseEmitters
local pyreFire = false
local doorSoundOverride = {
  OnInteractForward_Center = "SND_Door_Wood_Freya_House_Pull_Open",
  OnInteractBackward_Center = "SND_Door_Wood_Freya_House_Pull_Open",
  OnInteractClose_Center = "SND_Door_Wood_Freya_House_Pull_Close",
  OnInteractCloseFrameDelay = 100
}
function SoundInit()
  soundLogEmitter = GameObjects.log_drop:FindSingleSoundEmitterByName("SNDLogDropBlock")
  soundAxeTargetEmitter = GameObjects.BasicAxeTargetGroup:FindSingleSoundEmitterByName("SNDBasicAxeTarget")
  soundPyreFire = GameObjects.SNDForest200Emitters:FindSingleSoundEmitterByName("SNDFuneralPyreFor200")
  houseEmitters = GameObjects.SNDForest200HouseEmitters
  houseEmitters:Hide()
end
function SoundOnStart()
  if game.Level.GetVariable("CompletedCineNumber") >= 20 and game.Level.GetVariable("CompletedCineNumber") < 78 then
    LD.PlayRestartableSoundLoop(soundPyreFire, "SND_AMB_EMIT_FIRE_Pit_Burning_LP_For200")
  end
  GameObjects.House_Ext:FindSingleGOByName("KratosHouseDoorA").LuaObjectScript.SoundSetup(doorSoundOverride)
end
function PlayAxeTargetSound()
  LD.PlaySound(soundAxeTargetEmitter, "SND_BRK_Pulley_Logs_Latch_Release_For250")
end
function PlayLogsHitGround()
  LD.PlaySoundOnFrame(soundLogEmitter, GameObjects.log_drop, "SND_BRK_Pulley_Logs_Hit_Ground_For250", 26, "forward")
end
function LuaHook_PyreFire_For200(level)
  LD.PlayRestartableSoundLoop(soundPyreFire, "SND_AMB_EMIT_FIRE_Pit_Burning_LP_For200")
end
function pyreFireOff()
  if game.Level.GetVariable("CompletedCineNumber") >= 72 and game.Level.GetVariable("CompletedCineNumber") < 78 and pyreFire == false then
    LD.StopRestartableSoundLoop(soundPyreFire, "SND_AMB_EMIT_FIRE_Pit_Burning_LP_For200")
    print("pyre fire off")
    pyreFire = true
  end
end
function ShowHouseEmitters()
  houseEmitters:Show()
end
function HideHouseEmitters()
  houseEmitters:Hide()
end
