local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, son, kratosActor, sonActor, cine_lights_78, candlesA, candlesB, candlesC, tableA, body, mistletoeleaves
local ashes = GameObjects.ashesPouch00_AshesGathered.Child
local cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  cine_lights_78 = GameObjects.Cine_Start_78
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  HideCineLights()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 72 <= cineNum and cineNum < 78 then
    CreateActors()
    ashes:Hide()
    EnableDoor()
  end
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function CreateActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function BuildAshesGatheredSequence()
  game.UI.LoadCheck("For200_c078_AshesGathered")
  HideTable()
  local cloth = GameObjects.retrieveBladesCloth
  cloth:JumpAnimToFrame(0)
  cloth:PauseAnim()
  local doorObj = GameObjects.KratosHouseDoorA.Child
  local ashes = GameObjects.ashesPouch00_AshesGathered.Child
  ashes:Hide()
  local ashesGatheredSeq = ND.CreateCineSequence(thisLevel, thisObj, "ashesGathered")
  local ashesGathered_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_AshesGathered"
    },
    {
      Obj = doorObj,
      Anim = "narForAshesGathered000CineScene"
    },
    {
      Obj = ashes,
      Anim = "narForAshesGathered000CineScene"
    }
  }
  GameObjects.KratosHouseDoorA.Child.LuaObjectScript.EnableCinematicTrigger()
  ashesGatheredSeq:SetPostSkipMusic("SND_MX_PRO_start_master")
  ashesGatheredSeq:MarkAbleToSkip()
  ashesGatheredSeq:RequestCineModeAndWait(kratosActor, thisObj)
  ashesGatheredSeq:Do(function()
    son:Warp(GameObjects.Cine_AshesGathered_Son_StartLoc:GetWorldPosition(), GameObjects.Cine_AshesGathered_Son_StartLoc:GetWorldForward())
  end)
  ashesGatheredSeq:Do(PlayCineLights)
  ashesGatheredSeq:Do(StartCineEnter_AshesGathered)
  ashesGatheredSeq:Do(DisableFaceSwapping)
  ashesGatheredSeq:WaitForLoadCheck("For200_c078_AshesGathered")
  ashesGatheredSeq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_AshesGathered",
    ReferenceJoint = "AshesGathered_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.InteractStopDistance,
    should_strafe = true,
    weapon_state = "bare_on_back"
  })
  ashesGatheredSeq:Do(SwapAshes1)
  ashesGatheredSeq:Do(_G.ShowTrapDoorRug)
  ashesGatheredSeq:ActorSync(kratosActor, {
    Slaves = ashesGathered_ActorTable,
    Branch = "BRA_AshesGathered",
    ReferenceJoint = "AshesGathered_SyncJoint"
  })
  ashesGatheredSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.1)
  ashesGatheredSeq:Do(ShowPouch)
  ashesGatheredSeq:WaitUntilActorAnimPastPercentage(sonActor, 0.8)
  ashesGatheredSeq:Do(SonIdleSequence)
  ashesGatheredSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.85)
  ashesGatheredSeq:Do(HidePouch)
  ashesGatheredSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  ashesGatheredSeq:StopPuppetingActor(kratosActor)
  ashesGatheredSeq:Do(EnableFaceSwapping)
  ashesGatheredSeq:SetCompletedCineNumber(78)
  ashesGatheredSeq:Do(HideCineLights)
  ashesGatheredSeq:Do(SwapAshes2)
  ashesGatheredSeq:Do(EnableInteractDisableDoor)
  ashesGatheredSeq:Do(_G.UpdateLoadGroup_TimeToGo)
  ashesGatheredSeq:Do(function()
    LD.CallFunctionAfterDelay(function()
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "01_Forest_050_BaldurStart"]
      tableEntry.OverrideObject = GameObjects.CO_AshesGathered
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end, 0.5)
  end)
  ashesGatheredSeq:StartSequence()
end
function DisableFaceSwapping()
  if game.PhotoMode.SetFaceChangeEnabled then
    game.PhotoMode.SetFaceChangeEnabled(false)
  end
end
function EnableFaceSwapping()
  if game.PhotoMode.SetFaceChangeEnabled then
    game.PhotoMode.SetFaceChangeEnabled(true)
  end
end
function SonIdleSequence()
  local cineSeqIdle = LD.CreateCineSequence(thisLevel, thisObj, "BaldurIntroIdle")
  cineSeqIdle:ActorSync(sonActor, {
    Branch = "BRA_AshesGatheredIdleFromCine",
    ReferenceJoint = "AshesGathered_SyncJoint2"
  })
  cineSeqIdle:StartSequence()
end
function SwapAshes1()
  local cineWad = game.FindLevel("For200_c080_BaldurIntro")
  if cineWad ~= nil then
    cineWad:CallScript("HideAshes")
  end
end
function SwapAshes2()
  local cineWad = game.FindLevel("For200_c080_BaldurIntro")
  if cineWad ~= nil then
    cineWad:CallScript("UnhideAshes")
  end
end
function EnableInteractDisableDoor()
  print("========= DISABLE DOOR FROM ASHES GATHERED ========")
  GameObjects.InteractZone_BaldurIntro.LuaObjectScript.Enable()
  local kratosHouseDoor = GameObjects.KratosHouseDoorA.Child
  kratosHouseDoor.LuaObjectScript.Disable()
end
function EnableDoor()
  print("========= ENABLE DOOR FROM ASHES GATHERED ========")
  local kratosHouseDoor = GameObjects.KratosHouseDoorA.Child
  kratosHouseDoor.LuaObjectScript.Enable()
end
function PlayCineLights()
  cine_lights_78:Show()
  cine_lights_78:JumpAnimToFrame(0)
  cine_lights_78:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_78:Hide()
  ashes:Hide()
end
function ShowPouch()
  ashes:Show()
end
function HidePouch()
  ashes:Hide()
end
function HideTable()
  candlesA = GameObjects.mothersCandles00A.Child
  candlesB = GameObjects.mothersCandles00B.Child
  candlesC = GameObjects.smallCandle00A.Child
  tableA = GameObjects.mothersTable00A.Child
  body = GameObjects.motherBody00A.Child
  mistletoeleaves = GameObjects.mistletoeLeaves00A.Child
  candlesA:Hide()
  candlesB:Hide()
  candlesC:Hide()
  tableA:Hide()
  body:Hide()
  mistletoeleaves:Hide()
  ashes:Show()
end
function StartCineEnter_AshesGathered()
  game.SubObject.Wake(thisObj)
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_AshesGathered", 8)
  cameraCineEnter:SetCallback(DestroyCineEnter_AshesGathered)
  cameraCineEnter:Start()
end
function DestroyCineEnter_AshesGathered()
  cameraCineEnter = nil
  game.SubObject.Sleep(thisObj)
end
