local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local timer = require("level.timer")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, balActor
baldurIntroComplete = false
local cine_lights_80, candlesA, candlesB, candlesC, tableA, body, mistletoeleaves, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 72 <= cineNum and cineNum < 78 then
    SetUpLights()
  else
    HideCineLights()
  end
  if cineNum == 78 then
    BaldurIntroIdleSequence()
    DisableDoor()
    SetUpLights()
  end
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function SpawnBaldur()
  balActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_BaldurIntro", "BaldurIntro_Bal_StartJoint", "CRT_Baldur00", "BRA_BaldurIntro", "baldur")
  end)
end
function SetupKratosAndSonActors()
  kraActor = actor.Actor.New("BALDUR INTRO: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("BALDUR INTRO: Son Actor", game.AI.FindSon)
  local cloth = GameObjects.retrieveBladesCloth
  cloth:JumpAnimToFrame(0)
end
function SetupBaldurActor()
  local for300Level = game.FindLevel("For300_BossArena")
  local baldurGameObjects = for300Level:FindGameObjectsByMarker("Baldur")
  local baldur = baldurGameObjects[1]
  balActor = actor.Actor.New("BALDUR INTRO: Baldur Actor", function()
    return baldur
  end)
end
function BaldurIntroIdleSequence()
  GameObjects.InteractZone_BaldurIntro.LuaObjectScript.Enable()
  LD.DisableContextBehaviorBanter()
  SetupKratosAndSonActors()
  HideTable()
  local cineSeqIdle = LD.CreateCineSequence(thisLevel, thisObj, "BaldurIntroIdle")
  local baldurIntroIdle_ActorTable = {}
  cineSeqIdle:ActorSync(sonActor, {
    Slaves = baldurIntroIdle_ActorTable,
    Branch = "BRA_AshesGatheredIdle",
    ReferenceJoint = "AshesGathered_SyncJoint1"
  })
  cineSeqIdle:StartSequence()
end
function BaldurIntroSequence()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 78 <= cineNumber and cineNumber < 80 then
    game.UI.LoadCheck("For200_c080_BaldurIntro", "For300_BossArena", "For310_BossAssets")
    SetupKratosAndSonActors()
    SetupBaldurActor()
    HideTable()
    local cloth = GameObjects.retrieveBladesCloth
    cloth:JumpAnimToFrame(0)
    cloth:PauseAnim()
    local doorObj = GameObjects.KratosHouseDoorA.Child
    local trapdoorObj = GameObjects.houseTrapDoor.Child
    _G.HideTrapDoorRug()
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "BaldurIntro")
    local baldurIntro_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_BaldurIntro"
      },
      {
        Actor = balActor,
        Branch = "BRA_BaldurIntro"
      },
      {
        Obj = doorObj,
        Anim = "narForBaldurIntro000Cine"
      },
      {
        Obj = trapdoorObj,
        Anim = "narForBaldurIntro000Cine"
      }
    }
    cineSeq:SetPostSkipMusic("SND_MX_PRO_start_master")
    cineSeq:MarkAbleToSkip()
    cineSeq:RequestCineModeAndWait(kraActor, thisObj)
    cineSeq:Do(StartCineEnter_BaldurIntro)
    cineSeq:Do(ShowForcedCombatCamera)
    cineSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_BaldurIntro",
      ReferenceJoint = "BaldurIntro_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.InteractStopDistance,
      should_strafe = true,
      weapon_state = "bare_on_back"
    })
    cineSeq:Do(PlayCineLights)
    cineSeq:Do(AnimateBreakables)
    cineSeq:Do(CallRug)
    cineSeq:ActorSync(kraActor, {
      Slaves = baldurIntro_ActorTable,
      Branch = "BRA_BaldurIntro",
      ReferenceJoint = "BaldurIntro_SynchJoint"
    })
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.98)
    cineSeq:Do(function()
      cineSeq:SetMaxSkipSpeedup(3)
    end)
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.997)
    cineSeq:Do(function()
      cineSeq:EndSkipIfActive()
    end)
    cineSeq:WaitForActorMoveComplete(balActor)
    cineSeq:StopPuppetingActor(balActor)
    cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:Do(HideCineLights)
    cineSeq:Do(HideRug)
    cineSeq:Do(DisableDoor)
    cineSeq:Do(function()
      if baldurIntroComplete == false then
        baldurIntroComplete = true
      end
    end)
    cineSeq:SetCompletedCineNumber(80)
    cineSeq:Do(HideForcedCombatCamera)
    cineSeq:Do(CompleteReturnHomeQuest)
    cineSeq:StartSequence()
  end
end
function CompleteReturnHomeQuest()
  game.QuestManager.ProposeQuestState("Quest_Forest_Objective800", "Complete")
end
function DisableDoor()
  local kratosHouseDoor = GameObjects.KratosHouseDoorA.Child
  kratosHouseDoor.LuaObjectScript.Disable()
end
function AnimateBreakables()
  GameObjects.roof_trim_break.Child:JumpAnimToFrame(0)
  GameObjects.for200_house_firsthit_landing.Child:JumpAnimToFrame(0)
  GameObjects.roof_trim_break.Child:PlayAnimToEnd()
  GameObjects.for200_house_firsthit_landing.Child:PlayAnimToEnd()
end
function CallRug()
  local For200c080 = game.FindLevel("For200_c080_BaldurIntro")
  if For200c080 ~= nil then
    local cine_BaldurRug_Obj = For200c080:GetGameObject("BaldurRug_Group")
    cine_BaldurRug_Obj:CallScript("PlayBaldurRug")
  end
end
function HideRug()
  _G.ShowTrapDoorRug()
  local For200c080 = game.FindLevel("For200_c080_BaldurIntro")
  if For200c080 ~= nil then
    local cine_BaldurRug_Obj = For200c080:GetGameObject("BaldurRug_Group")
    cine_BaldurRug_Obj:CallScript("HideBaldurRug")
  end
end
function SetUpLights()
  cine_lights_80 = GameObjects.Cine_Start_80
  cine_lights_80:Show()
  cine_lights_80:JumpAnimToFrame(0)
  cine_lights_80:PauseAnim()
end
function PlayCineLights()
  cine_lights_80:JumpAnimToFrame(0)
  cine_lights_80:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_80 = GameObjects.Cine_Start_80
  cine_lights_80:Hide()
end
function HideTable()
  candlesA = GameObjects.mothersCandles00A.Child
  candlesB = GameObjects.mothersCandles00B.Child
  candlesC = GameObjects.smallCandle00A.Child
  tableA = GameObjects.mothersTable00A.Child
  body = GameObjects.motherBody00A.Child
  mistletoeleaves = GameObjects.mistletoeLeaves00A.Child
  candlesA:Hide()
  candlesB:Hide()
  candlesC:Hide()
  tableA:Hide()
  body:Hide()
  mistletoeleaves:Hide()
end
function StartCineEnter_BaldurIntro()
  game.SubObject.Wake(thisObj)
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_BaldurIntro", 8)
  cameraCineEnter:SetCallback(DestroyCineEnter_BaldurIntro)
  cameraCineEnter:Start()
end
function DestroyCineEnter_BaldurIntro()
  cameraCineEnter = nil
  game.SubObject.Sleep(thisObj)
end
function ShowForcedCombatCamera()
  local forcedcamera = thisLevel:GetGameObject("CamZone_Baldur_ForcedCombatCam")
  assert(forcedcamera)
  forcedcamera:ShowCameraVolume()
end
function HideForcedCombatCamera()
  local forcedcamera = thisLevel:GetGameObject("CamZone_Baldur_ForcedCombatCam")
  assert(forcedcamera)
  timer.StartLevelTimer(4.56, function()
    forcedcamera:HideCameraVolume()
  end)
end
