local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local player
player = game.Player.FindPlayer()
function CineDoorInteraction()
  local for200 = game.FindLevel("For200_House")
  local cineObj
  local doorObj = GameObjects.KratosHouseDoorA.Child
  if for200 ~= nil then
    if game.Level.GetVariable("CompletedCineNumber") >= 72 and game.Level.GetVariable("CompletedCineNumber") < 78 then
      _G.CA_FrontYard_Disable()
      doorObj.LuaObjectScript.EnableCinematicTrigger()
      cineObj = for200:FindSingleGameObject("Cine_AshesGathered")
      cineObj:CallScript("BuildAshesGatheredSequence")
      _G.ShowTrapDoorRug()
    elseif game.Level.GetVariable("CompletedCineNumber") >= 80 and game.Level.GetVariable("CompletedCineNumber") < 100 then
      doorObj.LuaObjectScript.EnableCinematicTrigger()
      cineObj = for200:FindSingleGameObject("Cine_TimeToGo")
      cineObj:CallScript("PlayTimeToGoCine")
      _G.ShowBrokenRoof()
    elseif game.Level.GetVariable("CompletedCineNumber") >= 375 and game.Level.GetVariable("CompletedCineNumber") < 380 then
      doorObj.LuaObjectScript.EnableCinematicTrigger()
      cineObj = for200:FindSingleGameObject("Cine_RetrieveBlades")
      cineObj:CallScript("BuildCineSequence")
    elseif game.Level.GetVariable("CompletedCineNumber") == 610 then
      game.Audio.PlayBanter("030_HomeAtLast")
      game.FindLevel("For200_c620_Epilogue"):CallScript("UseDoorEnterCA")
      _G.ShowTrapDoorRug()
      _G.EnableBedInteract()
      game.Compass.SetDesignerForcedHide(true)
      uiCalls.UI_Event_Turn_Combat_HUD_Off()
      LD.CallFunctionAfterDelay(function()
        GameObjects.KratosHouseDoorA.Child.LuaObjectScript.Disable()
      end, 0.1)
      LD.CallFunctionAfterDelay(function()
        if player:InsideZone(GameObjects.EntZn_HouseIntCineArea) then
          game.Audio.PlayBanter("030_HomeAtLast_Idle")
        end
      end, 22)
    end
  end
end
function PostEpilogueDoorInteraction()
  if game.Level.GetVariable("CompletedCineNumber") == 620 then
    game.FindLevel("For200_c620_Epilogue"):CallScript("RemoveSonIdleCA")
    LD.CallFunctionAfterDelay(function()
      GameObjects.KratosHouseDoorA.Child.LuaObjectScript.Disable()
      game.Compass.SetDesignerForcedHide(false)
      uiCalls.UI_Event_Turn_Combat_HUD_On()
    end, 1)
    LD.CallFunctionAfterDelay(function()
      game.World.StoreCheckpoint()
    end, 6)
  end
end
